# Consent (Advance Directives) (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Consent (Advance Directives) (HDR CZ)**

## Resource Profile: Consent (Advance Directives) (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_ConsentHdr |

 
This profile constrains the Consent resource for the purpose of representing Advance Directives in this project. 

 
This profile constrains the Consent resource to model Advance Directives, documenting a patient's future medical decisions. 

**Usages:**

* Derived from this Profile: [Consent Obligations (HDR CZ)](StructureDefinition-cz-consent-obl-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Consent/CZ-AdvanceDirectives-HDR-CORE](Consent-CZ-AdvanceDirectives-HDR-CORE.md) and [Consent/CZ-AdvanceDirectives-HDR-DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-consent-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-consent-hdr.csv), [Excel](StructureDefinition-cz-consent-hdr.xlsx), [Schematron](StructureDefinition-cz-consent-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-consent-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-consent-hdr",
  "version" : "0.1.0",
  "name" : "CZ_ConsentHdr",
  "title" : "Consent (Advance Directives) (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Consent resource for the purpose of representing Advance Directives in this project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the Consent resource to model Advance Directives, documenting a patient's future medical decisions.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Consent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent"
      },
      {
        "id" : "Consent.status",
        "path" : "Consent.status",
        "patternCode" : "active"
      },
      {
        "id" : "Consent.category",
        "path" : "Consent.category",
        "max" : "1",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ConsentCategory"
            }
          ],
          "strength" : "extensible",
          "description" : "A classification of the type of consents found in a consent statement.",
          "valueSet" : "https://hl7.cz/fhir/hdr/ValueSet/cz-consent-category"
        }
      },
      {
        "id" : "Consent.dateTime",
        "path" : "Consent.dateTime",
        "min" : 1
      },
      {
        "id" : "Consent.provision",
        "path" : "Consent.provision",
        "max" : "0"
      }
    ]
  }
}

```
