# Bundle (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Bundle (HDR CZ)**

## Resource Profile: Bundle (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_BundleHdr |

 
Clinical document used to represent a Hospital Discharge Report for the scope of this guide. 

### Content (cs)

#### Bundle (HDR CZ)

**Resource Bundle** představuje kompletní balíček všech zdrojů, které dohromady tvoří propouštěcí zprávu. Obsahuje jak hlavní dokumentovou kompozici (Composition), tak všechny související klinické a administrativní zdroje – například údaje o pacientovi, hospitalizační epizody, diagnózy, provedené výkony, výsledky vyšetření, medikaci, alergie, použité zdravotnické prostředky, pojištění a další.

Je určen pro přenos propouštěcí zprávy jako celku mezi systémy a zajišťuje konzistenci a úplnost dat.

* **Composition** – hlavička dokumentu, struktura a obsahové členění PZ.
* **Patient** – identifikace a základní údaje o pacientovi.
* **AllergyIntolerance** – záznamy o alergiích a intolerancích.
* **Condition** – diagnózy a zdravotní stavy pacienta.
* **Device & DeviceUseStatement** – použité zdravotnické prostředky a jejich aplikace.
* **DiagnosticReport, ImagingStudy, Observation, Specimen** – výsledky vyšetření, zobrazování a laboratorní nálezy.
* **Immunization** – provedená očkování.
* **Medication, MedicationRequest, MedicationStatement, MedicationDispense, MedicationAdministration** – předepsané, podané a vydané léky.
* **Encounter** – údaje o kontaktu pacienta se zdravotnickým zařízením.
* **Practitioner & PractitionerRole** – lékaři a ostatní zdravotničtí pracovníci, jejich role.
* **Organization** – organizace a zařízení podílející se na péči.
* **Procedure** – provedené zákroky a výkony.
* **FamilyMemberHistory** – relevantní rodinná anamnéza.
* **DocumentReference & Media** – připojené dokumenty a multimediální soubory.
* **Flag** – důležitá upozornění pro zdravotníky.
* **CarePlan & Goal** – plán péče a cíle léčby.
* **Consent** – dříve vyslovená přání.
* **Provenance** – informace o původu a autorství dat.
* **Coverage** – pojištění a úhradové údaje.
* **Signature** – digitální podpis balíčku.

#### Composition

Hlavní dokumentová struktura – obsahová osnova PZ: identifikace dokumentu, datum a čas vytvoření, autor a příjemce, členění do sekcí dle specifikace (např. Údaje o pacientovi, Diagnostický souhrn, Významné výkony, Výsledky vyšetření, Doporučení). Každá sekce obsahuje text a odkazy na podrobné zdroje.

#### Patient

Údaje o pacientovi: jméno, příjmení, rodné číslo / identifikátor pojištěnce, datum narození, pohlaví, adresa, kontakty, případně informace o zemřelém. Povinná část pro plnou identifikaci.

#### AllergyIntolerance

Záznamy o alergiích a intolerancích: látka nebo skupina látek, povaha reakce, závažnost a datum záznamu. Povinné u závažných reakcí, jinak možnost negativního záznamu.

#### Condition

Seznam diagnóz a zdravotních stavů: diagnóza při přijetí, hlavní propuštěcí diagnóza, komorbidity a komplikace, kódování dle ICD-10/SNOMED CT, časové určení. Vazba na sekce Diagnostický souhrn a Klinické shrnutí.

#### Device & DeviceUseStatement

Použité zdravotnické prostředky: implantáty, přístroje, pomůcky, identifikace výrobce, modelu, sériového čísla, doba použití a účel nasazení. Povinné při použití implantátu nebo významného prostředku.

#### DiagnosticReport, ImagingStudy, Observation, Specimen

Výsledky vyšetření a nálezů: laboratorní, zobrazovací a funkční vyšetření, indikace, metoda, datum, provádějící a interpretace. Specimen popisuje vzorky biologického materiálu.

#### Immunization

Záznamy o očkování provedeném během hospitalizace nebo relevantním pro aktuální stav: typ vakcíny, datum podání, výrobce, šarže a důvod podání.

#### Medication, MedicationRequest, MedicationStatement, MedicationDispense, MedicationAdministration

Kompletní přehled medikace: léky užívané před přijetím, předepsané při propuštění, podané během hospitalizace, vydané léky. Údaje o názvu, dávkování, cestě podání a době užívání. Odpovídá sekci Podstatná léčba.

#### Encounter

Údaje o kontaktu pacienta se zdravotnickým zařízením: datum a čas přijetí a propuštění, typ kontaktu, oddělení, účastníci péče, důvod hospitalizace, cílové umístění po propuštění. Vazba na sekce Průběh hospitalizace a Stav při propuštění.

#### Practitioner & PractitionerRole

Zdravotničtí pracovníci: identifikace lékařů a sester, role (ošetřující, konziliář, operatér), vazba na organizaci, ve které působí.

#### Organization

Zdravotnická zařízení: nemocnice, oddělení, ambulance, identifikátor, název, adresa, kontakty. Povinné pro hlavní poskytovatele v epizodě.

#### Procedure

Provedené zákroky a výkony: operace, invazivní výkony, významné intervence, datum, kód výkonu (např. CZ-DRG, ICHI). Vazba na sekci Významné výkony.

#### FamilyMemberHistory

Rodinná anamnéza: onemocnění příbuzných s možným vlivem na péči, diagnózy, vztah k pacientovi.

#### DocumentReference & Media

Připojené externí dokumenty a multimédia: starší lékařské zprávy, PDF nálezy, obrázky (rentgeny, fotodokumentace), odkazy na uložiště.

#### Flag

Důležitá upozornění: rizika (pád, infekce, agrese), speciální potřeby (tlumočník, dietní omezení).

#### CarePlan & Goal

Plán další péče a léčebné cíle: doporučení pro praktického lékaře nebo specialistu, rehabilitace, kontroly, plánovaná vyšetření. Vazba na sekci Doporučení.

#### Consent

záznamy o dříve vyslovených přáních pacienta, včetně údajů o typu, rozsahu a podmínkách jejich platnosti.

#### Provenance

Metadata o původu záznamů: kdo a kdy data vytvořil, změnil nebo schválil.

#### Coverage

Údaje o pojištění: pojišťovna, typ pojištění, identifikátor pojištěnce.

#### Signature

Digitální podpis: zajištění integrity a autenticity celé propouštěcí zprávy.

-------

**Usages:**

* Examples for this Profile: [Bundle/DischargeBundle-Novak-Petr-L1-core](Bundle-DischargeBundle-Novak-Petr-L1-core.md), [Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md) and [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-bundle-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bundle-hdr.csv), [Excel](StructureDefinition-cz-bundle-hdr.xlsx), [Schematron](StructureDefinition-cz-bundle-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bundle-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/bundle-eu-hdr"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr",
  "version" : "0.1.0",
  "name" : "CZ_BundleHdr",
  "title" : "Bundle (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Hospital Discharge Report for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Hospital Discharge Report bundle",
        "definition" : "Hospital Discharge Report bundle.",
        "constraint" : [
          {
            "key" : "bdl-hdr-1",
            "severity" : "error",
            "human" : "An IPS document must have no additional Composition (including Composition subclass) resources besides the first.",
            "expression" : "entry.tail().where(resource is Composition).empty()",
            "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "short" : "Instance identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "short" : "Instance identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            },
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Entry resource in the Hospital Discharge Report bundle",
        "definition" : "An entry resource included in the Hospital Discharge Report document bundle resource.",
        "comment" : "Must contain the HDR Composition as the first entry (only a single Composition resource instance may be included). Additional constraints are specified in the HDR Composition profile.",
        "min" : 2
      },
      {
        "id" : "Bundle.entry.link",
        "path" : "Bundle.entry.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:allergyIntolerance",
        "path" : "Bundle.entry",
        "sliceName" : "allergyIntolerance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:allergyIntolerance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "AllergyIntolerance",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:condition",
        "path" : "Bundle.entry",
        "sliceName" : "condition",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:condition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:device",
        "path" : "Bundle.entry",
        "sliceName" : "device",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:device.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Device",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:deviceUseStatement",
        "path" : "Bundle.entry",
        "sliceName" : "deviceUseStatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:deviceUseStatement.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DeviceUseStatement",
            "profile" : [
              "http://hl7.eu/fhir/hdr/StructureDefinition/deviceUseStatement-eu-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:diagnosticReport",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticReport",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:diagnosticReport.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DiagnosticReport",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/DiagnosticReport-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:encounter",
        "path" : "Bundle.entry",
        "sliceName" : "encounter",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:encounter.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Encounter",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:imagingStudy",
        "path" : "Bundle.entry",
        "sliceName" : "imagingStudy",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:imagingStudy.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "ImagingStudy",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/ImagingStudy-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:immunization",
        "path" : "Bundle.entry",
        "sliceName" : "immunization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:immunization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Immunization",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:media",
        "path" : "Bundle.entry",
        "sliceName" : "media",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:media.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Media"
          }
        ]
      },
      {
        "id" : "Bundle.entry:medication",
        "path" : "Bundle.entry",
        "sliceName" : "medication",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medication.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Medication",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationRequest",
        "path" : "Bundle.entry",
        "sliceName" : "medicationRequest",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationRequest.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationStatement",
        "path" : "Bundle.entry",
        "sliceName" : "medicationStatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationStatement.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerRole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerRole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitionerRole.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedure",
        "path" : "Bundle.entry",
        "sliceName" : "procedure",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedure.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation",
        "path" : "Bundle.entry",
        "sliceName" : "observation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation"
          }
        ]
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:specimen.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Specimen",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Specimen-uv-ips|2.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationDispense",
        "path" : "Bundle.entry",
        "sliceName" : "medicationDispense",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationDispense.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationDispense"
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationAdministration",
        "path" : "Bundle.entry",
        "sliceName" : "medicationAdministration",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationAdministration.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationAdministration"
          }
        ]
      },
      {
        "id" : "Bundle.entry:familyMemberHistory",
        "path" : "Bundle.entry",
        "sliceName" : "familyMemberHistory",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:familyMemberHistory.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "FamilyMemberHistory"
          }
        ]
      },
      {
        "id" : "Bundle.entry:documentReference",
        "path" : "Bundle.entry",
        "sliceName" : "documentReference",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:documentReference.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DocumentReference"
          }
        ]
      },
      {
        "id" : "Bundle.entry:flag",
        "path" : "Bundle.entry",
        "sliceName" : "flag",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:flag.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Flag",
            "profile" : ["https://hl7.cz/fhir/hdr/StructureDefinition/cz-flag-hdr"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:carePlan",
        "path" : "Bundle.entry",
        "sliceName" : "carePlan",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:carePlan.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "CarePlan",
            "profile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:goal",
        "path" : "Bundle.entry",
        "sliceName" : "goal",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:goal.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Goal"
          }
        ]
      },
      {
        "id" : "Bundle.entry:consent",
        "path" : "Bundle.entry",
        "sliceName" : "consent",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:consent.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Consent"
          }
        ]
      },
      {
        "id" : "Bundle.entry:provenance",
        "path" : "Bundle.entry",
        "sliceName" : "provenance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:provenance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Provenance",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-provenance"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:coverage",
        "path" : "Bundle.entry",
        "sliceName" : "coverage",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:coverage.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Coverage",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
          }
        ]
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "Report Digital Signature"
      },
      {
        "id" : "Bundle.signature.type",
        "path" : "Bundle.signature.type",
        "short" : "Digital Signature Purposes"
      },
      {
        "id" : "Bundle.signature.when",
        "path" : "Bundle.signature.when",
        "short" : "When was signed"
      },
      {
        "id" : "Bundle.signature.who",
        "path" : "Bundle.signature.who",
        "short" : "Who signed."
      },
      {
        "id" : "Bundle.signature.data",
        "path" : "Bundle.signature.data",
        "short" : "Signature content"
      }
    ]
  }
}

```
