# A.2.8.1 Objektivní nález - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.8.1 Objektivní nález**

## Logical Model: A.2.8.1 Objektivní nález 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogCzObjectiveFindingsCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:ObjectiveFindingsHdrCz |

 
Nemocniční propouštěcí zpráva - Objektivní nález pacienta při propuštění. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogCzObjectiveFindingsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogCzObjectiveFindingsCz.csv), [Excel](StructureDefinition-LogCzObjectiveFindingsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogCzObjectiveFindingsCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogCzObjectiveFindingsCz",
  "version" : "0.1.0",
  "name" : "ObjectiveFindingsHdrCz",
  "title" : "A.2.8.1 Objektivní nález",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Objektivní nález pacienta při propuštění.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogCzObjectiveFindingsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogCzObjectiveFindingsCz",
        "path" : "LogCzObjectiveFindingsCz",
        "short" : "A.2.8.1 Objektivní nález",
        "definition" : "Nemocniční propouštěcí zpráva - Objektivní nález pacienta při propuštění."
      },
      {
        "id" : "LogCzObjectiveFindingsCz.datum",
        "path" : "LogCzObjectiveFindingsCz.datum",
        "short" : "A.2.8.1.1 Datum a čas",
        "definition" : "...Datum a čas vyšetření pacienta lékařem při propuštění...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.provedl",
        "path" : "LogCzObjectiveFindingsCz.provedl",
        "short" : "A.2.8.1.2 Provedl",
        "definition" : "...Identifikuje osobu, která vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.antropometrickeUdaje",
        "path" : "LogCzObjectiveFindingsCz.antropometrickeUdaje",
        "short" : "A.2.8.1.3 Antropometrické údaje",
        "definition" : "...Výsledky antropometrických měření pacienta: Požadované: výška, hmotnost, BMI (automatický výpočet z uvedených hodnot). Volitelné: obvod hlavy, hrudníku, břicha...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.textVysledek",
        "path" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.textVysledek",
        "short" : "A.2.8.1.3.1 Výsledek vyšetření textem",
        "definition" : "...Textový popis výsledku vyšetření...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.parametrickyZaznam",
        "path" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.parametrickyZaznam",
        "short" : "A.2.8.1.3.2 Parametrický záznam vyšetření",
        "definition" : "...Parametrický zápis výsledku vyšetření...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.parametrickyZaznam.popis",
        "path" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.parametrickyZaznam.popis",
        "short" : "A.2.8.1.3.2.1 Popis vyšetření",
        "definition" : "...Popis vyšetření včetně kódu vyšetření, vyšetřované oblasti či vzorku, datum a čas odběru vzorku...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.parametrickyZaznam.vysledek",
        "path" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.parametrickyZaznam.vysledek",
        "short" : "A.2.8.1.3.2.2 Výsledek vyšetření formalizovaný",
        "definition" : "...Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Dále podrobnosti o tom, jak byly testy provedeny k získání výsledných hodnot, informace o referenčních rozmezích a interpretaci výsledku...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.provedl",
        "path" : "LogCzObjectiveFindingsCz.antropometrickeUdaje.provedl",
        "short" : "A.2.8.1.3.3 Provedl",
        "definition" : "...Identifikuje osobu, která vyšetření provedla nebo je zdrojem informací o výsledku...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.zivotniFunkce",
        "path" : "LogCzObjectiveFindingsCz.zivotniFunkce",
        "short" : "A.2.8.1.4 Základní životní funkce",
        "definition" : "...Výsledky měření základních životních funkcí pacienta: Tepová frekvence, dechová frekvence, TK s uvedením strany měření. Volitelné: saturace O2...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.zivotniFunkce.textovyVysledek",
        "path" : "LogCzObjectiveFindingsCz.zivotniFunkce.textovyVysledek",
        "short" : "A.2.8.1.4.1 Výsledek vyšetření textem",
        "definition" : "...Textový popis výsledku vyšetření...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.zivotniFunkce.parametrickyZaznam",
        "path" : "LogCzObjectiveFindingsCz.zivotniFunkce.parametrickyZaznam",
        "short" : "A.2.8.1.4.2 Parametrický záznam vyšetření",
        "definition" : "...Parametrický zápis výsledku vyšetření...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.zivotniFunkce.parametrickyZaznam.popis",
        "path" : "LogCzObjectiveFindingsCz.zivotniFunkce.parametrickyZaznam.popis",
        "short" : "A.2.8.1.4.2.1 Popis vyšetření",
        "definition" : "...Popis vyšetření včetně kódu vyšetření, vyšetřované oblasti či vzorku, datum a čas odběru vzorku...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.zivotniFunkce.parametrickyZaznam.vysledek",
        "path" : "LogCzObjectiveFindingsCz.zivotniFunkce.parametrickyZaznam.vysledek",
        "short" : "A.2.8.1.4.2.2 Výsledek vyšetření formalizovaný",
        "definition" : "...Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogCzObjectiveFindingsCz.zivotniFunkce.provedl",
        "path" : "LogCzObjectiveFindingsCz.zivotniFunkce.provedl",
        "short" : "A.2.8.1.4.3 Provedl",
        "definition" : "...Identifikuje osobu, která vyšetření provedla nebo je zdrojem informací o výsledku...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
