# A.2.4 - Stav při přijetí (cz) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.4 - Stav při přijetí (cz)**

## Logical Model: A.2.4 - Stav při přijetí (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogAdmissionEvaluationCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzAdmissionEvaluation |

 
Nemocniční propouštěcí zpráva - Stav při přijetí - A.2.4 CZ poznámka: Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogAdmissionEvaluationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogAdmissionEvaluationCz.csv), [Excel](StructureDefinition-LogAdmissionEvaluationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogAdmissionEvaluationCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAdmissionEvaluationCz",
  "version" : "0.1.0",
  "name" : "LogCzAdmissionEvaluation",
  "title" : "A.2.4 - Stav při přijetí (cz)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Stav při přijetí - A.2.4 CZ poznámka: Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče. ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAdmissionEvaluationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogAdmissionEvaluationCz",
        "path" : "LogAdmissionEvaluationCz",
        "short" : "A.2.4 - Stav při přijetí (cz)",
        "definition" : "Nemocniční propouštěcí zpráva - Stav při přijetí - A.2.4 CZ poznámka: Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče. "
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez",
        "short" : "A.2.4.1 - Objektivní nález",
        "definition" : "Objektivní nález",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.datum",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.datum",
        "short" : "A.2.4.1.1 - Datum a čas",
        "definition" : "Datum a čas vyšetření pacienta lékařem v průběhu jeho přijímání k hospitalizaci",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.provedl",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.provedl",
        "short" : "A.2.4.1.2 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje",
        "short" : "A.2.4.1.3 - Anthropometrické údaje",
        "definition" : "Výsledky antropometrických měření pacienta: Požadované: výška, hmotnost, BMI (automatický výpočet z uvedených hodnot) Volitelné: obvod hlavy, hrudníku, břicha…",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.text",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.text",
        "short" : "A.2.4.1.3.1 - Výsledky měření textem",
        "definition" : "Textový popis výsledku vyšetření",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek",
        "short" : "A.2.4.1.3.2 - Parametrický záznam vyšetření",
        "definition" : "Parametrický zápis výsledku vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.popisVysetreni",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.popisVysetreni",
        "short" : "A.2.4.1.3.2.1 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu vyšetření, vyšetřované oblasti či vzorku, datum a čas odběru vzorku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.formalizovany",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.formalizovany",
        "short" : "A.2.4.1.3.2.2 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Obsah výsledku vyšetření se bude lišit podle typu vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.provedl",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.anthropometrickeUdaje.vysledek.provedl",
        "short" : "A.2.4.1.3.2.3 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce",
        "short" : "A.2.4.1.4 - Základní životní funkce",
        "definition" : "Výsledky měření základních životních funkcí pacienta: Požadované: Tepová frekvence, dechová frekvence, TK s uvedením strany měření, Volitelné: Saturace 02",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.typVysetreni",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.typVysetreni",
        "short" : "A.2.4.1.4.1 - Typ Vyšetření",
        "definition" : "Klasifikace typu vyšetření. Zde fixní hodnota: vital-signs",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.text",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.text",
        "short" : "A.2.4.1.4.2 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek",
        "short" : "A.2.4.1.4.3 - Parametrický záznam vyšetření",
        "definition" : "Parametrický zápis výsledku vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.popisVysetreni",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.popisVysetreni",
        "short" : "A.2.4.1.4.3.1 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu vyšetření, vyšetřované oblasti či vzorku, datum a čas odběru vzorku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.formalizovany",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.formalizovany",
        "short" : "A.2.4.1.4.3.2 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek vyšetření textem a/nebo ve formě číselných a kódovaných výsledků měření. Obsah výsledku vyšetření se bude lišit podle typu vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.provedl",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.zakladniZivotniFunkce.vysledek.provedl",
        "short" : "A.2.4.1.4.3.3 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni",
        "short" : "A.2.4.1.5 - Somatické vyšetření",
        "definition" : "Vyšetření pomocí smyslů vyšetřujícího (pohledem, poslechem, pohmatem a poklepem) a posuzování, zda se takto zjištěné nálezy odchylují od normy. Pokud ano, označujeme tyto odchylky jako objektivní příznaky (angl. signs). ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.text",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.text",
        "short" : "A.2.4.1.5.1 - Výsledek vyšetření textem",
        "definition" : "Textový popis výsledku vyšetření. Mělo by být strukturováno podle časti těla (e.g. Hlava, krk, ramena, ruce, ...)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.provedl",
        "path" : "LogAdmissionEvaluationCz.objektivniNalez.somatickeVysetreni.provedl",
        "short" : "A.2.4.1.5.2 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav",
        "path" : "LogAdmissionEvaluationCz.funkcniStav",
        "short" : "A.2.4.2 - Funkční stav",
        "definition" : "Funkční stav lze hodnotit několika různými způsoby, obvykle se zaměřením na schopnosti osoby vykonávat základní aktivity každodenního života (ADL), které zahrnují základní sebeobsluhu, jako je koupání, krmení a toaleta a instrumentální aktivity každodenního života (IADL), které zahrnují činnosti jako vaření, nakupování a řízení vlastních záležitostí.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.datum",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.datum",
        "short" : "A.2.4.2.1 - Datum a čas",
        "definition" : "Datum a čas hodnocení funkčního stavu pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.provedl",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.provedl",
        "short" : "A.2.4.2.2 - Provedl",
        "definition" : "Identifikuje osobu, která  vyšetření provedla nebo je zdrojem informací o výsledku vyšetření. Tato osoba nemusí být totožná s autorem dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.popis",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.popis",
        "short" : "A.2.4.2.3 - Popis",
        "definition" : "Textový popis funkčního stavu pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane",
        "short" : "A.2.4.2.4 - Hodnocení formalizované",
        "definition" : "Formalizované hodnocení funkčního stavu pacienta dle jednotlivých hodnotících kategorií zvoleného systému hodnocení (např. MKF)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.datumVzniku",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.datumVzniku",
        "short" : "A.2.4.2.4.1 - Datum vzniku",
        "definition" : "Datum vzniku funkčního omezení",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.text",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.text",
        "short" : "A.2.4.2.4.2 - Výsledek vyšetření textem",
        "definition" : "Výsledek vyšetření volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.popis",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.popis",
        "short" : "A.2.4.2.4.3 - Popis vyšetření",
        "definition" : "Popis vyšetření včetně kódu. Jako výchozí systém pro hodnocení funkčního stavu byl zvolen mezinárodní klasifikační systém MKF. Další typy hodnotících škál mohou být doplněny v budoucích verzích standardu na základě potřeby a konsenzu odborné veřejnosti. ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.formalizovany",
        "path" : "LogAdmissionEvaluationCz.funkcniStav.hodnoceniFormalizovane.formalizovany",
        "short" : "A.2.4.2.4.4 - Výsledek vyšetření formalizovaný",
        "definition" : "Výsledek hodnocení funkčního stavu v dané kategorii hodnocení.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
