# A.1 - Hospital Discharge Report header data element - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - Hospital Discharge Report header data element**

## Logical Model: A.1 - Hospital Discharge Report header data element 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/Header | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnHeaderHdrCz |

 
Hospital Discharge Report - Hospital Discharge Report header data element - A.1 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/Header)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Header.csv), [Excel](StructureDefinition-Header.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Header",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
  "version" : "0.1.0",
  "name" : "LogEnHeaderHdrCz",
  "title" : "A.1 - Hospital Discharge Report header data element",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Hospital Discharge Report header data element - A.1 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "Header",
        "path" : "Header",
        "short" : "A.1 - Hospital Discharge Report header data element",
        "definition" : "Hospital Discharge Report - Hospital Discharge Report header data element - A.1 eHN"
      },
      {
        "id" : "Header.subject",
        "path" : "Header.subject",
        "short" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "definition" : "Identification of the patient/subject and Patient/subject related contact information",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/Subject"
          }
        ]
      },
      {
        "id" : "Header.payer",
        "path" : "Header.payer",
        "short" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "definition" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.payer.insuranceCode",
        "path" : "Header.payer.insuranceCode",
        "short" : "A.1.3.1 - Health insurance code",
        "definition" : "Unique health insurance company identification code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.payer.insuranceName",
        "path" : "Header.payer.insuranceName",
        "short" : "A.1.3.2 - Health insurance name",
        "definition" : "Full, official name of the healthcare insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Header.payer.insuranceNumber",
        "path" : "Header.payer.insuranceNumber",
        "short" : "A.1.3.3 - Health insurance number",
        "definition" : "Number or code under which the insured person is registered at the insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient",
        "path" : "Header.informationRecipient",
        "short" : "A.1.4 - Information recipient - (intended recipient or recipients of the report), if applicable",
        "definition" : "Information recipient - (intended recipient or recipients of the report), if applicable",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient.identifier",
        "path" : "Header.informationRecipient.identifier",
        "short" : "A.1.4.1 - Recipient identifier",
        "definition" : "The health professional or patient identifier. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier could be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient.name",
        "path" : "Header.informationRecipient.name",
        "short" : "A.1.4.2 - Recipient name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient.organizationID",
        "path" : "Header.informationRecipient.organizationID",
        "short" : "A.1.4.3 - Recipient organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient.organization",
        "path" : "Header.informationRecipient.organization",
        "short" : "A.1.4.4 - Recipient organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient.address",
        "path" : "Header.informationRecipient.address",
        "short" : "A.1.4.5 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient.country",
        "path" : "Header.informationRecipient.country",
        "short" : "A.1.4.6 - Country",
        "definition" : "Country of the intended recipient as part of the address.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Header.informationRecipient.telecom",
        "path" : "Header.informationRecipient.telecom",
        "short" : "A.1.4.7 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated to a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "Header.author",
        "path" : "Header.author",
        "short" : "A.1.5 - Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.",
        "definition" : "Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.author.identifier",
        "path" : "Header.author.identifier",
        "short" : "A.1.5.1 - Author identifier",
        "definition" : "The health professional identifier that will allow addressing recipients within a national or international data exchange infrastructure, such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier should be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.author.name",
        "path" : "Header.author.name",
        "short" : "A.1.5.2 - Author name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "Header.author.organizationID",
        "path" : "Header.author.organizationID",
        "short" : "A.1.5.3 - Author organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.author.organization",
        "path" : "Header.author.organization",
        "short" : "A.1.5.4 - Author organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.author.dateTime",
        "path" : "Header.author.dateTime",
        "short" : "A.1.5.5 - Date Time",
        "definition" : "Date and time of the last modification of the document by its Author.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Header.attester",
        "path" : "Header.attester",
        "short" : "A.1.6 - Attester (multiple attesters could be provided)",
        "definition" : "Attester (multiple attesters could be provided)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.attester.identifier",
        "path" : "Header.attester.identifier",
        "short" : "A.1.6.1 - Attester identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.attester.name",
        "path" : "Header.attester.name",
        "short" : "A.1.6.2 - Attester name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "Header.attester.organizationID",
        "path" : "Header.attester.organizationID",
        "short" : "A.1.6.3 - Attester organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.attester.organization",
        "path" : "Header.attester.organization",
        "short" : "A.1.6.4 - Attester organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.attester.dateTime",
        "path" : "Header.attester.dateTime",
        "short" : "A.1.6.5 - Approval date and time",
        "definition" : "Date and time of the approval of the document by Attester.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Header.legalAuthenticator",
        "path" : "Header.legalAuthenticator",
        "short" : "A.1.7 - Legal authenticator (The person taking responsibility for the medical content of the document)",
        "definition" : "Legal authenticator (The person taking responsibility for the medical content of the document)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.legalAuthenticator.identifier",
        "path" : "Header.legalAuthenticator.identifier",
        "short" : "A.1.7.1 - Legal authenticator identifier",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. Multiple identifiers could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.legalAuthenticator.name",
        "path" : "Header.legalAuthenticator.name",
        "short" : "A.1.7.2 - Legal authenticator name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "Header.legalAuthenticator.organizationID",
        "path" : "Header.legalAuthenticator.organizationID",
        "short" : "A.1.7.3 - Legal authenticator organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.legalAuthenticator.organization",
        "path" : "Header.legalAuthenticator.organization",
        "short" : "A.1.7.4 - Legal authenticator organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.legalAuthenticator.dateTime",
        "path" : "Header.legalAuthenticator.dateTime",
        "short" : "A.1.7.5 - Authentication date and time",
        "definition" : "Date and time when the document was authorised.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata",
        "path" : "Header.documentMetadata",
        "short" : "A.1.8 - Document metadata",
        "definition" : "Document metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.identifier",
        "path" : "Header.documentMetadata.identifier",
        "short" : "A.1.8.1 - Document ID",
        "definition" : "Unique identifier of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.type",
        "path" : "Header.documentMetadata.type",
        "short" : "A.1.8.2 - Document type",
        "definition" : "Identifies the type of document at hand, e.g. Hospital discharge report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.status",
        "path" : "Header.documentMetadata.status",
        "short" : "A.1.8.3 - Document status",
        "definition" : "The status of the Hospital discharge report. E.g., preliminary, final.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.dateTime",
        "path" : "Header.documentMetadata.dateTime",
        "short" : "A.1.8.4 - Report date and time",
        "definition" : "Date and time of the Hospital discharge report creation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.title",
        "path" : "Header.documentMetadata.title",
        "short" : "A.1.8.5 - Document title",
        "definition" : "Document title, fix value \"Hospital discharge report\".",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.custodian",
        "path" : "Header.documentMetadata.custodian",
        "short" : "A.1.8.6 - Report custodian",
        "definition" : "Organisation that is in charge of maintaining the report [this element will include organisation ID, name, address etc., as other elements describing organisations].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.confidentiality",
        "path" : "Header.documentMetadata.confidentiality",
        "short" : "A.1.8.7 - Confidentiality",
        "definition" : "Level of confidentiality of the document. Implicit value is normal.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.language",
        "path" : "Header.documentMetadata.language",
        "short" : "A.1.8.8 - Language",
        "definition" : "Language in which the document is written. Language is expressed by the ISO language code.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Header.documentMetadata.version",
        "path" : "Header.documentMetadata.version",
        "short" : "A.1.8.9 - Version",
        "definition" : "Version of the document",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Header.digitalSignature",
        "path" : "Header.digitalSignature",
        "short" : "A.1.9 - Digital signature",
        "definition" : "Digital signature",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img/StructureDefinition/DigitalSignatureCz"
          }
        ]
      }
    ]
  }
}

```
