# A.2.8.2 - Functional status - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.8.2 - Functional status**

## Logical Model: A.2.8.2 - Functional status 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/FunctionalStatusCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnFunctionalStatusHdrEhnCz |

 
Hospital Discharge Report - Functional status - A.2.8.2 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/FunctionalStatusCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-FunctionalStatusCz.csv), [Excel](StructureDefinition-FunctionalStatusCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "FunctionalStatusCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/FunctionalStatusCz",
  "version" : "0.1.0",
  "name" : "LogEnFunctionalStatusHdrEhnCz",
  "title" : "A.2.8.2 - Functional status",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Functional status  - A.2.8.2 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/FunctionalStatusCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "FunctionalStatusCz",
        "path" : "FunctionalStatusCz",
        "short" : "A.2.8.2 - Functional status",
        "definition" : "Hospital Discharge Report - Functional status  - A.2.8.2 eHN"
      },
      {
        "id" : "FunctionalStatusCz.description",
        "path" : "FunctionalStatusCz.description",
        "short" : "A.2.8.2.1 - Description",
        "definition" : "Need for the patient to be continuously assessed by third parties; functional status may influence decisions about how to plan and administer treatments",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "FunctionalStatusCz.onsetDate",
        "path" : "FunctionalStatusCz.onsetDate",
        "short" : "A.2.8.2.2 - Onset Date",
        "definition" : "Onset date of a condition",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "FunctionalStatusCz.assessmentType",
        "path" : "FunctionalStatusCz.assessmentType",
        "short" : "A.2.8.2.3 - Functional assessment description",
        "definition" : "Description of the functional assessment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "FunctionalStatusCz.assessmentDate",
        "path" : "FunctionalStatusCz.assessmentDate",
        "short" : "A.2.8.2.4 - Functional assessment date",
        "definition" : "Date of the functional assessment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "FunctionalStatusCz.assessmentResult",
        "path" : "FunctionalStatusCz.assessmentResult",
        "short" : "A.2.8.2.5 - Functional assessment result",
        "definition" : "Functional assessment result value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
