# A.2.1 - Advance Directives (eHN) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Advance Directives (eHN)**

## Logical Model: A.2.1 - Advance Directives (eHN) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/AdvanceDirectivesCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnAdvanceDirectivesEhnCz |

 
Hospital Discharge Report - Advance Directives - A.2.1 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/AdvanceDirectivesCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AdvanceDirectivesCz.csv), [Excel](StructureDefinition-AdvanceDirectivesCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdvanceDirectivesCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/AdvanceDirectivesCz",
  "version" : "0.1.0",
  "name" : "LogEnAdvanceDirectivesEhnCz",
  "title" : "A.2.1 - Advance Directives (eHN)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Advance Directives - A.2.1 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/AdvanceDirectivesCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AdvanceDirectivesCz",
        "path" : "AdvanceDirectivesCz",
        "short" : "A.2.1 - Advance Directives (eHN)",
        "definition" : "Hospital Discharge Report - Advance Directives - A.2.1 eHN"
      },
      {
        "id" : "AdvanceDirectivesCz.livingWill",
        "path" : "AdvanceDirectivesCz.livingWill",
        "short" : "A.2.1.1 - Living will",
        "definition" : "Only directives being expressed during current inpatient stay. Multiple records of living wills could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdvanceDirectivesCz.livingWill.date",
        "path" : "AdvanceDirectivesCz.livingWill.date",
        "short" : "A.2.1.1.1 - Date and time",
        "definition" : "The date and time on which the living will was recorded.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AdvanceDirectivesCz.livingWill.type",
        "path" : "AdvanceDirectivesCz.livingWill.type",
        "short" : "A.2.1.1.2 - Type",
        "definition" : "Type of a living will, e.g. Do not resuscitate, donorship statement, power of attorney etc.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AdvanceDirectivesCz.livingWill.comment",
        "path" : "AdvanceDirectivesCz.livingWill.comment",
        "short" : "A.2.1.1.3 - Comment",
        "definition" : "Comment on the living will.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AdvanceDirectivesCz.livingWill.conditions",
        "path" : "AdvanceDirectivesCz.livingWill.conditions",
        "short" : "A.2.1.1.4 - Related conditions",
        "definition" : "The problem or disorder to which the living will applies. Multiple fields could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AdvanceDirectivesCz.livingWill.document",
        "path" : "AdvanceDirectivesCz.livingWill.document",
        "short" : "A.2.1.1.5 - Living will document",
        "definition" : "Scanned source document with the living will and the patient's signature, such as a PDF.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
