# Patient-Novak-Petr-L1 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Patient-Novak-Petr-L1**

## Example Patient: Patient-Novak-Petr-L1

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Ing. Petr Novák, Ph.D. Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)

-------

| | |
| :--- | :--- |
| Contact Detail | * [+420777111222](tel:+420777111222)
* [novak@example.com](mailto:novak@example.com)
* Pavlovova 1424/11, 568 02 Svitavy - Předměstí(home)
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "48a9d440-4194-42c1-87ad-b5a39020a4d0",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "1597778923"
    }
  ],
  "name" : [
    {
      "text" : "Ing. Petr Novák, Ph.D.",
      "family" : "Novák",
      "given" : ["Petr", "Pavel"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420777111222"
    },
    {
      "system" : "email",
      "value" : "novak@example.com"
    }
  ],
  "gender" : "male",
  "birthDate" : "1985-06-15",
  "address" : [
    {
      "use" : "home",
      "text" : "Pavlovova 1424/11, 568 02 Svitavy - Předměstí",
      "line" : ["Pavlovova 1424/11"],
      "city" : "Svitavy - Předměstí",
      "postalCode" : "56802",
      "country" : "Česko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ]
}

```
