# Organization-L1-HOSP - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Organization-L1-HOSP**

## Example Organization: Organization-L1-HOSP

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/icp`/12345678

**name**: CHIR-L2 - Lůžková stanice 2

**telecom**: [+42060385111](tel:+42060385111)

**address**: Václavská 570 Chrudim 53701 Česká republika (work)

**partOf**: [Chirurgické oddělení - Nemocnice Pardubického kraje, a.s., Chrudimská nemocnice](Bundle-DischargeBundle-Novak-Petr-L1-core.md#urn-uuid-af2b3114-e872-43b9-9875-cceb39122f7f)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "a4641bd0-34af-4038-a7db-872d08a54df9",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/icp",
      "value" : "12345678"
    }
  ],
  "name" : "CHIR-L2 - Lůžková stanice 2",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+42060385111"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "line" : ["Václavská 570"],
      "city" : "Chrudim",
      "postalCode" : "53701",
      "country" : "Česká republika",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "partOf" : {
    "reference" : "urn:uuid:af2b3114-e872-43b9-9875-cceb39122f7f",
    "display" : "Chirurgické oddělení - Nemocnice Pardubického kraje, a.s., Chrudimská nemocnice"
  }
}

```
