# Organization: Registering healthcare provider example - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Organization: Registering healthcare provider example**

## Example Organization: Organization: Registering healthcare provider example

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/ico`/456789857, `https://ncez.mzcr.cz/fhir/sid/icz`/12345000, `https://ncez.mzcr.cz/fhir/sid/icp`/12345678

**type**: Samostatná ordinace PL - gynekologa

**name**: MUDr. Jana Kouzelná

**telecom**: [+420603853227](tel:+420603853227)

**address**: Krátká 11, 70500 Ostrava Ostrava 70500 CZ 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "RegisteringProviderExample-gynecology",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
      "value" : "456789857"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/icz",
      "value" : "12345000"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/icp",
      "value" : "12345678"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/cz-drzar",
          "code" : "323",
          "display" : "Samostatná ordinace PL - gynekologa"
        }
      ]
    }
  ],
  "name" : "MUDr. Jana Kouzelná",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420603853227",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Krátká 11, 70500 Ostrava"],
      "city" : "Ostrava",
      "postalCode" : "70500",
      "country" : "CZ"
    }
  ]
}

```
