# Trombocyty - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Trombocyty**

## Example Observation: Trombocyty

**status**: Final

**code**: 11336

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

**encounter**: [Encounter: status = finished; class = inpatient encounter (ActCode#IMP); priority = emergency; period = 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)

**effective**: 2025-04-01 09:00:00+0100

**performer**: [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md)

**value**: 250 10^9/L(Details: UCUM code10*9/L = '10*9/L')

**interpretation**: Normal

**note**: 

> 

Počet trombocytů je v normálním rozmezí.


**specimen**: [Specimen: status = available; type = Venous blood specimen; receivedTime = 2025-04-01 09:30:00+0100](Specimen-Specimen-EDTA-1.md)

### ReferenceRanges

| | | |
| :--- | :--- | :--- |
| - | **Low** | **High** |
| * | 150 | 400 |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "plt-result",
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/NCLPPOL",
        "code" : "11336"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Mracena2"
  },
  "encounter" : {
    "reference" : "Encounter/10f5c49e-086d-4016-8dd1-b555306bf620"
  },
  "effectiveDateTime" : "2025-04-01T09:00:00+01:00",
  "performer" : [
    {
      "reference" : "Practitioner/Practitioner-2"
    }
  ],
  "valueQuantity" : {
    "value" : 250,
    "unit" : "10^9/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "10*9/L"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ],
  "note" : [
    {
      "text" : "Počet trombocytů je v normálním rozmezí."
    }
  ],
  "specimen" : {
    "reference" : "Specimen/Specimen-EDTA-1"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 150
      },
      "high" : {
        "value" : 400
      }
    }
  ]
}

```
