# ExampleWeight - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **ExampleWeight**

## Example Observation: ExampleWeight

Profile: [Observation: Anthropometric Data (HDR CZ)](StructureDefinition-cz-observation-weight-hdr.md)

**status**: Final

**category**: Vital Signs

**code**: Body weight

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2024-03-28

**performer**: [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md)

**value**: 70 kg(Details: UCUM codekg = 'kg')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-weight-hdr"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "29463-7",
        "display" : "Body weight"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectiveDateTime" : "2024-03-28",
  "performer" : [
    {
      "reference" : "Practitioner/Practitioner-2"
    }
  ],
  "valueQuantity" : {
    "value" : 70,
    "unit" : "kg",
    "system" : "http://unitsofmeasure.org",
    "code" : "kg"
  }
}

```
