# Dispense – Euthyrox - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Dispense – Euthyrox**

## Example Medication: Dispense – Euthyrox

Profile: [Medication (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)

**identifier**: `https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs`/0243131

**code**: Euthyrox 75 mcg

**status**: Active

**form**: Tableta

**amount**: 75 mcg(Details: UCUM code/ug = '/ug')/1 Tableta

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Item[x]** | **Strength** |
| * | Levothyroxin | 75 mcg(Details: UCUM code/ug = '/ug')/1 tableta |



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "Medication-Euthyrox",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
  },
  "identifier" : [
    {
      "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs",
      "value" : "0243131"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs",
        "code" : "0243131",
        "display" : "EUTHYROX"
      },
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpatc-cs",
        "code" : "H03AA01",
        "display" : "LEVOTHYROXINE SODIUM"
      }
    ],
    "text" : "Euthyrox 75 mcg"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpformy-cs",
        "code" : "TBL_FLM",
        "display" : "Potahovaná tableta"
      }
    ],
    "text" : "Tableta"
  },
  "amount" : {
    "numerator" : {
      "value" : 75,
      "unit" : "mcg",
      "system" : "http://unitsofmeasure.org",
      "code" : "/ug"
    },
    "denominator" : {
      "value" : 1,
      "unit" : "Tableta"
    }
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivelatky-cs",
            "code" : "828",
            "display" : "LEVOTHYROXINUM NATRICUM"
          }
        ],
        "text" : "Levothyroxin"
      },
      "strength" : {
        "numerator" : {
          "value" : 75,
          "unit" : "mcg",
          "system" : "http://unitsofmeasure.org",
          "code" : "/ug"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "tableta"
        }
      }
    }
  ]
}

```
