# Example Czech Location - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Example Czech Location**

## Example Location: Example Czech Location

Profile: [Location (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-location-core.html)

**status**: Active

**name**: Nemocnice Praha

**description**: Hlavní nemocnice v Praze

**address**: Vinohradská 800/14, 120 00 Praha 2, Česká republika(work)

**physicalType**: Building

**managingOrganization**: [Organization Nemocnice Chrudim](Organization-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169.md)



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "example-cz-location",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
    ]
  },
  "status" : "active",
  "name" : "Nemocnice Praha",
  "description" : "Hlavní nemocnice v Praze",
  "address" : {
    "use" : "work",
    "type" : "both",
    "text" : "Vinohradská 800/14, 120 00 Praha 2, Česká republika",
    "line" : ["Vinohradská 800/14"],
    "city" : "Praha",
    "postalCode" : "120 00",
    "country" : "CZ"
  },
  "physicalType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
        "code" : "bu"
      }
    ]
  },
  "managingOrganization" : {
    "reference" : "Organization/ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169"
  }
}

```
