# CZ-Condition-HDR Example 2 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Condition-HDR Example 2**

## Example Condition: CZ-Condition-HDR Example 2

Profile: [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Disease, On admission, Received therapy or drug for

**severity**: Midgrade

**code**: Other specified cardiac arrhythmias

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**onset**: 2013-01-09 00:00:00+0100

**note**: 

> 

Brugada Syndrom diagnostikován v roce 2013.




## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "CZ-Condition-HDR-Example-2",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "64572001",
          "display" : "Disease"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "278307001",
          "display" : "On admission"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "69845001",
          "display" : "Received therapy or drug for"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "6736007",
        "display" : "Midgrade"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "I49.8",
        "display" : "Other specified cardiac arrhythmias"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "onsetDateTime" : "2013-01-09T00:00:00+01:00",
  "note" : [
    {
      "text" : "Brugada Syndrom diagnostikován v roce 2013."
    }
  ]
}

```
