# CZ Header Model to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Header Model to this guide Map**

## ConceptMap: CZ Header Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/hdrHeader2FHIR-cz-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:Header2FHIRczHdr |

 
CZ HDR Header Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "hdrHeader2FHIR-cz-hdr",
  "url" : "https://hl7.cz/fhir/hdr/ConceptMap/hdrHeader2FHIR-cz-hdr",
  "version" : "0.1.0",
  "name" : "Header2FHIRczHdr",
  "title" : "CZ Header Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ HDR Header Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
      "element" : [
        {
          "code" : "Header.payer.insuranceCode",
          "display" : "A.1.3.1 - Health insurance code",
          "target" : [
            {
              "code" : "Organization.identifier.KP",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.payer.insuranceName",
          "display" : "A.1.3.2 - Health insurance name",
          "target" : [
            {
              "code" : "Organization.name",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage",
      "element" : [
        {
          "code" : "Header.coverage.insuranceNumber",
          "display" : "A.1.3.3 - insuranceNumber",
          "target" : [
            {
              "code" : "CZ_Coverage.identifer",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
      "element" : [
        {
          "code" : "Header.subject",
          "display" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "equivalent",
              "comment" : "Composition.subject.ofType(Patient).conformsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core')"
            }
          ]
        },
        {
          "code" : "Header.payer.insuranceNumber",
          "display" : "A.1.3.3 - Health insurance number",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equivalent",
              "comment" : "If treated as one of the Patient identifiers; this applies in some jurisdictions."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "Header.informationRecipient.identifier",
          "display" : "A.1.4.1 - Recipient identifier",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent",
              "comment" : "Composition.extension:information-recipient.valueReference.resolve()"
            }
          ]
        },
        {
          "code" : "Header.author",
          "display" : "A.1.5 - Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.",
          "target" : [
            {
              "code" : "PractitionerRole",
              "equivalence" : "equivalent",
              "comment" : "Composition.author.resolve().ofType(PractitionerRole).confirmsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core')"
            }
          ]
        },
        {
          "code" : "Header.author.identifier",
          "display" : "A.1.5.1 - Author identifier",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.author.name",
          "display" : "A.1.5.2 - Author name",
          "target" : [
            {
              "code" : "PractitionerRole.practictioner.name",
              "equivalence" : "equivalent",
              "comment" : "If PractitionerRole"
            }
          ]
        },
        {
          "code" : "Header.author.organizationID",
          "display" : "A.1.5.3 - Author organisation ID",
          "target" : [
            {
              "code" : "PractitionerRole.organization.identifier",
              "equivalence" : "equivalent",
              "comment" : "If Organization"
            }
          ]
        },
        {
          "code" : "Header.author.organization",
          "display" : "A.1.5.4 - Author organisation",
          "target" : [
            {
              "code" : "PractitionerRole.organization",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.attester",
          "display" : "A.1.6 - Attester (multiple attesters could be provided)",
          "target" : [
            {
              "code" : "PractitionerRole",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'professional' AND Composition.attester.party.resolve().ofType(PractitionerRole).confirmsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core')"
            }
          ]
        },
        {
          "code" : "Header.attester.identifier",
          "display" : "A.1.6.1 - Attester identifier",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.attester.name",
          "display" : "A.1.6.2 - Attester name",
          "target" : [
            {
              "code" : "PractitionerRole.practictioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.attester.organizationID",
          "display" : "A.1.6.3 - Attester organisation ID",
          "target" : [
            {
              "code" : "PractitionerRole.organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.attester.organization",
          "display" : "A.1.6.4 - Attester organisation",
          "target" : [
            {
              "code" : "PractitionerRole.organization",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.legalAuthenticator",
          "display" : "A.1.7 - Legal authenticator (The person taking responsibility for the medical content of the document)",
          "target" : [
            {
              "code" : "PractitionerRole",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal' AND Composition.attester.party.resolve().ofType(PractitionerRole).conformsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core')"
            }
          ]
        },
        {
          "code" : "Header.legalAuthenticator.identifier",
          "display" : "A.1.7.1 - Legal authenticator identifier",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        },
        {
          "code" : "Header.legalAuthenticator.name",
          "display" : "A.1.7.2 - Legal authenticator name",
          "target" : [
            {
              "code" : "PractitionerRole.practictioner.name",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        },
        {
          "code" : "Header.legalAuthenticator.organizationID",
          "display" : "A.1.7.3 - Legal authenticator organisation ID",
          "target" : [
            {
              "code" : "PractitionerRole.organization.identifier",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        },
        {
          "code" : "Header.legalAuthenticator.organization",
          "display" : "A.1.7.4 - Legal authenticator organisation",
          "target" : [
            {
              "code" : "PractitionerRole.organization",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-bundle-hdr",
      "element" : [
        {
          "code" : "Header.documentMetadata.identifier",
          "display" : "A.1.8.1 - Document ID",
          "target" : [
            {
              "code" : "Bundle.identifier",
              "equivalence" : "equivalent",
              "comment" : "If it is the identifier of a particular report instance"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.dateTime",
          "display" : "A.1.8.4 - Report date and time",
          "target" : [
            {
              "code" : "Bundle.timeStamp",
              "equivalence" : "equivalent",
              "comment" : "If it is when this particular version of  this report has been assembled into a Bundle."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/Header",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr",
      "element" : [
        {
          "code" : "Header.subject",
          "display" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
          "target" : [
            {
              "code" : "Composition.subject",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.payer",
          "display" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
          "target" : [
            {
              "code" : "Composition.extension:basedOn:order",
              "equivalence" : "relatedto",
              "comment" : "To be disucssed if the payor data are conveyed with the request or thorugh other means. Check also the extension to be used."
            }
          ]
        },
        {
          "code" : "Header.payer",
          "display" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
          "target" : [
            {
              "code" : "Composition.section:sectionPayers.entry",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:sectionPayers.entry.ofType(Coverage).conformsTo('https://hl7.cz/fhir/core/StructureDefinition/cz-coverage')"
            }
          ]
        },
        {
          "code" : "Header.informationRecipient",
          "display" : "A.1.4 - Information recipient - (intended recipient or recipients of the report), if applicable",
          "target" : [
            {
              "code" : "Composition.extension:information-recipient",
              "equivalence" : "relatedto",
              "comment" : "Composition.extension:information-recipient.valueReference.resolve().ofType(PracittionerRole)"
            }
          ]
        },
        {
          "code" : "Header.informationRecipient.name",
          "display" : "A.1.4.2 - Recipient name",
          "target" : [
            {
              "code" : "PractitionerRole.practitioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.informationRecipient.organizationID",
          "display" : "A.1.4.3 - Recipient organisation ID",
          "target" : [
            {
              "code" : "PractitionerRole.practitioner.organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.informationRecipient.organization",
          "display" : "A.1.4.4 - Recipient organisation",
          "target" : [
            {
              "code" : "PractitionerRole.practitioner.organization",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.informationRecipient.address",
          "display" : "A.1.4.5 - Address",
          "target" : [
            {
              "code" : "PractitionerRole.address",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.informationRecipient.country",
          "display" : "A.1.4.6 - Country",
          "target" : [
            {
              "code" : "PractitionerRole.country",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.informationRecipient.telecom",
          "display" : "A.1.4.7 - Telecom",
          "target" : [
            {
              "code" : "PractitionerRole.telecom",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.author",
          "display" : "A.1.5 - Author (by whom the Hospital discharge report was/were authored). Multiple authors could be provided.",
          "target" : [
            {
              "code" : "Composition.author",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.author.dateTime",
          "display" : "A.1.5.5 - Date Time",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.attester",
          "display" : "A.1.6 - Attester (multiple attesters could be provided)",
          "target" : [
            {
              "code" : "Composition.attester.party",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'professional'"
            }
          ]
        },
        {
          "code" : "Header.attester.dateTime",
          "display" : "A.1.6.5 - Approval date and time",
          "target" : [
            {
              "code" : "Composition.attester.time",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "Header.legalAuthenticator",
          "display" : "A.1.7 - Legal authenticator (The person taking responsibility for the medical content of the document)",
          "target" : [
            {
              "code" : "Composition.attester.party",
              "equivalence" : "equivalent",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        },
        {
          "code" : "Header.legalAuthenticator.dateTime",
          "display" : "A.1.7.5 - Authentication date and time",
          "target" : [
            {
              "code" : "Composition.attester.time",
              "equivalence" : "equal",
              "comment" : "where attester.mode = 'legal'"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata",
          "display" : "A.1.8 - Document metadata",
          "target" : [
            {
              "code" : "Composition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.type",
          "display" : "A.1.8.2 - Document type",
          "target" : [
            {
              "code" : "Composition.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.status",
          "display" : "A.1.8.3 - Document status",
          "target" : [
            {
              "code" : "Composition.status",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.dateTime",
          "display" : "A.1.8.4 - Report date and time",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent",
              "comment" : "If it is when this document has been created (indipendently by its version)"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.title",
          "display" : "A.1.8.5 - Document title",
          "target" : [
            {
              "code" : "Composition.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.custodian",
          "display" : "A.1.8.6 - Report custodian",
          "target" : [
            {
              "code" : "Composition.custodian",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.confidentiality",
          "display" : "A.1.8.7 - Confidentiality",
          "target" : [
            {
              "code" : "Composition.confidentiality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.language",
          "display" : "A.1.8.8 - Language",
          "target" : [
            {
              "code" : "Composition.language",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.version",
          "display" : "A.1.8.9 - Version",
          "target" : [
            {
              "code" : "Composition.extension:versionNumber.valueString",
              "equivalence" : "equivalent",
              "comment" : "As business version, not as resource version"
            }
          ]
        }
      ]
    }
  ]
}

```
