# Datová sada - logické modely CZ - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Datová sada - logické modely CZ**

## Datová sada - logické modely CZ

Tato stránka uvádí logické modely HL7 FHIR používané k reprezentaci nemocniční propouštěcí zprávy.

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogCzHospitalDischargeReportCz](StructureDefinition-LogHospitalDischargeReportCz.md) | A - Propouštěcí zpráva | Nemocniční propouštěcí zpráva |
| [LogCzHeaderCz](StructureDefinition-LogHeaderHdrCz.md) | A.1 – Hlavička dokumentu | Nemocniční propouštěcí zpráva - Struktura hlavičky propouštěcí zprávy podle tabulky části. |
| [LogCzSubjectHdrCz](StructureDefinition-LogSubjectCz.md) | A.1.1 - Identifikace a A.1.2 - informace o pacientovi | Nemocniční propouštěcí zpráva - Informace o pacientovi. |
| [LogCzDigitalSignatureCz](StructureDefinition-LogdigitalSignatureCz.md) | A.1.9 - Digitální podpis | Nemocniční propouštěcí zpráva - Elektronický podpis dle zákona 327/2011 §54a |
| [LogCzAdvanceDirectivesEhnCz](StructureDefinition-LogAdvanceDirectivesCz.md) | A.2.1 - Dříve vyslovená přání (cz) | Nemocniční propouštěcí zpráva - Dříve vyslovená přání |
| [LogCzAlertsCz](StructureDefinition-LogAlertsCz.md) | A.2.2 - Urgentní informace (cz) | Nemocniční propouštěcí zpráva - Urgentní informace |
| [LogCzEncounterCz](StructureDefinition-LogInPatientEncounterCz.md) | A.2.3 - Kontakt se zdravotními službami | Nemocniční propouštěcí zpráva - Záznam o hospitalizačním kontaktu v rámci propouštěcí zprávy. |
| [LogCzAdmissionEvaluation](StructureDefinition-LogAdmissionEvaluationCz.md) | A.2.4 - Stav při přijetí (cz) | Nemocniční propouštěcí zpráva - Stav při přijetí - A.2.4 CZ poznámka: Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče. |
| [LogCzPatientHistoryCz](StructureDefinition-LogPatientHistoryCz.md) | A.2.6 - Anamnéza | Nemocniční propouštěcí zpráva - Anamnéza |
| [LogCzDischargeDetailsCz](StructureDefinition-LogDischargeDetailsCz.md) | A.2.7 - Průběh hospitalizace | Nemocniční propouštěcí zpráva - Průběh hospitalizace |
| [LogCzHospitalStayCz](StructureDefinition-LogHospitalStayCz.md) | A.2.7 Průběh hospitalizace | Nemocniční propouštěcí zpráva - Popis průběhu hospitalizace zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí. |
| [LogCzFunctionalStatusHdrCz](StructureDefinition-LogFunctionalStatusCz.md) | A.2.8.2 - Funkční stav při propuštění | Nemocniční propouštěcí zpráva - Hodnocení funkčního stavu pacienta při propuštění. |
| [LogCzMedicationSummaryHdrCz](StructureDefinition-LogMedicationSummaryCz.md) | A.2.9.2 Souhrn medikace | Nemocniční propouštěcí zpráva - Souhrnná informace o medikaci doporučené na období po propuštění, včetně medikace změněné, nově zahájené nebo ukončené. |
| [LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md) | A.3 - Vizuální podoba dokumentu | Nemocniční propouštěcí zpráva - čitelná lidským okem, je požadován PDF formát. Obsahuje informace o průběhu hospitalizace v rozsahu vydané zprávy. |
| [LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md) | A.4 - Přílohy (cz) | Nemocniční propouštěcí zpráva - Přílohy |

