# CZ Consent Category - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Consent Category**

## ValueSet: CZ Consent Category 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ValueSet/cz-consent-category | *Version*:0.1.0 |
| Active as of 2025-12-22 | *Computable Name*:CZConsentCategory |

 
ValueSet for Consent Categories in the Czech HDR project. 

 **References** 

* [Consent (Advance Directives) (HDR CZ)](StructureDefinition-cz-consent-hdr.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-consent-category",
  "url" : "https://hl7.cz/fhir/hdr/ValueSet/cz-consent-category",
  "version" : "0.1.0",
  "name" : "CZConsentCategory",
  "title" : "CZ Consent Category",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "ValueSet for Consent Categories in the Czech HDR project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/ValueSet/consentcategorycodes",
        "concept" : [
          {
            "code" : "acd",
            "display" : "Dříve vyslovené přání"
          },
          {
            "code" : "dnr",
            "display" : "Neprovádět neodkladnou resuscitaci"
          }
        ]
      },
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "59284-0",
            "display" : "Informovaný souhlas"
          }
        ]
      }
    ]
  }
}

```
