# Related Person: HDR (CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Related Person: HDR (CZ)**

## Resource Profile: Related Person: HDR (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-relatedPerson-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_RelatedPersonHdr |

 
Czech profile for related person. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-relatedPerson-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-relatedPerson-hdr.csv), [Excel](StructureDefinition-cz-relatedPerson-hdr.xlsx), [Schematron](StructureDefinition-cz-relatedPerson-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-relatedPerson-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-relatedPerson-hdr",
  "version" : "0.1.0",
  "name" : "CZ_RelatedPersonHdr",
  "title" : "Related Person: HDR (CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech profile for related person.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson"
      },
      {
        "id" : "RelatedPerson.relationship.coding.code",
        "path" : "RelatedPerson.relationship.coding.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://hl7.cz/fhir/hdr/ValueSet/relatedPersonRelationshipTypes-eu-hdr"
        }
      }
    ]
  }
}

```
