# Observation: SDOH (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: SDOH (HDR CZ)**

## Resource Profile: Observation: SDOH (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ObservationSdohHdr |

 
Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation). 

**Usages:**

* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Observation/3f85726c-ad2f-441b-89ce-10000000001c](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md), [Observation/3f85726c-ad2f-441b-89ce-10000000001d](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md), [Observation/3f85726c-ad2f-441b-89ce-100000000022](Observation-3f85726c-ad2f-441b-89ce-100000000022.md), [Observation/3f85726c-ad2f-441b-89ce-100000000023](Observation-3f85726c-ad2f-441b-89ce-100000000023.md)...Show 7 more,[Observation/3f85726c-ad2f-441b-89ce-100000000024](Observation-3f85726c-ad2f-441b-89ce-100000000024.md),[Observation/3f85726c-ad2f-441b-89ce-100000000025](Observation-3f85726c-ad2f-441b-89ce-100000000025.md),[Observation/3f85726c-ad2f-441b-89ce-100000000027](Observation-3f85726c-ad2f-441b-89ce-100000000027.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md),[Observation/ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md),[Observation/ExampleSdohSmoking](Observation-ExampleSdohSmoking.md)and[Observation/Observation-Education-level](Observation-Observation-Education-level.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-observation-sdoh-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-sdoh-hdr.csv), [Excel](StructureDefinition-cz-observation-sdoh-hdr.xlsx), [Schematron](StructureDefinition-cz-observation-sdoh-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-sdoh-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/observation-sdoh-eu-hdr"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr",
  "version" : "0.1.0",
  "name" : "CZ_ObservationSdohHdr",
  "title" : "Observation: SDOH (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "Observation status"
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.category:SocialHistory",
        "path" : "Observation.category",
        "sliceName" : "SocialHistory",
        "requirements" : "Used for filtering that this is a social history observation.",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "social-history"
            }
          ]
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "comment" : "*All* code-value and, if present, component.code-component.value pairs need to be taken into account to correctly understand the meaning of the observation.\r\n\r\nFuture refinements of the SDOH categories (e.g., food, housing, transportation, etc.), will allow a better specification of the codes (including LOINC and SNOMED) that pertain to SDOH categories.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/sdoh-obs-snomed-loinc-eu-hdr"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Group",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "comment" : "At least a date should be present unless this observation is a historical report. For recording imprecise or \"fuzzy\" times (For example, a blood glucose measurement taken \"after breakfast\") use the [Timing] datatype which allow the measurement to be tied to regular life events."
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "comment" : "References SHALL be a reference to an actual FHIR resource, and SHALL be resolveable (allowing for access control, temporary unavailability, etc.). Resolution can be either by retrieval from the URL, or, where applicable by resource type, by treating an absolute reference as a canonical URL and looking it up in a local registry/repository.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "http://hl7.org/fhir/StructureDefinition/CareTeam"
            ]
          }
        ]
      },
      {
        "id" : "Observation.performer.reference",
        "path" : "Observation.performer.reference",
        "min" : 1
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "SDOH value"
      },
      {
        "id" : "Observation.note",
        "path" : "Observation.note",
        "short" : "Comments about this SDOH"
      }
    ]
  }
}

```
