# Immunization Recommendation Obligations (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Immunization Recommendation Obligations (HDR CZ)**

## Resource Profile: Immunization Recommendation Obligations (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationrecommendation-obl-hdr | *Version*:0.1.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_ImmunizationRecommendationObligationsHdr |

 
This profile defines the obligations for the ImmunizationRecommendation resource used in the HDR CZ project. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-immunizationrecommendation-obl-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-immunizationrecommendation-obl-hdr.csv), [Excel](StructureDefinition-cz-immunizationrecommendation-obl-hdr.xlsx), [Schematron](StructureDefinition-cz-immunizationrecommendation-obl-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-immunizationrecommendation-obl-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationrecommendation-obl-hdr",
  "version" : "0.1.0",
  "name" : "CZ_ImmunizationRecommendationObligationsHdr",
  "title" : "Immunization Recommendation Obligations (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines the obligations for the ImmunizationRecommendation resource used in the HDR CZ project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ImmunizationRecommendation",
  "baseDefinition" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ImmunizationRecommendation",
        "path" : "ImmunizationRecommendation"
      }
    ]
  }
}

```
