# Encounter (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Encounter (HDR CZ)**

## Resource Profile: Encounter (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_EncounterHdr |

 
This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide. 

### Content (cs)

#### Encounter (HDR CZ)

Resource Encounter (HDR CZ) popisuje konkrétní kontakt pacienta se zdravotnickým zařízením. Je ústředním vazebním prvkem dokumentu – propojuje pacienta, poskytovatele, důvod hospitalizace, průběh, účastníky a místa pobytu. Slouží k zajištění kontinuity péče po propuštění a k možnosti sekundárního využití dat.

#### Základní identifikační údaje kontaktu pacienta se zdravotnickým zařízením

ID, metadata, identifikátory, stav kontaktu, typ péče.

#### Odkazy na související zdroje

pacient, epizody péče, objednávky vyšetření, účty pro vykazování.

#### Účastníci kontaktu

přijímající, propouštějící a doporučující lékaři, další odborníci zapojení do péče, včetně jejich rolí a časových úseků účasti.

#### Časové údaje

období kontaktu, délka, případně návaznost na jiný kontakt.

#### Důvody a diagnózy

kódované i textové důvody hospitalizace, odkazy na stavy (Condition) a postupy (Procedure), role diagnóz (přijetí, propuštění…).

#### Podrobnosti o hospitalizaci

zdroj přijetí, opakovaná hospitalizace, dietní preference, zvláštní ujednání, cílové místo a dispozice při propuštění.

#### Umístění pacienta

oddělení, lůžko, stav lokality a fyzický typ, s časovým vymezením.

#### Poskytovatel služby

organizace odpovědná za tento kontakt.

-------

-------

**Usages:**

* Derived from this Profile: [Encounter: Obligations](StructureDefinition-cz-encounter-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md), [Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md), [Encounter/HospitalEncounter](Encounter-HospitalEncounter.md) and [Encounter/f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-encounter-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-encounter-hdr.csv), [Excel](StructureDefinition-cz-encounter-hdr.xlsx), [Schematron](StructureDefinition-cz-encounter-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-encounter-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/encounter-eu-hdr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr",
  "version" : "0.1.0",
  "name" : "CZ_EncounterHdr",
  "title" : "Encounter (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter.status",
        "path" : "Encounter.status",
        "short" : "Status of this Hospital stay",
        "definition" : "At the discharge report status of the encounter should be always = \"finished\"",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/encounter-status-eu-hdr"
        }
      },
      {
        "id" : "Encounter.class",
        "path" : "Encounter.class",
        "definition" : "Concepts representing classification of inpatient encounter such as inpatient, emergency or others due to local variations.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/hdr-encounterClass-eu-hdr"
        }
      },
      {
        "id" : "Encounter.type",
        "path" : "Encounter.type",
        "short" : "Specific type of Hospital stay",
        "definition" : "Allows to classify encounter using information about care provision regimen during an inpatient encounter.",
        "binding" : {
          "strength" : "example",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/hdr-encounter-type-eu-hdr"
        }
      },
      {
        "id" : "Encounter.serviceType",
        "path" : "Encounter.serviceType",
        "short" : "Specific type of service."
      },
      {
        "id" : "Encounter.priority",
        "path" : "Encounter.priority",
        "short" : "Encounter priority",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/admission-urgency-eu-hdr"
        }
      },
      {
        "id" : "Encounter.subject",
        "path" : "Encounter.subject",
        "short" : "The patient present at the encounter",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.basedOn",
        "path" : "Encounter.basedOn",
        "short" : "The request for which this encounter has been made"
      },
      {
        "id" : "Encounter.participant",
        "path" : "Encounter.participant",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "List of participants involved in the encounters",
        "definition" : "Slice per type of participant: admitter, discharger,.."
      },
      {
        "id" : "Encounter.participant.individual",
        "path" : "Encounter.participant.individual",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant:admitter",
        "path" : "Encounter.participant",
        "sliceName" : "admitter",
        "short" : "Admitting professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:admitter.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "ADM"
            }
          ]
        }
      },
      {
        "id" : "Encounter.participant:discharger",
        "path" : "Encounter.participant",
        "sliceName" : "discharger",
        "short" : "Discharging professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:discharger.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "DIS"
            }
          ]
        }
      },
      {
        "id" : "Encounter.participant:referrer",
        "path" : "Encounter.participant",
        "sliceName" : "referrer",
        "short" : "Referring professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Encounter.participant:referrer.type",
        "path" : "Encounter.participant.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "REF"
            }
          ]
        }
      },
      {
        "id" : "Encounter.period",
        "path" : "Encounter.period",
        "short" : "The start and end time of this encounter.",
        "definition" : "The start and end time of this inpatient stay.",
        "min" : 1
      },
      {
        "id" : "Encounter.reasonCode",
        "path" : "Encounter.reasonCode",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/condition-eu-hdr"
        }
      },
      {
        "id" : "Encounter.reasonReference",
        "path" : "Encounter.reasonReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Procedure"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.diagnosis",
        "path" : "Encounter.diagnosis",
        "short" : "The list of diagnosis relevant to this encounter, see comment",
        "comment" : "While Encounter.diagnosis could be optionally populated, mainly for administrative purposes, we strongly recommend to put all clinical relevant diagnoses, stated at start, during and at the end of the hospital stay, into the corresponding section(s) of the HDR."
      },
      {
        "id" : "Encounter.diagnosis.condition",
        "path" : "Encounter.diagnosis.condition",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.hospitalization.admitSource",
        "path" : "Encounter.hospitalization.admitSource",
        "short" : "From where patient was admitted (physician referral, transfer)."
      },
      {
        "id" : "Encounter.hospitalization.destination",
        "path" : "Encounter.hospitalization.destination",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.location",
        "path" : "Encounter.location",
        "short" : "Locations where the patient stayed"
      },
      {
        "id" : "Encounter.location.location",
        "path" : "Encounter.location.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-location-core"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.location.period",
        "path" : "Encounter.location.period",
        "short" : "Location period"
      },
      {
        "id" : "Encounter.serviceProvider",
        "path" : "Encounter.serviceProvider",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      }
    ]
  }
}

```
