# Allergy Intolerance (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Allergy Intolerance (HDR CZ)**

## Resource Profile: Allergy Intolerance (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_AllergyIntoleranceHdr |

 
This profile constrains the AllergyIntolerance resource for the purpose of this project. 

 
This profile constrains the AllergyIntolerance resource for the purpose of project. 

**Usages:**

* Derived from this Profile: [Allergy Intolerance Obligations (HDR CZ)](StructureDefinition-cz-allergyintolerance-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/AllergyInfoUnknown](AllergyIntolerance-AllergyInfoUnknown.md), [AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md), [AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md)...Show 2 more,[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md)and[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-allergyIntolerance-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-allergyIntolerance-hdr.csv), [Excel](StructureDefinition-cz-allergyIntolerance-hdr.xlsx), [Schematron](StructureDefinition-cz-allergyIntolerance-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-allergyIntolerance-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips|2.0.0"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr",
  "version" : "0.1.0",
  "name" : "CZ_AllergyIntoleranceHdr",
  "title" : "Allergy Intolerance (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile constrains the AllergyIntolerance resource for the purpose of this project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the AllergyIntolerance resource for the purpose of project.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance"
      },
      {
        "id" : "AllergyIntolerance.extension",
        "path" : "AllergyIntolerance.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "AllergyIntolerance.extension:abatement",
        "path" : "AllergyIntolerance.extension",
        "sliceName" : "abatement",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement|5.3.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.extension:abatement.value[x]",
        "path" : "AllergyIntolerance.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "AllergyIntolerance.extension:abatement.value[x]:valueDateTime",
        "path" : "AllergyIntolerance.extension.value[x]",
        "sliceName" : "valueDateTime",
        "short" : "End date",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AllergyIntolerance.code",
        "path" : "AllergyIntolerance.code",
        "min" : 1
      }
    ]
  }
}

```
