# A.1.1 - Identifikace a A.1.2 - informace o pacientovi - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.1 - Identifikace a A.1.2 - informace o pacientovi**

## Logical Model: A.1.1 - Identifikace a A.1.2 - informace o pacientovi 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogSubjectCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzSubjectHdrCz |

 
Nemocniční propouštěcí zpráva - Informace o pacientovi. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogSubjectCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogSubjectCz.csv), [Excel](StructureDefinition-LogSubjectCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogSubjectCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogSubjectCz",
  "version" : "0.1.0",
  "name" : "LogCzSubjectHdrCz",
  "title" : "A.1.1 - Identifikace a A.1.2 - informace o pacientovi",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Informace o pacientovi.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogSubjectCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogSubjectCz",
        "path" : "LogSubjectCz",
        "short" : "A.1.1 - Identifikace a A.1.2 - informace o pacientovi",
        "definition" : "Nemocniční propouštěcí zpráva - Informace o pacientovi."
      },
      {
        "id" : "LogSubjectCz.pacient",
        "path" : "LogSubjectCz.pacient",
        "short" : "A.1.1 Identifikace pacienta",
        "definition" : "Identifikace pacienta – křestní jméno, příjmení, datum narození, identifikátory, státní občanství, úřední pohlaví, komunikační jazyk.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.pacient.jmeno",
        "path" : "LogSubjectCz.pacient.jmeno",
        "short" : "A.1.1.1 Křestní jméno",
        "definition" : "Křestní jméno pacienta.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.pacient.prijmeni",
        "path" : "LogSubjectCz.pacient.prijmeni",
        "short" : "A.1.1.2 Příjmení",
        "definition" : "Příjmení pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.pacient.datumNarozeni",
        "path" : "LogSubjectCz.pacient.datumNarozeni",
        "short" : "A.1.1.3 Datum narození",
        "definition" : "Datum, případně i čas narození pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.pacient.identifikator",
        "path" : "LogSubjectCz.pacient.identifikator",
        "short" : "A.1.1.4 Identifikátor pacienta",
        "definition" : "Unikátní identifikátor osoby – RID, DRID, číslo pasu atd.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.pacient.narodnost",
        "path" : "LogSubjectCz.pacient.narodnost",
        "short" : "A.1.1.5 Státní občanství",
        "definition" : "Státní občanství podle zákona 186/2013 Sb.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.pacient.pohlavi",
        "path" : "LogSubjectCz.pacient.pohlavi",
        "short" : "A.1.1.6 Úřední pohlaví",
        "definition" : "Administrativní pohlaví podle dokladů.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.pacient.jazyk",
        "path" : "LogSubjectCz.pacient.jazyk",
        "short" : "A.1.1.7 Komunikační jazyk",
        "definition" : "Jazyk nebo jazyky, jimiž pacient komunikuje.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt",
        "path" : "LogSubjectCz.kontakt",
        "short" : "A.1.2 Kontaktní informace pacienta",
        "definition" : "Kontaktní údaje pacienta, včetně adresy, kontaktů a preferovaného lékaře.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.adresa",
        "path" : "LogSubjectCz.kontakt.adresa",
        "short" : "A.1.2.1 Adresa",
        "definition" : "Poštovní adresa (řádky adresy, město, PSČ, země).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.telefon",
        "path" : "LogSubjectCz.kontakt.telefon",
        "short" : "A.1.2.2 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar",
        "short" : "A.1.2.3 Preferovaný lékař",
        "definition" : "Identifikace preferovaného lékaře, u kterého je pacient evidován.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.idLekare",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.idLekare",
        "short" : "A.1.2.3.1 Identifikátor lékaře",
        "definition" : "Identifikační číslo lékaře dle NR-ZP.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.jmenoLekare",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.jmenoLekare",
        "short" : "A.1.2.3.2 Jméno lékaře",
        "definition" : "Plné jméno lékaře.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.specializace",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.specializace",
        "short" : "A.1.2.3.3 Specializace",
        "definition" : "Specializace lékaře podle číselníku NR-ZP.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.idPoskytovatele",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.idPoskytovatele",
        "short" : "A.1.2.3.4 ID a název poskytovatele",
        "definition" : "Identifikátor a název poskytovatele, kterého lékař reprezentuje.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "short" : "A.1.2.3.5 Adresa poskytovatele",
        "definition" : "Poštovní adresa poskytovatele zdravotní péče.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "path" : "LogSubjectCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "short" : "A.1.2.3.6 Telekomunikační kontakt",
        "definition" : "Telefon nebo e-mail poskytovatele.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba",
        "short" : "A.1.2.4 Zákonný zástupce a kontaktní osoba",
        "definition" : "Kontaktní osoba – např. zákonný zástupce nebo jiná blízká osoba.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba.typ",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba.typ",
        "short" : "A.1.2.4.1 Typ kontaktu",
        "definition" : "Typ kontaktní osoby – zákonný zástupce, emergentní kontakt apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba.vztah",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba.vztah",
        "short" : "A.1.2.4.2 Vztah k pacientovi",
        "definition" : "Rodinný nebo jiný vztah ke kontaktované osobě.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba.idOsoby",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba.idOsoby",
        "short" : "A.1.2.4.3 Id osoby",
        "definition" : "Unikátní identifikátor kontaktní osoby.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba.jmeno",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba.jmeno",
        "short" : "A.1.2.4.4 Křestní jméno",
        "definition" : "Křestní jméno kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba.prijmeni",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba.prijmeni",
        "short" : "A.1.2.4.5 Příjmení",
        "definition" : "Příjmení kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba.adresa",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba.adresa",
        "short" : "A.1.2.4.6 Adresa kontaktní osoby",
        "definition" : "Adresa kontaktní osoby.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogSubjectCz.kontakt.kontaktniOsoba.kontakt",
        "path" : "LogSubjectCz.kontakt.kontaktniOsoba.kontakt",
        "short" : "A.1.2.4.7 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
