# A.2.6 - Anamnéza - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.6 - Anamnéza**

## Logical Model: A.2.6 - Anamnéza 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogPatientHistoryCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzPatientHistoryCz |

 
Nemocniční propouštěcí zpráva - Anamnéza 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogPatientHistoryCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogPatientHistoryCz.csv), [Excel](StructureDefinition-LogPatientHistoryCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogPatientHistoryCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPatientHistoryCz",
  "version" : "0.1.0",
  "name" : "LogCzPatientHistoryCz",
  "title" : "A.2.6 - Anamnéza",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Anamnéza",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogPatientHistoryCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogPatientHistoryCz",
        "path" : "LogPatientHistoryCz",
        "short" : "A.2.6 - Anamnéza",
        "definition" : "Nemocniční propouštěcí zpráva - Anamnéza"
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni",
        "path" : "LogPatientHistoryCz.anamnezaOsobni",
        "short" : "A.2.6.1 - Osobní",
        "definition" : "Osobní Anamnéza",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy",
        "short" : "A.2.6.1.1 - Historie zdravotních problémů",
        "definition" : "Historie zdravotních problémů jiných, než je nynější onemocnění (které je součástí klinického shrnutí).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.popisProblemu",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.popisProblemu",
        "short" : "A.2.6.1.1.1 - Popis problému",
        "definition" : "Popis problému textem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.kod",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.kod",
        "short" : "A.2.6.1.1.2 - Kód",
        "definition" : "Formalizované vyjádření zdravotního problému kódem (klasifikace).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVzniku",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVzniku",
        "short" : "A.2.6.1.1.3 - Datum vzniku",
        "definition" : "Datum či částečné datum případně věková kategorie vzniku onemocnění",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVyreseni",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.datumVyreseni",
        "short" : "A.2.6.1.1.4 - Datum vyřešení či remise",
        "definition" : "Datum či částečné datum případně věková kategorie vyřešení či ustoupení problému do remise. Problémy jejichž klinický stav je \"aktivní\" nemají tento údaj vyplněn.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.klinickyStav",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.klinickyStav",
        "short" : "A.2.6.1.1.5 - Klinický stav problému",
        "definition" : "Klasifikace klinického stavu problému (aktivní, neaktivní).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.okolnostiVyreseni",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.okolnostiVyreseni",
        "short" : "A.2.6.1.1.6 - Okolnosti vyřešení",
        "definition" : "Důvod, pro který se stav problému změnil na neaktivní...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.zavaznost",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.zavaznost",
        "short" : "A.2.6.1.1.7 - Závažnost",
        "definition" : "Subjektivní hodnocení závažnosti problému klinikem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.stadiumOnemocneni",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zdravotniProblemy.stadiumOnemocneni",
        "short" : "A.2.6.1.1.8 - Stadium onemocnění",
        "definition" : "Stadium/grading problému dle zvolené škály textem a/nebo kódem.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zP",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zP",
        "short" : "A.2.6.1.2 - Historie zdravotních pomůcek a implantátů",
        "definition" : "Historie implantátů a zdravotních pomůcek...",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zP.popis",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zP.popis",
        "short" : "A.2.6.1.2.1 - Popis zdravotnického prostředku",
        "definition" : "Popis zdravotnického prostředku...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zP.idZP",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zP.idZP",
        "short" : "A.2.6.1.2.2 - Identifikátor zdravotnického prostředku",
        "definition" : "Normalizovaný identifikátor...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zP.datumZavedeni",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zP.datumZavedeni",
        "short" : "A.2.6.1.2.3 - Datum zavedení",
        "definition" : "Datum implantace...",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zP.datumOdstraneni",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zP.datumOdstraneni",
        "short" : "A.2.6.1.2.4 - Datum odstranění",
        "definition" : "Datum explantace...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.zP.duvod",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.zP.duvod",
        "short" : "A.2.6.1.2.5 - Důvod použití",
        "definition" : "Klinický důvod zavedení...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony",
        "short" : "A.2.6.1.3 - Významné výkony",
        "definition" : "Významné výkony...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.kodVykonu",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.kodVykonu",
        "short" : "A.2.6.1.3.1 - Kód výkonu",
        "definition" : "Kód výkonu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.popis",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.popis",
        "short" : "A.2.6.1.3.2 - Popis procedury",
        "definition" : "Popis výkonu volným textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.lokalizace",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.lokalizace",
        "short" : "A.2.6.1.3.3 - Lokalizace",
        "definition" : "Anatomická lokace...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.datum",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.datum",
        "short" : "A.2.6.1.3.4 - Datum provedení",
        "definition" : "Datum provedení výkonu...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.duvod",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.duvod",
        "short" : "A.2.6.1.3.5 - Důvod provedení",
        "definition" : "Důvod provedení výkonu...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.vysledek",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.vysledek",
        "short" : "A.2.6.1.3.6 - Výsledek",
        "definition" : "Formalizované vyjádření výsledku výkonu...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.pouzityZP",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.vyznamneVykony.pouzityZP",
        "short" : "A.2.6.1.3.7 - Použitý zdravotnický prostředek",
        "definition" : "Zdravotnický prostředek...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani",
        "short" : "A.2.6.1.4 - Očkování",
        "definition" : "Historie očkování.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.puvodce",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.puvodce",
        "short" : "A.2.6.1.4.1 - Onemocnění či původce",
        "definition" : "Onemocnění či původce...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.typVakciny",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.typVakciny",
        "short" : "A.2.6.1.4.2 - Typ vakcíny",
        "definition" : "Typ vakcíny vyjádřený kódem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.ockovaciLatka",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.ockovaciLatka",
        "short" : "A.2.6.1.4.4 - Očkovací látka",
        "definition" : "Registrovaný název vakcíny...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.vyrobceVakciny",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.vyrobceVakciny",
        "short" : "A.2.6.1.4.5 - Držitel rozhodnutí",
        "definition" : "Výrobce vakcíny...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.poradoveCislo",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.poradoveCislo",
        "short" : "A.2.6.1.4.6 - Pořadové číslo dávky",
        "definition" : "Pořadové číslo dávky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.datumPodani",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.datumPodani",
        "short" : "A.2.6.1.4.7 - Datum podání dávky",
        "definition" : "Přesné nebo přibližné datum podání.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.pristiVakcinace",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.ockovani.pristiVakcinace",
        "short" : "A.2.6.1.4.8 - Datum příští vakcinace",
        "definition" : "Datum doporučeného přeočkování.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza",
        "short" : "A.2.6.1.5 - Epidemiologická anamnéza",
        "definition" : "Cestovatelská anamnéza a infekční kontakty.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt",
        "short" : "A.2.6.1.5.1 - Infekční kontakty",
        "definition" : "Infekční kontakty pacienta",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.period",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.period",
        "short" : "A.2.6.1.5.1.1 - Období",
        "definition" : "Období trvání infekčního kontaktu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.infectiousAgent",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.infectiousAgent",
        "short" : "A.2.6.1.5.1.2 - Infekční onemocnění či agens",
        "definition" : "In infekce...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.proximity",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.proximity",
        "short" : "A.2.6.1.5.1.3 - Vzdálenost",
        "definition" : "Typ expozice či vzdálenost...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.zeme",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.zeme",
        "short" : "A.2.6.1.5.1.4 - Země",
        "definition" : "Země, kde došlo ke kontaktu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.komentar",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.infekcniKontakt.komentar",
        "short" : "A.2.6.1.5.1.5 - Komentář",
        "definition" : "Poznámky...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza",
        "short" : "A.2.6.1.5.2 - Cestovatelská anamnéza",
        "definition" : "Cestovatelská anamnéza.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.obdobi",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.obdobi",
        "short" : "A.2.6.1.5.2.1 - Období",
        "definition" : "Přesné či přibližné období pobytu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.zeme",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.zeme",
        "short" : "A.2.6.1.5.2.2 - Země",
        "definition" : "Navštívená země.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.komentar",
        "path" : "LogPatientHistoryCz.anamnezaOsobni.epidemiologickaAnamneza.cestovatelskaAnamneza.komentar",
        "short" : "A.2.6.1.5.2.3 - Komentář",
        "definition" : "Poznámky k pobytu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.rodinnaAnamneza",
        "path" : "LogPatientHistoryCz.rodinnaAnamneza",
        "short" : "A.2.6.2 - Rodinná anamnéza",
        "definition" : "Informace o závažných onemocněních u blízkých pokrevně příbuzných...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.rodinnaAnamneza.vztahKPacientovi",
        "path" : "LogPatientHistoryCz.rodinnaAnamneza.vztahKPacientovi",
        "short" : "A.2.6.2.1 - Vztah k pacientovi",
        "definition" : "Vztah osoby k pacientovi.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.rodinnaAnamneza.datumNarozeni",
        "path" : "LogPatientHistoryCz.rodinnaAnamneza.datumNarozeni",
        "short" : "A.2.6.2.2 - Datum narození",
        "definition" : "Přesné či přibližné datum narození.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.rodinnaAnamneza.vekUmrti",
        "path" : "LogPatientHistoryCz.rodinnaAnamneza.vekUmrti",
        "short" : "A.2.6.2.3 - Věk úmrtí",
        "definition" : "Věk nebo datum úmrtí.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.rodinnaAnamneza.zdravotniProblemy",
        "path" : "LogPatientHistoryCz.rodinnaAnamneza.zdravotniProblemy",
        "short" : "A.2.6.2.5 - Zdravotní problémy",
        "definition" : "Zdravotní problémy, jimiž osoba trpí či trpěla.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.rodinnaAnamneza.duvodUmrti",
        "path" : "LogPatientHistoryCz.rodinnaAnamneza.duvodUmrti",
        "short" : "A.2.6.2.6 - Důvod úmrtí",
        "definition" : "Příčina úmrtí.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza",
        "path" : "LogPatientHistoryCz.socialniAnamneza",
        "short" : "A.2.6.3 - Sociální anamnéza",
        "definition" : "Sociální anamnéza",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni",
        "path" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni",
        "short" : "A.2.6.3.1 - Společenské uplatnění",
        "definition" : "Společenské zapojení...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.pracovniZapojeni",
        "path" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.pracovniZapojeni",
        "short" : "A.2.6.3.1.1 - Pracovní zapojení",
        "definition" : "Pracovním zapojením je...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.konicky",
        "path" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.konicky",
        "short" : "A.2.6.3.1.2 - Koníčky",
        "definition" : "Záliby...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.socialniSit",
        "path" : "LogPatientHistoryCz.socialniAnamneza.spolecenskeUplatneni.socialniSit",
        "short" : "A.2.6.3.1.3 - Sociální síť",
        "definition" : "Popis sociální sítě...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.vzdelani",
        "path" : "LogPatientHistoryCz.socialniAnamneza.vzdelani",
        "short" : "A.2.6.3.2 - Vzdělání",
        "definition" : "Vzdělání",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.vzdelani.uroven",
        "path" : "LogPatientHistoryCz.socialniAnamneza.vzdelani.uroven",
        "short" : "A.2.6.3.2.1 - Dosažený stupeň vzdělání",
        "definition" : "Stupeň dosaženého vzdělání",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.vzdelani.komentar",
        "path" : "LogPatientHistoryCz.socialniAnamneza.vzdelani.komentar",
        "short" : "A.2.6.3.2.2 - Komentář",
        "definition" : "Upřesnění...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.bydleni",
        "path" : "LogPatientHistoryCz.socialniAnamneza.bydleni",
        "short" : "A.2.6.3.3 - Bydlení",
        "definition" : "Způsob bydlení...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.bydleni.zpusobBydleni",
        "path" : "LogPatientHistoryCz.socialniAnamneza.bydleni.zpusobBydleni",
        "short" : "A.2.6.3.3.1 - Způsob bydlení",
        "definition" : "Druh bydlení...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.bydleni.prizpusobeni",
        "path" : "LogPatientHistoryCz.socialniAnamneza.bydleni.prizpusobeni",
        "short" : "A.2.6.3.3.2 - Přizpůsobení",
        "definition" : "Úpravy domácnosti...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.bydleni.bariery",
        "path" : "LogPatientHistoryCz.socialniAnamneza.bydleni.bariery",
        "short" : "A.2.6.3.3.3 - Bariéry",
        "definition" : "Podmínky bezbariérovosti.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace",
        "short" : "A.2.6.3.4 - Rodinná situace",
        "definition" : "Podrobnosti rodinné situace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.komentar",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.komentar",
        "short" : "A.2.6.3.4.1 - Komentář",
        "definition" : "Komentář k rodinné situaci.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.slozeniRodiny",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.slozeniRodiny",
        "short" : "A.2.6.3.4.2 - Složení rodiny",
        "definition" : "Složení rodiny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.rodinnyStav",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.rodinnyStav",
        "short" : "A.2.6.3.4.3 - Rodinný stav",
        "definition" : "Rodinný stav.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDeti",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDeti",
        "short" : "A.2.6.3.4.4 - Počet dětí",
        "definition" : "Celkový počet dětí...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDetiDoma",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.pocetDetiDoma",
        "short" : "A.2.6.3.4.5 - Počet dětí ve společné domácnosti",
        "definition" : "Počet dětí žijících doma.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.podrobnostiODiteti",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.podrobnostiODiteti",
        "short" : "A.2.6.3.4.6 - Podrobnosti o dítěti",
        "definition" : "Pro každé dítě: datum narození...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.pecujeO",
        "path" : "LogPatientHistoryCz.socialniAnamneza.rodinnaSituace.pecujeO",
        "short" : "A.2.6.3.4.7 - Pečuje o",
        "definition" : "Činnosti, které pacient vykonává při péči o závislého člena rodiny.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus",
        "path" : "LogPatientHistoryCz.abusus",
        "short" : "A.2.6.4 - Abusus",
        "definition" : "Informace o pravidelném kouření...",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.alkohol",
        "path" : "LogPatientHistoryCz.abusus.alkohol",
        "short" : "A.2.6.4.1 - Alkohol",
        "definition" : "Konzumace alkoholu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.alkohol.stav",
        "path" : "LogPatientHistoryCz.abusus.alkohol.stav",
        "short" : "A.2.6.4.1.1 - Stav",
        "definition" : "Aktuální stav.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.alkohol.mnozstvi",
        "path" : "LogPatientHistoryCz.abusus.alkohol.mnozstvi",
        "short" : "A.2.6.4.1.2 - Období a množství",
        "definition" : "Období a množství.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.alkohol.komentar",
        "path" : "LogPatientHistoryCz.abusus.alkohol.komentar",
        "short" : "A.2.6.4.1.3 - Komentář",
        "definition" : "Komentář volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.koureni",
        "path" : "LogPatientHistoryCz.abusus.koureni",
        "short" : "A.2.6.4.2 - Kouření",
        "definition" : "Kouření.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.koureni.stav",
        "path" : "LogPatientHistoryCz.abusus.koureni.stav",
        "short" : "A.2.6.4.2.1 - Stav",
        "definition" : "Stav kouření kódem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.koureni.mnozstvi",
        "path" : "LogPatientHistoryCz.abusus.koureni.mnozstvi",
        "short" : "A.2.6.4.2.2 - Období a průměrné množství.",
        "definition" : "Období a množství.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.koureni.komentar",
        "path" : "LogPatientHistoryCz.abusus.koureni.komentar",
        "short" : "A.2.6.4.2.3 - Komentář",
        "definition" : "Komentář volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.drogy",
        "path" : "LogPatientHistoryCz.abusus.drogy",
        "short" : "A.2.6.4.3 - Drogy",
        "definition" : "Drogová závislost.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.drogy.stav",
        "path" : "LogPatientHistoryCz.abusus.drogy.stav",
        "short" : "A.2.6.4.3.1 - Stav",
        "definition" : "Aktuální stav drogové závislosti.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.drogy.mnozstvi",
        "path" : "LogPatientHistoryCz.abusus.drogy.mnozstvi",
        "short" : "A.2.6.4.3.2 - Období a množství",
        "definition" : "Období a množství/kvantifikace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.drogy.typLatky",
        "path" : "LogPatientHistoryCz.abusus.drogy.typLatky",
        "short" : "A.2.6.4.3.3 - Typ látky",
        "definition" : "Typ užívané látky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.drogy.zpusobPodani",
        "path" : "LogPatientHistoryCz.abusus.drogy.zpusobPodani",
        "short" : "A.2.6.4.3.4 - Způsob podávání",
        "definition" : "Způsob administrace látky.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogPatientHistoryCz.abusus.drogy.komentar",
        "path" : "LogPatientHistoryCz.abusus.drogy.komentar",
        "short" : "A.2.6.4.3.5 - Komentář",
        "definition" : "Komentář volným textem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
