# A.2.7 Průběh hospitalizace - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.7 Průběh hospitalizace**

## Logical Model: A.2.7 Průběh hospitalizace 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogHospitalStayCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzHospitalStayCz |

 
Nemocniční propouštěcí zpráva - Popis průběhu hospitalizace zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogHospitalStayCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogHospitalStayCz.csv), [Excel](StructureDefinition-LogHospitalStayCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogHospitalStayCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHospitalStayCz",
  "version" : "0.1.0",
  "name" : "LogCzHospitalStayCz",
  "title" : "A.2.7 Průběh hospitalizace",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Popis průběhu hospitalizace zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHospitalStayCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogHospitalStayCz",
        "path" : "LogHospitalStayCz",
        "short" : "A.2.7 Průběh hospitalizace",
        "definition" : "Nemocniční propouštěcí zpráva - Popis průběhu hospitalizace zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí."
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn",
        "path" : "LogHospitalStayCz.diagnostickySouhrn",
        "short" : "A.2.7.1 Diagnostický souhrn",
        "definition" : "Všechny problémy/diagnózy, které ovlivňují péči během hospitalizace nebo které je důležité zaznamenat pro zajištění kontinuity péče. Rozlišuje se mezi problémy léčenými a neléčenými, dále mezi stavy přítomnými při přijetí, získanými během hospitalizace a neklasifikovatelnými. Popis je strukturovaný, dobře specifikovaný a kódovatelný.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.popisProblemu",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.popisProblemu",
        "short" : "A.2.7.1.1 - Popis problému",
        "definition" : "Popis problému textem",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.detail",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.detail",
        "short" : "A.2.7.1.2 - Kód",
        "definition" : "Formalizované vyjádření zdravotního problému kódem (klasifikace).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.datumVzniku",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.datumVzniku",
        "short" : "A.2.7.1.3 - Datum vzniku",
        "definition" : "Datum vzniku onemocnění. Přesné nebo přibližné datum.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.datumVyreseniRemise",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.datumVyreseniRemise",
        "short" : "A.2.7.1.4 - Datum vyřešení či remise",
        "definition" : "Datum vyřešení či ustoupení problému do remise.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.kategorieProblemu",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.kategorieProblemu",
        "short" : "A.2.7.1.5 - Kategorie problému",
        "definition" : "- POA - Stav byl přítomen při přijetí\n- HAC - Stav byl získán v průběhu hospitalizace\n- N/A - Nelze rozhodnout nebo není známo",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.kategoriePece",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.kategoriePece",
        "short" : "A.2.7.1.6 - Kategorie péče",
        "definition" : "Klasifikace problému z hlediska poskytované péče.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.okolnostiVyreseni",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.okolnostiVyreseni",
        "short" : "A.2.7.1.7 - Okolnosti vyřešení",
        "definition" : "Důvod změny stavu problému na neaktivní (např. chirurgický zákrok).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.zavaznost",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.zavaznost",
        "short" : "A.2.7.1.8 - Závažnost",
        "definition" : "Subjektivní hodnocení závažnosti problému klinikem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.diagnostickySouhrn.stadiumOnemocneni",
        "path" : "LogHospitalStayCz.diagnostickySouhrn.stadiumOnemocneni",
        "short" : "A.2.7.1.9 - Stadium onemocnění",
        "definition" : "Stadium/grading problému dle zvolené škály (např. TNM, MKN-O).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony",
        "path" : "LogHospitalStayCz.vyznamneVykony",
        "short" : "A.2.7.2 Významné výkony (procedury)",
        "definition" : "Operace a ostatní „instrumentální“ intervence (endoskopické, intravaskulární) provedené v průběhu hospitalizace. Nezahrnuje čistě diagnostické výkony. Pokud nebyl proveden žádný výkon, uvede se IPS Absent/Unknown.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.kodVykonu",
        "path" : "LogHospitalStayCz.vyznamneVykony.kodVykonu",
        "short" : "A.2.7.2.1 - Kód výkonu",
        "definition" : "Kód výkonu ve zvoleném kódovém systému",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.popisProcedury",
        "path" : "LogHospitalStayCz.vyznamneVykony.popisProcedury",
        "short" : "A.2.7.2.2 - Popis procedury",
        "definition" : "Popis výkonu volným textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.lokalizace",
        "path" : "LogHospitalStayCz.vyznamneVykony.lokalizace",
        "short" : "A.2.7.2.3 - Lokalizace",
        "definition" : "Anatomická lokace a strana výkonu s použitím řízené terminologie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.datumProvedeni",
        "path" : "LogHospitalStayCz.vyznamneVykony.datumProvedeni",
        "short" : "A.2.7.2.4 - Datum provedení",
        "definition" : "Datum provedení výkonu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.duvodProvedeni",
        "path" : "LogHospitalStayCz.vyznamneVykony.duvodProvedeni",
        "short" : "A.2.7.2.5 - Důvod provedení",
        "definition" : "Důvod provedení výkonu textem nebo kódem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.vysledek",
        "path" : "LogHospitalStayCz.vyznamneVykony.vysledek",
        "short" : "A.2.7.2.6 - Výsledek",
        "definition" : "Formalizované vyjádření výsledku výkonu. Aplikovatelné především na chirurgické výkony.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.komplikace",
        "path" : "LogHospitalStayCz.vyznamneVykony.komplikace",
        "short" : "A.2.7.2.7 - Komplikace",
        "definition" : "Komplikace spojené s výkonem (v průběhu výkonu či bezprostředně po něm).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vyznamneVykony.cilovyZdravProstredek",
        "path" : "LogHospitalStayCz.vyznamneVykony.cilovyZdravProstredek",
        "short" : "A.2.7.2.8 - Cílový zdravotnický prostředek",
        "definition" : "Odkaz na zdravotnický prostředek, který byl implantován, odstraněn nebo s ním bylo jinak manipulováno (kalibrace, výměna baterie, nasazení protézy atd.) v průběhu procedury.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.zp",
        "path" : "LogHospitalStayCz.zp",
        "short" : "A.2.7.3 Zdravotní pomůcky a implantáty",
        "definition" : "Zavedené a používané zdravotní pomůcky nebo odebrané zdravotnické prostředky ovlivňující diagnostiku nebo léčbu. Pokud nejsou, uvede se důvod podle IPS.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.zp.popisProstredku",
        "path" : "LogHospitalStayCz.zp.popisProstredku",
        "short" : "A.2.7.3.1 - Popis zdravotnického prostředku",
        "definition" : "Popis zdravotnického prostředku (implantovaného či externího) volným textem a/nebo kódem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.zp.identifikatorProstredku",
        "path" : "LogHospitalStayCz.zp.identifikatorProstredku",
        "short" : "A.2.7.3.2 - Identifikátor prostředku",
        "definition" : "Normalizovaný identifikátor, např. UDI, dle nařízení EU 2017/745",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.zp.datumZavedeni",
        "path" : "LogHospitalStayCz.zp.datumZavedeni",
        "short" : "A.2.7.3.3 - Datum zavedení",
        "definition" : "Datum implantace či počátku užívání zdravotnického prostředku. Může být uvedeno i přibližné datum, pokud přesné datum není známo.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.zp.datumOdstraneni",
        "path" : "LogHospitalStayCz.zp.datumOdstraneni",
        "short" : "A.2.7.3.4 - Datum odstranění",
        "definition" : "Datum explantace či ukončení užívání zdravotnického prostředku. Může být uvedeno i přibližné datum, pokud přesné datum není známo.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.zp.duvodPouziti",
        "path" : "LogHospitalStayCz.zp.duvodPouziti",
        "short" : "A.2.7.3.5 - Důvod použití",
        "definition" : "Klinický důvod zavedení či odstranění zdravotnického prostředku vyjádřený textem a/nebo kódem zdravotního problému.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.dalsiVyznamnaLecba",
        "path" : "LogHospitalStayCz.dalsiVyznamnaLecba",
        "short" : "A.2.7.4 Další významná léčba",
        "definition" : "Léčby, které nelze jednoznačně označit jako výkony, ale jsou významné (např. chemoterapie, dialýza, hemoperfuze, podpora oběhu, krevní deriváty apod.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.dalsiVyznamnaLecba.popisProcedury",
        "path" : "LogHospitalStayCz.dalsiVyznamnaLecba.popisProcedury",
        "short" : "A.2.7.4.1 - Popis procedury",
        "definition" : "Popis výkonu volným textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.dalsiVyznamnaLecba.lokalizace",
        "path" : "LogHospitalStayCz.dalsiVyznamnaLecba.lokalizace",
        "short" : "A.2.7.4.2 - Lokalizace",
        "definition" : "Anatomická lokalizace a strana výkonu s použitím řízené terminologie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.dalsiVyznamnaLecba.datumProvedeni",
        "path" : "LogHospitalStayCz.dalsiVyznamnaLecba.datumProvedeni",
        "short" : "A.2.7.4.3 - Datum provedení",
        "definition" : "Datum provedení výkonu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.dalsiVyznamnaLecba.duvodProvedeni",
        "path" : "LogHospitalStayCz.dalsiVyznamnaLecba.duvodProvedeni",
        "short" : "A.2.7.4.4 - Důvod provedení",
        "definition" : "Důvod provedení výkonu textem nebo kódem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace",
        "path" : "LogHospitalStayCz.medikace",
        "short" : "A.2.7.5 Medikace",
        "definition" : "Medikamentózní léčba během hospitalizace, jejíž znalost je významná pro další péči. Patří sem léčiva podaná a ukončená během hospitalizace nebo pokračující krátkodobě. Léčiva doporučená i po propuštění budou uvedena v části Doporučení.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.indikace",
        "path" : "LogHospitalStayCz.medikace.indikace",
        "short" : "A.2.7.5.1 - Indikace",
        "definition" : "Důvod medikace. Důvod může být popsán textem případně odkazem na zdravotní důvod (zdravotní problém v seznamu problémů).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.kodSUKL",
        "path" : "LogHospitalStayCz.medikace.kodSUKL",
        "short" : "A.2.7.5.2 - Kód SUKL",
        "definition" : "Kód léčiva dle databáze SÚKL",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.nazevLecivehoPripravku",
        "path" : "LogHospitalStayCz.medikace.nazevLecivehoPripravku",
        "short" : "A.2.7.5.3 - Název léčivého přípravku",
        "definition" : "Registrovaný název léčiva dle databáze léčivých přípravků.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.aktivniLatky",
        "path" : "LogHospitalStayCz.medikace.aktivniLatky",
        "short" : "A.2.7.5.4 - Aktivní látky",
        "definition" : "Seznam aktivních látek v léčivu odvozený od záznamu HVLP nebo IVLP přípravku v databázi SUKL (DLP). Aktivní látky jsou uváděny názvem a případně také kódem ATC či IDMP dle registru substancí SRS.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.sila",
        "path" : "LogHospitalStayCz.medikace.sila",
        "short" : "A.2.7.5.5 - Síla",
        "definition" : "Síla aktivní léčivé látky obsažené v léčivém přípravku. Síla se vyjadřuje ve vztahu k jednotce podání. Např. 500mg v tabletě.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.formaLeciva",
        "path" : "LogHospitalStayCz.medikace.formaLeciva",
        "short" : "A.2.7.5.6 - Forma léčiva",
        "definition" : "Léková forma obsažená v balení vyjádřená kódem. Např. Sirup, tableta apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.davkovani",
        "path" : "LogHospitalStayCz.medikace.davkovani",
        "short" : "A.2.7.5.7 - Dávkování",
        "definition" : "Frekvence a počet jednotek podání volným textem nebo formalizovaně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.cestaPodani",
        "path" : "LogHospitalStayCz.medikace.cestaPodani",
        "short" : "A.2.7.5.8 - Cesta podání",
        "definition" : "Cesta podání",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.medikace.obdobiPodavani",
        "path" : "LogHospitalStayCz.medikace.obdobiPodavani",
        "short" : "A.2.7.5.9 - Období podávání",
        "definition" : "Časový interval kdy pacientovi byla, případně nebyla medikace podávána.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.vysledkyVysetreni",
        "path" : "LogHospitalStayCz.vysledkyVysetreni",
        "short" : "A.2.7.6 Výsledky vyšetření",
        "definition" : "Významné výsledky funkčních, diagnostických a zobrazovacích vyšetření, provedených během hospitalizace. Výsledky s nezpracovaným stavem („registered“) mají být uvedeny odděleně.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.klinickeShrnuti",
        "path" : "LogHospitalStayCz.klinickeShrnuti",
        "short" : "A.2.7.7 Klinické shrnutí",
        "definition" : "Podrobný popis důvodu a průběhu hospitalizace jako celku. Může být zakončeno klinickou úvahou (dif. dg., vysvětlení souvislostí) v klinicky složitých případech.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.klinickeShrnuti.souhrnProblemu",
        "path" : "LogHospitalStayCz.klinickeShrnuti.souhrnProblemu",
        "short" : "A.2.7.7.1 Klinický souhrn problému",
        "definition" : "Souhrnný popis důvodu a průběhu hospitalizace za konkrétní problém.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.klinickeShrnuti.souhrnProblemu.popisProblemu",
        "path" : "LogHospitalStayCz.klinickeShrnuti.souhrnProblemu.popisProblemu",
        "short" : "A.2.7.7.1.1 Popis problému",
        "definition" : "Popis problému textem.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.klinickeShrnuti.souhrnProblemu.duvod",
        "path" : "LogHospitalStayCz.klinickeShrnuti.souhrnProblemu.duvod",
        "short" : "A.2.7.7.1.2 Důvod a průběh hospitalizace",
        "definition" : "Podrobný popis důvodu a průběhu hospitalizace za celý pobyt.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHospitalStayCz.klinickeShrnuti.klinickaUvaha",
        "path" : "LogHospitalStayCz.klinickeShrnuti.klinickaUvaha",
        "short" : "A.2.7.7.2 Klinická úvaha",
        "definition" : "Zakončení klinického shrnutí klinickou úvahou (diferenciální diagnostika, vysvětlení složitých stavů apod.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
