# A.1 – Hlavička dokumentu - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 – Hlavička dokumentu**

## Logical Model: A.1 – Hlavička dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogHeaderHdrCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzHeaderCz |

 
Nemocniční propouštěcí zpráva - Struktura hlavičky propouštěcí zprávy podle tabulky části. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogHeaderHdrCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogHeaderHdrCz.csv), [Excel](StructureDefinition-LogHeaderHdrCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogHeaderHdrCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHeaderHdrCz",
  "version" : "0.1.0",
  "name" : "LogCzHeaderCz",
  "title" : "A.1 – Hlavička dokumentu",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Struktura hlavičky propouštěcí zprávy podle tabulky části. ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogHeaderHdrCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogHeaderHdrCz",
        "path" : "LogHeaderHdrCz",
        "short" : "A.1 – Hlavička dokumentu",
        "definition" : "Nemocniční propouštěcí zpráva - Struktura hlavičky propouštěcí zprávy podle tabulky části. "
      },
      {
        "id" : "LogHeaderHdrCz.pacient",
        "path" : "LogHeaderHdrCz.pacient",
        "short" : "A.1.1 Identifikace pacienta",
        "definition" : "Identifikace pacienta – křestní jméno, příjmení, datum narození, identifikátory, státní občanství, úřední pohlaví, komunikační jazyk.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pacient.jmeno",
        "path" : "LogHeaderHdrCz.pacient.jmeno",
        "short" : "A.1.1.1 Křestní jméno",
        "definition" : "Křestní jméno pacienta.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pacient.prijmeni",
        "path" : "LogHeaderHdrCz.pacient.prijmeni",
        "short" : "A.1.1.2 Příjmení",
        "definition" : "Příjmení pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pacient.datumNarozeni",
        "path" : "LogHeaderHdrCz.pacient.datumNarozeni",
        "short" : "A.1.1.3 Datum narození",
        "definition" : "Datum, případně i čas narození pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pacient.idPacienta",
        "path" : "LogHeaderHdrCz.pacient.idPacienta",
        "short" : "A.1.1.4 Identifikátor pacienta",
        "definition" : "Unikátní identifikátor osoby – RID, DRID, číslo pasu atd.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pacient.narodnost",
        "path" : "LogHeaderHdrCz.pacient.narodnost",
        "short" : "A.1.1.5 Státní občanství",
        "definition" : "Státní občanství podle zákona 186/2013 Sb.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pacient.pohlavi",
        "path" : "LogHeaderHdrCz.pacient.pohlavi",
        "short" : "A.1.1.6 Úřední pohlaví",
        "definition" : "Administrativní pohlaví podle dokladů.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pacient.jazyk",
        "path" : "LogHeaderHdrCz.pacient.jazyk",
        "short" : "A.1.1.7 Komunikační jazyk",
        "definition" : "Jazyk nebo jazyky, jimiž pacient komunikuje.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt",
        "path" : "LogHeaderHdrCz.kontakt",
        "short" : "A.1.2 Kontaktní informace pacienta",
        "definition" : "Kontaktní údaje pacienta, včetně adresy, kontaktů a preferovaného lékaře.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.adresa",
        "path" : "LogHeaderHdrCz.kontakt.adresa",
        "short" : "A.1.2.1 Adresa",
        "definition" : "Poštovní adresa (řádky adresy, město, PSČ, země).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.telefon",
        "path" : "LogHeaderHdrCz.kontakt.telefon",
        "short" : "A.1.2.2 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.preferovanyLekar",
        "path" : "LogHeaderHdrCz.kontakt.preferovanyLekar",
        "short" : "A.1.2.3 Preferovaný lékař",
        "definition" : "Identifikace preferovaného lékaře, u kterého je pacient evidován.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.preferovanyLekar.idLekare",
        "path" : "LogHeaderHdrCz.kontakt.preferovanyLekar.idLekare",
        "short" : "A.1.2.3.1 Identifikátor lékaře",
        "definition" : "Identifikační číslo lékaře dle NR-ZP.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.preferovanyLekar.jmenoLekare",
        "path" : "LogHeaderHdrCz.kontakt.preferovanyLekar.jmenoLekare",
        "short" : "A.1.2.3.2 Jméno lékaře",
        "definition" : "Plné jméno lékaře.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.preferovanyLekar.specializace",
        "path" : "LogHeaderHdrCz.kontakt.preferovanyLekar.specializace",
        "short" : "A.1.2.3.3 Specializace",
        "definition" : "Specializace lékaře podle číselníku NR-ZP.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.preferovanyLekar.idPoskytovatele",
        "path" : "LogHeaderHdrCz.kontakt.preferovanyLekar.idPoskytovatele",
        "short" : "A.1.2.3.4 ID a název poskytovatele",
        "definition" : "Identifikátor a název poskytovatele, kterého lékař reprezentuje.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "path" : "LogHeaderHdrCz.kontakt.preferovanyLekar.adresaPoskytovatele",
        "short" : "A.1.2.3.5 Adresa poskytovatele",
        "definition" : "Poštovní adresa poskytovatele zdravotní péče.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "path" : "LogHeaderHdrCz.kontakt.preferovanyLekar.kontaktPoskytovatele",
        "short" : "A.1.2.3.6 Telekomunikační kontakt",
        "definition" : "Telefon nebo e-mail poskytovatele.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba",
        "short" : "A.1.2.4 Zákonný zástupce a kontaktní osoba",
        "definition" : "Kontaktní osoba – např. zákonný zástupce nebo jiná blízká osoba.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.typ",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.typ",
        "short" : "A.1.2.4.1 Typ kontaktu",
        "definition" : "Typ kontaktní osoby – zákonný zástupce, emergentní kontakt apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.vztah",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.vztah",
        "short" : "A.1.2.4.2 Vztah k pacientovi",
        "definition" : "Rodinný nebo jiný vztah ke kontaktované osobě.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.idOsoby",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.idOsoby",
        "short" : "A.1.2.4.3 Id osoby",
        "definition" : "Unikátní identifikátor kontaktní osoby.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.jmeno",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.jmeno",
        "short" : "A.1.2.4.4 Křestní jméno",
        "definition" : "Křestní jméno kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.prijmeni",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.prijmeni",
        "short" : "A.1.2.4.5 Příjmení",
        "definition" : "Příjmení kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.adresa",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.adresa",
        "short" : "A.1.2.4.6 Adresa kontaktní osoby",
        "definition" : "Adresa kontaktní osoby.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.kontakt",
        "path" : "LogHeaderHdrCz.kontakt.kontaktniOsoba.kontakt",
        "short" : "A.1.2.4.7 Telekomunikační kontakt",
        "definition" : "Telefon, e-mail apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pojistovna",
        "path" : "LogHeaderHdrCz.pojistovna",
        "short" : "A.1.3 Zdravotní pojištění",
        "definition" : "Informace o pojištění pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pojistovna.kodPojistovny",
        "path" : "LogHeaderHdrCz.pojistovna.kodPojistovny",
        "short" : "A.1.3.1 Kód zdravotní pojišťovny",
        "definition" : "Kód zdravotní pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pojistovna.nazev",
        "path" : "LogHeaderHdrCz.pojistovna.nazev",
        "short" : "A.1.3.2 Název zdravotní pojišťovny",
        "definition" : "Oficiální název pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.pojistovna.cisloPojistence",
        "path" : "LogHeaderHdrCz.pojistovna.cisloPojistence",
        "short" : "A.1.3.3 Číslo zdravotního pojištění",
        "definition" : "Číslo pojištěnce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.prijemce",
        "path" : "LogHeaderHdrCz.prijemce",
        "short" : "A.1.4 Příjemce dokumentu",
        "definition" : "Zamýšlený příjemce propouštěcí zprávy.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.prijemce.idPrijemce",
        "path" : "LogHeaderHdrCz.prijemce.idPrijemce",
        "short" : "A.1.4.1 ID příjemce",
        "definition" : "Identifikační číslo zdravotnického pracovníka nebo osobní identifikátor pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.prijemce.jmeno",
        "path" : "LogHeaderHdrCz.prijemce.jmeno",
        "short" : "A.1.4.2 Jméno příjemce",
        "definition" : "Jméno a příjmení osoby příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.prijemce.idOrganizace",
        "path" : "LogHeaderHdrCz.prijemce.idOrganizace",
        "short" : "A.1.4.3 ID organizace příjemce",
        "definition" : "Identifikátor organizace příjemce (např. NRPZS, IČO).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.prijemce.organizace",
        "path" : "LogHeaderHdrCz.prijemce.organizace",
        "short" : "A.1.4.4 Organizace příjemce",
        "definition" : "Název a identifikační údaje zařízení nebo pracoviště příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.autor",
        "path" : "LogHeaderHdrCz.autor",
        "short" : "A.1.5 Autor dokumentu",
        "definition" : "Osoba nebo systém, který dokument vytvořil.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.autor.idAutor",
        "path" : "LogHeaderHdrCz.autor.idAutor",
        "short" : "A.1.5.1 Identifikátor autora",
        "definition" : "Identifikační číslo autora (zdravotnický pracovník nebo IS).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.autor.jmeno",
        "path" : "LogHeaderHdrCz.autor.jmeno",
        "short" : "A.1.5.2 Jméno autora",
        "definition" : "Jméno osoby nebo systému, který dokument sestavil.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.autor.idOrganizace",
        "path" : "LogHeaderHdrCz.autor.idOrganizace",
        "short" : "A.1.5.3 ID organizace",
        "definition" : "Identifikátor organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.autor.organizace",
        "path" : "LogHeaderHdrCz.autor.organizace",
        "short" : "A.1.5.4 Organizace autora",
        "definition" : "Název organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.autor.datum",
        "path" : "LogHeaderHdrCz.autor.datum",
        "short" : "A.1.5.5 Datum a čas uložení",
        "definition" : "Datum a čas poslední modifikace dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.overil",
        "path" : "LogHeaderHdrCz.overil",
        "short" : "A.1.6 Ověřil",
        "definition" : "Zdravotnický pracovník, který dokument ověřil.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.overil.idOveril",
        "path" : "LogHeaderHdrCz.overil.idOveril",
        "short" : "A.1.6.1 Identifikátor ověřovatele",
        "definition" : "Identifikační číslo ověřovatele dokumentu.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.overil.jmeno",
        "path" : "LogHeaderHdrCz.overil.jmeno",
        "short" : "A.1.6.2 Jméno ověřovatele",
        "definition" : "Plné jméno ověřující osoby.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.overil.idOrganizace",
        "path" : "LogHeaderHdrCz.overil.idOrganizace",
        "short" : "A.1.6.3 ID organizace",
        "definition" : "Identifikátor organizace ověřovatele.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.overil.organizace",
        "path" : "LogHeaderHdrCz.overil.organizace",
        "short" : "A.1.6.4 Organizace ověřovatele",
        "definition" : "Název organizace, kterou ověřovatel reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.overil.datum",
        "path" : "LogHeaderHdrCz.overil.datum",
        "short" : "A.1.6.5 Datum a čas ověření",
        "definition" : "Datum a čas ověření dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.zodpovida",
        "path" : "LogHeaderHdrCz.zodpovida",
        "short" : "A.1.7 Zodpovídá",
        "definition" : "Zdravotnický pracovník zodpovědný za obsah dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.zodpovida.idZodpovida",
        "path" : "LogHeaderHdrCz.zodpovida.idZodpovida",
        "short" : "A.1.7.1 Zodpovídá - ID",
        "definition" : "Identifikátor osoby zodpovědné za dokument.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.zodpovida.jmeno",
        "path" : "LogHeaderHdrCz.zodpovida.jmeno",
        "short" : "A.1.7.2 Zodpovídá - jméno osoby",
        "definition" : "Plné jméno osoby zodpovědné za dokument.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.zodpovida.organizace",
        "path" : "LogHeaderHdrCz.zodpovida.organizace",
        "short" : "A.1.7.3 Zodpovídá - organizace",
        "definition" : "Organizace reprezentovaná odpovědnou osobou.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.zodpovida.datum",
        "path" : "LogHeaderHdrCz.zodpovida.datum",
        "short" : "A.1.7.4 Datum a čas autorizace",
        "definition" : "Datum a čas autorizace dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata",
        "path" : "LogHeaderHdrCz.metadata",
        "short" : "A.1.8 Metadata dokumentu",
        "definition" : "Technická metadata dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.dokumentId",
        "path" : "LogHeaderHdrCz.metadata.dokumentId",
        "short" : "A.1.8.1 ID dokumentu",
        "definition" : "Jedinečný identifikátor dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.kategorie",
        "path" : "LogHeaderHdrCz.metadata.kategorie",
        "short" : "A.1.8.2 Kategorie dokumentu",
        "definition" : "Kategorie EHR (např. propouštěcí zpráva).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.stav",
        "path" : "LogHeaderHdrCz.metadata.stav",
        "short" : "A.1.8.3 Stav dokumentu",
        "definition" : "Stav dokumentu – předběžný, finální apod.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.vytvoreni",
        "path" : "LogHeaderHdrCz.metadata.vytvoreni",
        "short" : "A.1.8.4 Datum a čas vytvoření",
        "definition" : "Datum a čas vytvoření dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.nazevDokumentu",
        "path" : "LogHeaderHdrCz.metadata.nazevDokumentu",
        "short" : "A.1.8.5 Název dokumentu",
        "definition" : "Název dokumentu, např. „Propouštěcí zpráva“.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.spravce",
        "path" : "LogHeaderHdrCz.metadata.spravce",
        "short" : "A.1.8.6 Správce dokumentu",
        "definition" : "Technický správce dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.duveryhodnost",
        "path" : "LogHeaderHdrCz.metadata.duveryhodnost",
        "short" : "A.1.8.7 Důvěrnost dokumentu",
        "definition" : "Stupeň důvěrnosti dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.jazyk",
        "path" : "LogHeaderHdrCz.metadata.jazyk",
        "short" : "A.1.8.8 Jazyk dokumentu",
        "definition" : "Jazyk dokumentu dle ISO kódu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.metadata.verze",
        "path" : "LogHeaderHdrCz.metadata.verze",
        "short" : "A.1.8.9 Verze",
        "definition" : "Verze dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.podpis",
        "path" : "LogHeaderHdrCz.podpis",
        "short" : "A.1.9 Elektronické podpisy",
        "definition" : "Elektronické podepsání dokumentu dle zákona.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.podpis.elektronickyPodpis",
        "path" : "LogHeaderHdrCz.podpis.elektronickyPodpis",
        "short" : "A.1.9.1 Elektronický podpis",
        "definition" : "Elektronický podpis nebo pečeť dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderHdrCz.podpis.casoveRazitko",
        "path" : "LogHeaderHdrCz.podpis.casoveRazitko",
        "short" : "A.1.9.2 Časové razítko",
        "definition" : "Elektronické časové razítko.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
