# A.4 - Přílohy (cz) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.4 - Přílohy (cz)**

## Logical Model: A.4 - Přílohy (cz) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogAttachmentsCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzAttachmentsCz |

 
Nemocniční propouštěcí zpráva - Přílohy 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogAttachmentsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogAttachmentsCz.csv), [Excel](StructureDefinition-LogAttachmentsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogAttachmentsCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAttachmentsCz",
  "version" : "0.1.0",
  "name" : "LogCzAttachmentsCz",
  "title" : "A.4 - Přílohy (cz)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Přílohy",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogAttachmentsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogAttachmentsCz",
        "path" : "LogAttachmentsCz",
        "short" : "A.4 - Přílohy (cz)",
        "definition" : "Nemocniční propouštěcí zpráva - Přílohy"
      },
      {
        "id" : "LogAttachmentsCz.typObsahu",
        "path" : "LogAttachmentsCz.typObsahu",
        "short" : "A.4.1 Typ obsahu",
        "definition" : "Typ obsahu - je  požadován MIME typ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogAttachmentsCz.jazyk",
        "path" : "LogAttachmentsCz.jazyk",
        "short" : "A.4.2 Jazyk obsahu",
        "definition" : "Jazyk obsahu - je požadována hodnata z HL7 valueset Languages",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogAttachmentsCz.data",
        "path" : "LogAttachmentsCz.data",
        "short" : "A.4.3 Data obsahu",
        "definition" : "Data v base64",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "LogAttachmentsCz.url",
        "path" : "LogAttachmentsCz.url",
        "short" : "A.4.4 URL obsahu",
        "definition" : "Uri kde lze data nalézt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "LogAttachmentsCz.nazev",
        "path" : "LogAttachmentsCz.nazev",
        "short" : "A.4.5 Název obsahu",
        "definition" : "Titulek, který bude zobrazen před daty",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogAttachmentsCz.vytvoreni",
        "path" : "LogAttachmentsCz.vytvoreni",
        "short" : "A.4.6 Datum vytvoření",
        "definition" : "Datum, kdy byl obsah poprvé vytvořen",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
