# A - Hospital Discharge Report (eHN) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Hospital Discharge Report (eHN)**

## Logical Model: A - Hospital Discharge Report (eHN) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/HospitalDischargeReportCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnHospitalDischargeReportEhnCz |

 
Hospital Discharge Report 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/HospitalDischargeReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HospitalDischargeReportCz.csv), [Excel](StructureDefinition-HospitalDischargeReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HospitalDischargeReportCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/HospitalDischargeReportCz",
  "version" : "0.1.0",
  "name" : "LogEnHospitalDischargeReportEhnCz",
  "title" : "A - Hospital Discharge Report (eHN)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/HospitalDischargeReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HospitalDischargeReportCz",
        "path" : "HospitalDischargeReportCz",
        "short" : "A - Hospital Discharge Report (eHN)",
        "definition" : "Hospital Discharge Report"
      },
      {
        "id" : "HospitalDischargeReportCz.header",
        "path" : "HospitalDischargeReportCz.header",
        "short" : "A.1 - Hospital Discharge Report header data element",
        "definition" : "Hospital Discharge Report header data element",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/Header"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body",
        "path" : "HospitalDischargeReportCz.body",
        "short" : "A.2 - Hospital Discharge Report body data element",
        "definition" : "Hospital Discharge Report body data element",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.advanceDirectives",
        "path" : "HospitalDischargeReportCz.body.advanceDirectives",
        "short" : "A.2.1 - Advance directives",
        "definition" : "Advance directives",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/AdvanceDirectives"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.alerts",
        "path" : "HospitalDischargeReportCz.body.alerts",
        "short" : "A.2.2 - Alerts",
        "definition" : "Alerts",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/Alerts"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.encounter",
        "path" : "HospitalDischargeReportCz.body.encounter",
        "short" : "A.2.3 - Encounter",
        "definition" : "Encounter ",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/InPatientEncounter"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.admissionEvaluation",
        "path" : "HospitalDischargeReportCz.body.admissionEvaluation",
        "short" : "A.2.4 - Admission evaluation",
        "definition" : "Admission evaluation - Admission status should be reported exceptionally only if it is relevant to ensure continuity of care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/AdmissionEvaluation"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.patientHistory",
        "path" : "HospitalDischargeReportCz.body.patientHistory",
        "short" : "A.2.5 - Patient history",
        "definition" : "Patient history (might include information about provenance of the information)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/PatientHistory"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.hospitalStay",
        "path" : "HospitalDischargeReportCz.body.hospitalStay",
        "short" : "A.2.6 - Course of hospitalisation (Hospital stay)",
        "definition" : "Course of hospitalisation (Hospital stay)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/HospitalStay"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.dischargeDetails",
        "path" : "HospitalDischargeReportCz.body.dischargeDetails",
        "short" : "A.2.7 - Discharge details",
        "definition" : "Discharge details (structured information should be provided, however if not available, at least a summary note should be present).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.dischargeDetails.objectiveFindings",
        "path" : "HospitalDischargeReportCz.body.dischargeDetails.objectiveFindings",
        "short" : "A.2.7.1 - Objective findings",
        "definition" : "Objective findings",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/ObjectiveFindings"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.dischargeDetails.functionalStatus",
        "path" : "HospitalDischargeReportCz.body.dischargeDetails.functionalStatus",
        "short" : "A.2.7.2 - Functional status",
        "definition" : "Functional status can be assessed in several different ways, usually with a focus on the persona's abilities to perform basic activities of daily living (ADL), which include basic self-care such as bathing, feeding, and toileting and instrumental activities of daily living (IADL), which includes activities such as cooking, shopping, and managing one's own affairs.\nFor details see: https://paciowg.github.io/functional-status-ig/",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/FunctionalStatus"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.dischargeDetails.dischargeNote",
        "path" : "HospitalDischargeReportCz.body.dischargeDetails.dischargeNote",
        "short" : "A.2.7.3 - Discharge note",
        "definition" : "Discharge summary note",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.recommendations",
        "path" : "HospitalDischargeReportCz.body.recommendations",
        "short" : "A.2.8 - Care plan and other recommendations after discharge.",
        "definition" : "Care plan and other recommendations after discharge.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.recommendations.carePlan",
        "path" : "HospitalDischargeReportCz.body.recommendations.carePlan",
        "short" : "A.2.8.1 - Care plan",
        "definition" : "Care plan after discharge. Multiple care plans could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/PlanOfCare"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.body.recommendations.medicationSummary",
        "path" : "HospitalDischargeReportCz.body.recommendations.medicationSummary",
        "short" : "A.2.8.2 - Medication summary",
        "definition" : "Summary information on the medication recommended for the period after discharge, indicating whether the medication is changed or newly started. Compared to previous practices, the overview is supplemented with medication that has been discontinued.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "http://hl7.eu/fhir/hdr/StructureDefinition/MedicationSummary"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.presentedForm",
        "path" : "HospitalDischargeReportCz.presentedForm",
        "short" : "A.3 - Presented Form",
        "definition" : "Entire order as issued. Various formats could be provided,  pdf format is recommended.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/PresentedFormCz"
          }
        ]
      },
      {
        "id" : "HospitalDischargeReportCz.media",
        "path" : "HospitalDischargeReportCz.media",
        "short" : "A.4 - Media Attachment",
        "definition" : "Aditional media attachment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/hdr/StructureDefinition/AttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
