# Practitioner Role for L1 documentr - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Practitioner Role for L1 documentr**

## Example PractitionerRole: Practitioner Role for L1 documentr

Profile: [Practitioner Role (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitionerrole-core.html)

**practitioner**: [Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-core.md#urn-uuid-e234a53a-4e0d-4fb8-9403-e0e324a50f64)

**organization**: [Organization CHIR-L2 - Lůžková stanice 2](Bundle-DischargeBundle-Novak-Petr-L1-core.md#urn-uuid-a4641bd0-34af-4038-a7db-872d08a54df9)

**specialty**: Physician



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "69d34ceb-b556-4f75-9e4c-9184fe8a10c5",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
    ]
  },
  "practitioner" : {
    "reference" : "urn:uuid:e234a53a-4e0d-4fb8-9403-e0e324a50f64"
  },
  "organization" : {
    "reference" : "urn:uuid:a4641bd0-34af-4038-a7db-872d08a54df9"
  },
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "309343006",
          "display" : "Physician"
        }
      ]
    }
  ]
}

```
