# Practitioner-L1 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Practitioner-L1**

## Example Practitioner: Practitioner-L1

Profile: [Practitioner (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-practitioner-core.html)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/krzp`/987645454

**name**: Šárka Kašková 

**telecom**: [+420604853784](tel:+420604853784)

**address**: Dlouhá 22 Pardubice 53701 Česká republika (work)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "Practitioner-L1",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/krzp",
      "value" : "987645454"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Kašková",
      "given" : ["Šárka"],
      "prefix" : ["MUDr."],
      "suffix" : ["PhD"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420604853784",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "line" : ["Dlouhá 22"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Dlouhá"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "22"
            }
          ]
        }
      ],
      "city" : "Pardubice",
      "postalCode" : "53701",
      "country" : "Česká republika",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ]
}

```
