# Organization-L1-Odd - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Organization-L1-Odd**

## Example Organization: Organization-L1-Odd

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/icp`/12345678

**name**: CHIR - Oddělení chirurgie

**telecom**: [+42060385555](tel:+42060385555)

**address**: Václavská 570 Chrudim 53701 Česká republika (work)

**partOf**: [Nemocnice Pardubického kraje, a.s., Chrudimská nemocnice](Bundle-DischargeBundle-Novak-Petr-L1-core.md#urn-uuid-9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "af2b3114-e872-43b9-9875-cceb39122f7f",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/icp",
      "value" : "12345678"
    }
  ],
  "name" : "CHIR - Oddělení chirurgie",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+42060385555"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "line" : ["Václavská 570"],
      "city" : "Chrudim",
      "postalCode" : "53701",
      "country" : "Česká republika",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "partOf" : {
    "reference" : "urn:uuid:9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1",
    "display" : "Nemocnice Pardubického kraje, a.s., Chrudimská nemocnice"
  }
}

```
