# CZObservationSdohHdrExample - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZObservationSdohHdrExample**

## Example Observation: CZObservationSdohHdrExample

Profile: [Observation: SDOH (HDR CZ)](StructureDefinition-cz-observation-sdoh-hdr.md)

**status**: Final

**category**: Social History

**code**: Food insecurity risk [HVS]

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

**effective**: 2024-03-28

**performer**: [Practitioner Šárka Kašková](Practitioner-Practitioner-2.md)

**value**: Food insecurity

**note**: 

> 

Patient reported difficulties accessing nutritious food regularly.




## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "CZObservationSdohHdrExample",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "88124-3",
        "display" : "Food insecurity risk [HVS]"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Mracena2"
  },
  "effectiveDateTime" : "2024-03-28",
  "performer" : [
    {
      "reference" : "Practitioner/Practitioner-2"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "733423003",
        "display" : "Food insecurity"
      }
    ]
  },
  "note" : [
    {
      "text" : "Patient reported difficulties accessing nutritious food regularly."
    }
  ]
}

```
