# CRP - Novák Petr - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CRP - Novák Petr**

## Example Observation: CRP - Novák Petr

Profile: [Observation Laboratory (CZ)](https://build.fhir.org/ig/HL7-cz/cz-lab/StructureDefinition-cz-observation-result-laboratory.html)

**status**: Final

**category**: Laboratory, Laboratory studies (set)

**code**: Protein C - kontrola (P; rel. čas [1] *)

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2025-03-01 10:00:00+0100

**performer**: `urn:uuid:860c684f-aba1-40d9-94cf-721d70237b52`

**value**: 6 mg/L(Details: UCUM codemg/L = 'mg/L')

**interpretation**: Normal

### ReferenceRanges

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Low** | **High** | **Text** |
| * | 0 mg/L(Details: UCUM codemg/L = 'mg/L') | 10 mg/L(Details: UCUM codemg/L = 'mg/L') | Norma: 0–10 mg/L |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "10f5c49e-086d-4016-8dd1-10000000001b",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/lab/StructureDefinition/cz-observation-result-laboratory"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "26436-6",
          "display" : "Laboratory studies (set)"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/NCLPPOL",
        "code" : "07830",
        "display" : "Protein C - kontrola (P; rel. čas [1] *)"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectiveDateTime" : "2025-03-01T10:00:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:860c684f-aba1-40d9-94cf-721d70237b52"
    }
  ],
  "valueQuantity" : {
    "value" : 6,
    "unit" : "mg/L",
    "system" : "http://unitsofmeasure.org",
    "code" : "mg/L"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ],
  "referenceRange" : [
    {
      "low" : {
        "value" : 0,
        "unit" : "mg/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mg/L"
      },
      "high" : {
        "value" : 10,
        "unit" : "mg/L",
        "system" : "http://unitsofmeasure.org",
        "code" : "mg/L"
      },
      "text" : "Norma: 0–10 mg/L"
    }
  ]
}

```
