# CZ-MedicationStatement-HDR Example of Paracetamol - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-MedicationStatement-HDR Example of Paracetamol**

## Example MedicationStatement: CZ-MedicationStatement-HDR Example of Paracetamol

Profile: [Medication Statement (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)

**identifier**: `https://hl7.cz/fhir/core/ValueSet/cz-dlplecivepripravky-vs`/0243131

**status**: active

**statusReason**: Pokračuje

**category**: Inpatient

**medication**: [Medication PARACETAMOL ZENTIVA K.S.](Medication-med-paracetamol.md)

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**effective**: 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100

**reasonCode**: Hypotyreóza

> **dosage****text**: Dle potřeby, max 4 tablety denně**asNeeded**: true**route**:Oral use

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 500 mg |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "f34114fc-138f-4bd8-8e1a-804d14ec9986",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
    ]
  },
  "identifier" : [
    {
      "system" : "https://hl7.cz/fhir/core/ValueSet/cz-dlplecivepripravky-vs",
      "value" : "0243131"
    }
  ],
  "status" : "active",
  "statusReason" : [
    {
      "text" : "Pokračuje"
    }
  ],
  "category" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-admin-location",
        "code" : "inpatient",
        "display" : "Inpatient"
      }
    ],
    "text" : "Inpatient"
  },
  "medicationReference" : {
    "reference" : "Medication/med-paracetamol"
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "effectivePeriod" : {
    "start" : "2025-03-01T10:15:00+01:00",
    "end" : "2025-03-10T09:30:00+01:00"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/sid/icd-10",
          "code" : "E03.9",
          "display" : "Hypothyroidism, unspecified"
        }
      ],
      "text" : "Hypotyreóza"
    }
  ],
  "dosage" : [
    {
      "text" : "Dle potřeby, max 4 tablety denně",
      "asNeededBoolean" : true,
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral use"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 500,
            "unit" : "mg"
          }
        }
      ]
    }
  ]
}

```
