# Medication – Covid vaccine - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Medication – Covid vaccine**

## Example Medication: Medication – Covid vaccine

Profile: [Medication (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-Medication.html)

**identifier**: `https://hl7.cz/fhir/core/ValueSet/cz-dlplecivepripravky-vs`/0246599

**code**: Comirnaty

**status**: Active

**form**: Injekční roztok

**amount**: 0.3 ml(Details: UCUM code/ml = '/ml')/0.3 ml

### Ingredients

| | | |
| :--- | :--- | :--- |
| - | **Item[x]** | **Strength** |
| * | SARS-COV-2 (OMICRON JN.1) SPIKE PROTEIN | 30 mikrogramů(Details: UCUM codeug = 'ug')/0.3 ml(Details: UCUM code/ml = '/ml') |



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "med-CovidVaccineComirnaty",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
  },
  "identifier" : [
    {
      "system" : "https://hl7.cz/fhir/core/ValueSet/cz-dlplecivepripravky-vs",
      "value" : "0246599"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivepripravky-cs",
        "code" : "0271911",
        "display" : "COMIRNATY OMICRON XBB.1.5"
      },
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpatc-cs",
        "code" : "J07BN01",
        "display" : "COVID-19, RNA VAKCÍNA"
      }
    ],
    "text" : "Comirnaty"
  },
  "status" : "active",
  "form" : {
    "coding" : [
      {
        "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlpformy-cs",
        "code" : "INJSOL",
        "display" : "Injekční roztok"
      }
    ],
    "text" : "Injekční roztok"
  },
  "amount" : {
    "numerator" : {
      "value" : 0.3,
      "unit" : "ml",
      "system" : "http://unitsofmeasure.org",
      "code" : "/ml"
    },
    "denominator" : {
      "value" : 0.3,
      "unit" : "ml"
    }
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://hl7.cz/fhir/core/CodeSystem/cz-dlplecivelatky-cs",
            "code" : "23463",
            "display" : "SARS-COV-2 (OMICRON JN.1) SPIKE PROTEIN"
          }
        ],
        "text" : "SARS-COV-2 (OMICRON JN.1) SPIKE PROTEIN"
      },
      "strength" : {
        "numerator" : {
          "value" : 30,
          "unit" : "mikrogramů",
          "system" : "http://unitsofmeasure.org",
          "code" : "ug"
        },
        "denominator" : {
          "value" : 0.3,
          "unit" : "ml",
          "system" : "http://unitsofmeasure.org",
          "code" : "/ml"
        }
      }
    }
  ]
}

```
