# Immunization example of Covid - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Immunization example of Covid**

## Example Immunization: Immunization example of Covid

Profiles: [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md), [Immunization (HDR)](http://hl7.eu/fhir/hdr/0.1.0-ballot/StructureDefinition-immunization-eu-hdr.html)

**status**: Completed

**vaccineCode**: COVID-19 vaccine

**patient**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**occurrence**: 2021-05-05

**primarySource**: true



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "3f85726c-ad2f-441b-89ce-10000000001e",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr",
      "http://hl7.eu/fhir/hdr/StructureDefinition/immunization-eu-hdr"
    ]
  },
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "28531000087107"
      }
    ]
  },
  "patient" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "occurrenceDateTime" : "2021-05-05",
  "primarySource" : true
}

```
