# CZ-Encounter-HDR L1 Example of encounter for Novak Petr - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Encounter-HDR L1 Example of encounter for Novak Petr**

## Example Encounter: CZ-Encounter-HDR L1 Example of encounter for Novak Petr

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**status**: finished

**class**: [ActCode: IMP](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**subject**: [Ing. Petr Novák, Ph.D. Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-core.md#urn-uuid-48a9d440-4194-42c1-87ad-b5a39020a4d0)

**period**: 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100

**serviceProvider**: [Organization CHIR-L2 - Lůžková stanice 2](Bundle-DischargeBundle-Novak-Petr-L1-core.md#urn-uuid-a4641bd0-34af-4038-a7db-872d08a54df9)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "subject" : {
    "reference" : "urn:uuid:48a9d440-4194-42c1-87ad-b5a39020a4d0"
  },
  "period" : {
    "start" : "2025-03-01T10:15:00+01:00",
    "end" : "2025-03-10T09:30:00+01:00"
  },
  "serviceProvider" : {
    "reference" : "urn:uuid:a4641bd0-34af-4038-a7db-872d08a54df9"
  }
}

```
