# CZ-Encounter-HDR Example of finished hospital encounter - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Encounter-HDR Example of finished hospital encounter**

## Example Encounter: CZ-Encounter-HDR Example of finished hospital encounter

Profile: [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)

**status**: finished

**class**: [ActCode: IMP](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

**period**: 2025-03-01 10:15:00+0100 --> 2025-03-10 09:30:00+0100

**serviceProvider**: [Organization MUDr. Jana Krásná](Organization-RegisteringProviderExample.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "HospitalEncounter",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-encounter-hdr"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "subject" : {
    "reference" : "Patient/Mracena2"
  },
  "period" : {
    "start" : "2025-03-01T10:15:00+01:00",
    "end" : "2025-03-10T09:30:00+01:00"
  },
  "serviceProvider" : {
    "reference" : "Organization/RegisteringProviderExample"
  }
}

```
