# Discharge Summary Document - Base64 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Discharge Summary Document - Base64**

## Example DocumentReference: Discharge Summary Document - Base64

**status**: Current

**type**: Discharge summary

**subject**: [Petr Novák Male, DoB: 1985-06-15 ( https://ncez.mzcr.cz/fhir/sid/rid#1597778923)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)

**date**: 2022-10-07 08:15:00+0200

**author**: [Practitioner MUDr. Ivan Anděl](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a)

**custodian**: [Organization Nemocnice Chrudim](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169)

> **content**

### Attachments

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **ContentType** | **Language** | **Data** | **Title** |
| * | text/html | Czech | (base64 data - 330,520 base64 chars) | Propouštěcí zpráva |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "d9ad8a22-a12b-48db-938c-4066a3a0617a",
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "18842-5",
        "display" : "Discharge summary"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "date" : "2022-10-07T08:15:00+02:00",
  "author" : [
    {
      "reference" : "urn:uuid:a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a"
    }
  ],
  "custodian" : {
    "reference" : "urn:uuid:ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169"
  },
  "content" : [
    {
      "attachment" : {
        "contentType" : "text/html",
        "language" : "cs",
        "data" : "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",
        "title" : "Propouštěcí zpráva"
      }
    }
  ]
}

```
