# Device-Pacemaker - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Device-Pacemaker**

## Example Device: Device-Pacemaker

Profile: [Medical Device (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)

**manufacturer**: Medtronic

**modelNumber**: W1DR01

**type**: Cardiac pacemaker

**patient**: [Pokusný pacient Mračena](Bundle-DischargeBundle-Novak-Petr-L1-plus.md#urn-uuid-3f85726c-ad2f-441b-89ce-100000000000)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "Device-Pacemaker",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
    ]
  },
  "manufacturer" : "Medtronic",
  "modelNumber" : "W1DR01",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "14106009",
        "display" : "Cardiac pacemaker"
      }
    ]
  },
  "patient" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000",
    "display" : "Pokusný pacient Mračena"
  }
}

```
