# CZ-Condition-HDR Example K409 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-Condition-HDR Example K409**

## Example Condition: CZ-Condition-HDR Example K409

Pacient byl přijat s diagnózou tříselné kýly bez obstrukce a gangrény. Doporučena elektivní operace.



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "35717696-8a99-4f99-a938-ec0ec88a65a2",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
    ]
  },
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "278307001",
          "display" : "On admission"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "69845001",
          "display" : "Received therapy or drug for"
        }
      ]
    }
  ],
  "severity" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "24484000",
        "display" : "Severe"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10",
        "code" : "K40.9",
        "display" : "Unilateral or unspecified inguinal hernia, without obstruction or gangrene"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:3f85726c-ad2f-441b-89ce-100000000000"
  },
  "onsetDateTime" : "2023-10-01T10:00:00Z",
  "stage" : [
    {
      "summary" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "255604002",
            "display" : "Mild"
          }
        ]
      }
    }
  ]
}

```
