# CZ Patient History to this guide Map - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Patient History to this guide Map**

## ConceptMap: CZ Patient History to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/ConceptMap/patientHistory2FHIR-cz-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:PatientHistory2FHIRCzHdr |

 
CZ HDR Patient History Model to this guide Map 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "patientHistory2FHIR-cz-hdr",
  "url" : "https://hl7.cz/fhir/hdr/ConceptMap/patientHistory2FHIR-cz-hdr",
  "version" : "0.1.0",
  "name" : "PatientHistory2FHIRCzHdr",
  "title" : "CZ Patient History to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ HDR Patient History Model to this guide Map",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.vaccination.nextVaccinationDate",
          "display" : "A.2.6.1.4.8 - Next vaccination date",
          "target" : [
            {
              "code" : "ImmunizationRecommendation.recommendation.dateCriterion[nextDose].value",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-composition-hdr",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory",
          "display" : "A.2.6.1 - Medical history",
          "target" : [
            {
              "code" : "Composition.section",
              "equivalence" : "relatedto",
              "comment" : "several sections"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions",
          "display" : "A.2.6.1.1 - History of problems",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionPastIllnessHx",
              "equivalence" : "relatedto",
              "comment" : "The same section used by the hospital stay ?"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.resolution",
          "display" : "A.2.6.1.1.6 - Resolution circumstances",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionPastIllnessHx.text",
              "equivalence" : "relatedto",
              "comment" : "The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices",
          "display" : "A.2.6.1.2 - Devices and Implants",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionHistoryMedicalDevices",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination",
          "display" : "A.2.6.1.4 - Vaccination",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionImmunizations",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory",
          "display" : "A.2.6.1.5 - Epidemiological history",
          "target" : [
            {
              "equivalence" : "unmatched",
              "comment" : "decison not to have as distict section"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts",
          "display" : "A.2.6.1.5.1 - Infectious contacts",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory",
          "display" : "A.2.6.1.5.2 - Travel history",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionTravelHx",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.period",
          "display" : "A.2.6.1.5.2.1 - Time period",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionTravelHx",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.country",
          "display" : "A.2.6.1.5.2.2 - Country visited",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionTravelHx",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.travelHistory.comment",
          "display" : "A.2.6.1.5.2.3 - Comment",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionTravelHx",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory",
          "display" : "A.2.6.2 - Family history",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionFamilyHistory",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants",
          "display" : "A.2.6.3 - Social determinants of health",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionSocialHistory",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances",
          "display" : "A.2.6.4 - Use of substances",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionSocialHistory",
              "equivalence" : "relatedto",
              "comment" : "To be specified"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.conditionSpecification",
          "display" : "A.2.6.1.1.1 - Problem description",
          "target" : [
            {
              "code" : "Condition.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.conditionDetails",
          "display" : "A.2.6.1.1.2 - Problem details",
          "target" : [
            {
              "code" : "Condition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.onsetDate",
          "display" : "A.2.6.1.1.3 - Onset date",
          "target" : [
            {
              "code" : "Condition.onSetDateTime",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.endDate",
          "display" : "A.2.6.1.1.4 - End date",
          "target" : [
            {
              "code" : "Condition.abatementDateTime",
              "equivalence" : "equal"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.clinicalStatus",
          "display" : "A.2.6.1.1.5 - Clinical status",
          "target" : [
            {
              "code" : "Composition.clinicalStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.resolution",
          "display" : "A.2.6.1.1.6 - Resolution circumstances",
          "target" : [
            {
              "code" : "Condition.text",
              "equivalence" : "relatedto",
              "comment" : "The resolution circumstances may be described as resource or composiiton.section text ; or indirectly determined by the resource (e.g. Procedure) that has been perfomed in reason of this Condition no more active"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.severity",
          "display" : "A.2.6.1.1.7 - Severity",
          "target" : [
            {
              "code" : "Composition.severity",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfConditions.stage",
          "display" : "A.2.6.1.1.8 - Stage",
          "target" : [
            {
              "code" : "Composition.stage",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.description",
          "display" : "A.2.6.1.2.1 - Device and implant description",
          "target" : [
            {
              "code" : "Device.text",
              "equivalence" : "relatedto",
              "comment" : "if referring to the description of the device"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.identifier",
          "display" : "A.2.6.1.2.2 - Device ID",
          "target" : [
            {
              "code" : "Device.identifier",
              "equivalence" : "relatedto",
              "comment" : "if generic identifier"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.identifier",
          "display" : "A.2.6.1.2.2 - Device ID",
          "target" : [
            {
              "code" : "Device.udiCarrier",
              "equivalence" : "relatedto",
              "comment" : "if it is the udiCarrier"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.description",
          "display" : "A.2.6.1.2.1 - Device and implant description",
          "target" : [
            {
              "code" : "DeviceUseStatement.text",
              "equivalence" : "relatedto",
              "comment" : "if referring to the description of the usage of the device"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.implantDate",
          "display" : "A.2.6.1.2.3 - Implant date",
          "target" : [
            {
              "code" : "DeviceUseStatement.timing[x]",
              "equivalence" : "relatedto",
              "comment" : "If the usage period is highlighted"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.endDate",
          "display" : "A.2.6.1.2.4 - End date",
          "target" : [
            {
              "code" : "DeviceUseStatement.timingPeriod.end",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.reason",
          "display" : "A.2.6.1.2.5 - Reason",
          "target" : [
            {
              "code" : "DeviceUseStatement.reasonCode",
              "equivalence" : "relatedto",
              "comment" : "if details about the body structure have to be provided"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.medicalDevices.reason",
          "display" : "A.2.6.1.2.5 - Reason",
          "target" : [
            {
              "code" : "DeviceUseStatement.reasonReference",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures",
          "display" : "A.2.6.1.3 - History of procedures",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionSignificantProcedures",
              "equivalence" : "relatedto",
              "comment" : "The same section usd by the hospital stay ?"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.vaccination.diseaseOrAgent",
          "display" : "A.2.6.1.4.1 - Disease or agent targeted",
          "target" : [
            {
              "code" : "Immunization.protocolApplied.targetDisease",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.vaccine",
          "display" : "A.2.6.1.4.2 - Vaccine/prophylaxis",
          "target" : [
            {
              "code" : "Immunization.vaccineCode",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.productName",
          "display" : "A.2.6.1.4.4 - Vaccine medicinal product",
          "target" : [
            {
              "code" : "Immunization.extension:administeredProduct",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.manufacturerOrMAH",
          "display" : "A.2.6.1.4.5 - Marketing Authorisation Holder",
          "target" : [
            {
              "code" : "Immunization.manufacturer",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.orderNumber",
          "display" : "A.2.6.1.4.6 - Number in a series of vaccinations / doses",
          "target" : [
            {
              "code" : "Immunization.protocolApplied.doseNumberPositiveInt",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.vaccination.vaccinationDate",
          "display" : "A.2.6.1.4.7 - Date of vaccination",
          "target" : [
            {
              "code" : "Immunization.occurenceDateTime",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-sdoh-hdr",
      "element" : [
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety",
          "display" : "A.2.6.3.1 - Participation in society",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety.workSituation",
          "display" : "A.2.6.3.1.1 - Work situation",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety.hobby",
          "display" : "A.2.6.3.1.2 - Hobby",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.participationInSociety.socailNetwork",
          "display" : "A.2.6.3.1.3 - Social network",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.education",
          "display" : "A.2.6.3.2 - Education",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.education.level",
          "display" : "A.2.6.3.2.1 - Education level",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.education.comment",
          "display" : "A.2.6.3.2.2 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation",
          "display" : "A.2.6.3.3 - Living situation",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation.houseType",
          "display" : "A.2.6.3.3.1 - House type",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation.homeAdaption",
          "display" : "A.2.6.3.3.2 - Home adaption",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.livingSituation.livingConditions",
          "display" : "A.2.6.3.3.3 - Living conditions",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation",
          "display" : "A.2.6.3.4 - Family situation",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.comment",
          "display" : "A.2.6.3.4.1 - Comment",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.familyComposition",
          "display" : "A.2.6.3.4.2 - Family composition",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.maritalStatus",
          "display" : "A.2.6.3.4.3 - Marital status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.numberOfChildren",
          "display" : "A.2.6.3.4.4 - Number of children",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.numberOfChildrenAtHome",
          "display" : "A.2.6.3.4.5 - Number of children at home",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.childDetails",
          "display" : "A.2.6.3.4.6 - Child details",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.socialDeterminants.familySituation.careResponsibility",
          "display" : "A.2.6.3.4.7 - Care responsibility",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-procedure-hdr",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.procedureCode",
          "display" : "A.2.6.1.3.1 - Procedure code",
          "target" : [
            {
              "code" : "Procedure.code",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.description",
          "display" : "A.2.6.1.3.2 - Procedure description",
          "target" : [
            {
              "code" : "Procedure.text",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.bodySite",
          "display" : "A.2.6.1.3.3 - Body site",
          "target" : [
            {
              "code" : "Procedure.bodySite",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.bodySite",
          "display" : "A.2.6.1.3.3 - Body site",
          "target" : [
            {
              "code" : "Procedure.extension:bodySite",
              "equivalence" : "relatedto",
              "comment" : "if details about the body structure have to be provided"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.date",
          "display" : "A.2.6.1.3.4 - Procedure date",
          "target" : [
            {
              "code" : "Procedure.perfomedDateTime",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.reason",
          "display" : "A.2.6.1.3.5 - Procedure reason",
          "target" : [
            {
              "code" : "Procedure.reasonCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.reason",
          "display" : "A.2.6.1.3.5 - Procedure reason",
          "target" : [
            {
              "code" : "Procedure.reasonReference",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.outcome",
          "display" : "A.2.6.1.3.6 - Outcome",
          "target" : [
            {
              "code" : "Procedure.outcome",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.historyOfProcedures.focalDevice",
          "display" : "A.2.6.1.3.7 - Focal device",
          "target" : [
            {
              "code" : "Procedure.focalDevice",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "element" : [
        {
          "code" : "PatientHistory.useOfSubstances.alcohol",
          "display" : "A.2.6.4.1 - Alcohol use",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.alcohol.currentStatus",
          "display" : "A.2.6.4.1.1 - Status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.alcohol.periodAndQuantity",
          "display" : "A.2.6.4.1.2 - Period and quantity",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.alcohol.comment",
          "display" : "A.2.6.4.1.3 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco",
          "display" : "A.2.6.4.2 - Tobacco use",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco.currentStatus",
          "display" : "A.2.6.4.2.1 - Status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco.periodAndQuantity",
          "display" : "A.2.6.4.2.2 - Period and quantity",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.tobacco.comment",
          "display" : "A.2.6.4.2.3 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption",
          "display" : "A.2.6.4.3 - Drug consumption",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.currentStatus",
          "display" : "A.2.6.4.3.1 - Status",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.periodAndQuantity",
          "display" : "A.2.6.4.3.2 - Period and quantity",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.drugType",
          "display" : "A.2.6.4.3.3 - Drug or medication type",
          "target" : [
            {
              "code" : "Observation",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.route",
          "display" : "A.2.6.4.3.4 - Route of administration",
          "target" : [
            {
              "code" : "Observation.value[x]",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        },
        {
          "code" : "PatientHistory.useOfSubstances.drugConsumption.comment",
          "display" : "A.2.6.4.3.5 - Comment",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "relatedto",
              "comment" : "category and code to be defined"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory",
      "element" : [
        {
          "code" : "PatientHistory.familyHistory.relationship",
          "display" : "A.2.6.2.1 - Patient relationship",
          "target" : [
            {
              "code" : "FamilyMemberHistory.relationship",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.birthDate",
          "display" : "A.2.6.2.2 - Date of birth",
          "target" : [
            {
              "code" : "FamilyMemberHistory.bornDate",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.deathDateOrAge",
          "display" : "A.2.6.2.3 - Age or date of death",
          "target" : [
            {
              "code" : "FamilyMemberHistory.deceased[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.conditions",
          "display" : "A.2.6.2.5 - Condition",
          "target" : [
            {
              "code" : "FamilyMemberHistory.condition.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.familyHistory.causeOfDeath",
          "display" : "A.2.6.2.6 - Cause of death",
          "target" : [
            {
              "code" : "FamilyMemberHistory.condition.code",
              "equivalence" : "equivalent",
              "comment" : "If FamilyMemberHistory.condition.contributedToDeath is true"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/hdr/StructureDefinition/PatientHistoryCz",
      "target" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-observation-infectious-contact-hdr",
      "element" : [
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.period",
          "display" : "A.2.6.1.5.1.1 - Time period",
          "target" : [
            {
              "code" : "Observation.effective[x]",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.infectiousAgent",
          "display" : "A.2.6.1.5.1.2 - Infectious agent",
          "target" : [
            {
              "code" : "Observation.valueCodeableConcept",
              "equivalence" : "equivalent",
              "comment" : "In the current value set the disease is indicated"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.proximity",
          "display" : "A.2.6.1.5.1.3 - Proximity",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts",
              "equivalence" : "relatedto",
              "comment" : "in this version as textual description"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.country",
          "display" : "A.2.6.1.5.1.4 - Country",
          "target" : [
            {
              "code" : "Composition.section:sectionPatientHx.section:sectionInfectiousContacts",
              "equivalence" : "relatedto",
              "comment" : "in this version as textual description"
            }
          ]
        },
        {
          "code" : "PatientHistory.medicalHistory.epidemiologicalHistory.infectiousContacts.note",
          "display" : "A.2.6.1.5.1.5 - Additional information",
          "target" : [
            {
              "code" : "Observation.note",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
