# CZ-CarePlan-HDR Example - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ-CarePlan-HDR Example**

## Example CarePlan: CZ-CarePlan-HDR Example

**status**: Active

**intent**: Plan

**title**: Post-Discharge Care Plan

**description**: Care plan for patient post-discharge following critical heart failure treatment.

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))](Patient-Mracena2.md)

**period**: 2025-01-10 08:00:00+0100 --> 2025-06-10 08:00:00+0100

**addresses**: [Condition Heart failure](Condition-CZ-Condition-HDR-Example.md)

> **activity**

### Details

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Kind** | **Status** | **Description** |
| * | Appointment | Scheduled | Follow-up appointment with cardiologist |




## Resource Content

```json
{
  "resourceType" : "CarePlan",
  "id" : "CZ-CarePlan-HDR-Example",
  "status" : "active",
  "intent" : "plan",
  "title" : "Post-Discharge Care Plan",
  "description" : "Care plan for patient post-discharge following critical heart failure treatment.",
  "subject" : {
    "reference" : "Patient/Mracena2"
  },
  "period" : {
    "start" : "2025-01-10T08:00:00+01:00",
    "end" : "2025-06-10T08:00:00+01:00"
  },
  "addresses" : [
    {
      "reference" : "Condition/CZ-Condition-HDR-Example"
    }
  ],
  "activity" : [
    {
      "detail" : {
        "kind" : "Appointment",
        "status" : "scheduled",
        "description" : "Follow-up appointment with cardiologist"
      }
    }
  ]
}

```
