# AllergyIntolerance - Strawberry - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **AllergyIntolerance - Strawberry**

## Example AllergyIntolerance: AllergyIntolerance - Strawberry

Profile: [Allergy Intolerance (HDR CZ)](StructureDefinition-cz-allergyIntolerance-hdr.md)

**identifier**: `urn:oid:1.2.203.24341.1.1.999`/StrawberryAllergy-001

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**type**: Allergy

**criticality**: Low Risk

**code**: Allergy to strawberry

**patient**: [Mračena Mrakomorová (no stated gender), DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rid#4567891235)](Patient-Mracena.md)

> **reaction****manifestation**:Itching of skin,Edema of the tongue**description**: Svědění, otok jazyka.



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "StrawberryAllergy",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/hdr/StructureDefinition/cz-allergyIntolerance-hdr"
    ]
  },
  "identifier" : [
    {
      "system" : "urn:oid:1.2.203.24341.1.1.999",
      "value" : "StrawberryAllergy-001"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed"
      }
    ]
  },
  "type" : "allergy",
  "criticality" : "low",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "91938006",
        "display" : "Allergy to strawberry"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/Mracena"
  },
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "418363000",
              "display" : "Itching of skin"
            }
          ]
        },
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "81950002",
              "display" : "Edema of the tongue"
            }
          ]
        }
      ],
      "description" : "Svědění, otok jazyka."
    }
  ]
}

```
