# Table of Contents - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* **Table of Contents**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

## Table of Contents

| |
| :--- |
| [0 Table of Contents](toc.md) |
| [1 Home](index.md) |
| [2 Domovská stránka](index-cs.md) |
| [3 Scope and content](scope-and-content.md) |
| [4 Oblasti a obsah](scope-and-content-cs.md) |
| [5 Background](background.md) |
| [6 Background](background-cs.md) |
| [7 Authors](authors.md) |
| [8 Autoři](authors-cs.md) |
| [9 Copyright](copyright.md) |
| [10 Autorská práva](copyright-cs.md) |
| [11 Dependencies](dependencies.md) |
| [12 Závislosti](dependencies-cs.md) |
| [13 Examples](examples.md) |
| [14 Příklady](examples-cs.md) |
| [15 Logical models](logical-models.md) |
| [16 Datová sada - logické modely CZ](logical-models-cs.md) |
| [17 Model maps](model-map.md) |
| [18 Mapování logického modelu](model-map-cs.md) |
| [19 Obligations](obligations.md) |
| [20 Obligations](obligations-cs.md) |
| [21 Downloads](downloads.md) |
| [22 Ke stažení](downloads-cs.md) |
| [23 Implementation notes](implementation-notes.md) |
| [24 Implementační poznámky](implementation-notes-cs.md) |
| [25 Artifacts](artifacts.md) |
| [25.1 Actor HDR Consumer L1](ActorDefinition-actor-consumer-hdr-L1.md) |
| [25.2 Actor HDR Consumer L2](ActorDefinition-actor-consumer-hdr-L2.md) |
| [25.3 Actor HDR Consumer L3](ActorDefinition-actor-consumer-hdr-L3.md) |
| [25.4 Actor HDR Creator L1](ActorDefinition-actor-creator-hdr-L1.md) |
| [25.5 Actor HDR Creator L2](ActorDefinition-actor-creator-hdr-L2.md) |
| [25.6 Actor HDR Creator L3](ActorDefinition-actor-creator-hdr-L3.md) |
| [25.7 Address Obligations (HDR CZ)](StructureDefinition-cz-address-obl-hdr.md) |
| [25.8 Allergy Intolerance Obligations (HDR CZ)](StructureDefinition-cz-allergyintolerance-obl-hdr.md) |
| [25.9 Attachments: Obligations](StructureDefinition-cz-attachment-obl-hdr.md) |
| [25.10 Composition: Obligations](StructureDefinition-cz-composition-obl-hdr.md) |
| [25.11 Consent Obligations (HDR CZ)](StructureDefinition-cz-consent-obl-hdr.md) |
| [25.12 Dosage: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-dosage-hospitalstay-obl-hdr.md) |
| [25.13 Dosage: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-dosage-medicationsummary-obl-hdr.md) |
| [25.14 Encounter: Obligations](StructureDefinition-cz-encounter-obl-hdr.md) |
| [25.15 Flag Obligations (HDR CZ)](StructureDefinition-cz-flag-obl-hdr.md) |
| [25.16 Immunization Obligations: HDR CZ](StructureDefinition-cz-immunization-obl-hdr.md) |
| [25.17 Immunization Recommendation Obligations (HDR CZ)](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md) |
| [25.18 Medication Administration Obligations (HDR CZ)](StructureDefinition-cz-medicationadministration-obl-hdr.md) |
| [25.19 Medication Obligations: (HDR CZ) - hospital stay](StructureDefinition-cz-medication-hospitalstay-obl-hdr.md) |
| [25.20 Medication Obligations: (HDR CZ) - medication summary](StructureDefinition-cz-medication-medicationsummary-obl-hdr.md) |
| [25.21 MedicationDispense: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationdispens-hospitalstay-obl-hdr.md) |
| [25.22 MedicationDispense: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationdispens-medicationsummary-obl-hdr.md) |
| [25.23 MedicationRequest: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md) |
| [25.24 MedicationRequest: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md) |
| [25.25 MedicationStatement: Obligations (HDR CZ)](StructureDefinition-cz-medicationstatement-obl-hdr.md) |
| [25.26 Observations: Anthropometric Data obligations](StructureDefinition-cz-observation-anthropometricdata-obl-hdr.md) |
| [25.27 Observations: Infectious Contact obligations](StructureDefinition-cz-observation-ic-obl-hdr.md) |
| [25.28 Organization: Obligations](StructureDefinition-cz-organization-obl-hdr.md) |
| [25.29 Patient: Obligations](StructureDefinition-cz-patient-obl-hdr.md) |
| [25.30 Procedure: Obligations](StructureDefinition-cz-procedure-obl-hdr.md) |
| [25.31 A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md) |
| [25.32 A.1 – Hlavička dokumentu](StructureDefinition-LogHeaderHdrCz.md) |
| [25.33 A.1.1 - Identifikace a A.1.2 - informace o pacientovi](StructureDefinition-LogSubjectCz.md) |
| [25.34 A.1.9 - Digitální podpis](StructureDefinition-LogdigitalSignatureCz.md) |
| [25.35 A.2.1 - Dříve vyslovená přání (cz)](StructureDefinition-LogAdvanceDirectivesCz.md) |
| [25.36 A.2.2 - Urgentní informace (cz)](StructureDefinition-LogAlertsCz.md) |
| [25.37 A.2.3 - Kontakt se zdravotními službami](StructureDefinition-LogInPatientEncounterCz.md) |
| [25.38 A.2.4 - Stav při přijetí (cz)](StructureDefinition-LogAdmissionEvaluationCz.md) |
| [25.39 A.2.6 - Anamnéza](StructureDefinition-LogPatientHistoryCz.md) |
| [25.40 A.2.7 - Průběh hospitalizace](StructureDefinition-LogDischargeDetailsCz.md) |
| [25.41 A.2.7 Průběh hospitalizace](StructureDefinition-LogHospitalStayCz.md) |
| [25.42 A.2.8.1 Objektivní nález](StructureDefinition-LogCzObjectiveFindingsCz.md) |
| [25.43 A.2.8.2 - Funkční stav při propuštění](StructureDefinition-LogFunctionalStatusCz.md) |
| [25.44 A.2.9.1 Plán péče](StructureDefinition-LogPlanOfCareCz.md) |
| [25.45 A.2.9.2 Souhrn medikace](StructureDefinition-LogMedicationSummaryCz.md) |
| [25.46 A.3 - Vizuální podoba dokumentu](StructureDefinition-LogPresentedFormCz.md) |
| [25.47 A.4 - Přílohy (cz)](StructureDefinition-LogAttachmentsCz.md) |
| [25.48 A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReportCz.md) |
| [25.49 A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) |
| [25.50 A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) |
| [25.51 A.1.9 - Digital signature](StructureDefinition-digitalSignatureCz.md) |
| [25.52 A.2.1 - Advance Directives (eHN)](StructureDefinition-AdvanceDirectivesCz.md) |
| [25.53 A.2.2 - Alerts (eHN)](StructureDefinition-AlertsCz.md) |
| [25.54 A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md) |
| [25.55 A.2.4 - Admission evaluation (eHN)](StructureDefinition-AdmissionEvaluationEhnEn.md) |
| [25.56 A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) |
| [25.57 A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) |
| [25.58 A.2.7 - Discharge details (eHN)](StructureDefinition-DischargeDetailsCz.md) |
| [25.59 A.2.7.1 - Objective findings](StructureDefinition-ObjectiveFindingsCz.md) |
| [25.60 A.2.8.1 - Care plan](StructureDefinition-PlanOfCareCz.md) |
| [25.61 A.2.8.2 - Functional status](StructureDefinition-FunctionalStatusCz.md) |
| [25.62 A.2.8.2 - Medication summary](StructureDefinition-MedicationSummaryCz.md) |
| [25.63 A.3 - Presented form](StructureDefinition-PresentedFormCz.md) |
| [25.64 A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) |
| [25.65 Allergy Intolerance (HDR CZ)](StructureDefinition-cz-allergyIntolerance-hdr.md) |
| [25.66 Attachment: HDR (CZ)](StructureDefinition-cz-attachment-hdr.md) |
| [25.67 Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md) |
| [25.68 Care Plan (HDR CZ)](StructureDefinition-cz-carePlan-hdr.md) |
| [25.69 Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md) |
| [25.70 Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md) |
| [25.71 Consent (Advance Directives) (HDR CZ)](StructureDefinition-cz-consent-hdr.md) |
| [25.72 Coverage: Obligations](StructureDefinition-cz-coverage-obl-hdr.md) |
| [25.73 DeviceUseStatement (HDR)](StructureDefinition-cz-deviceUseStatement-hdr.md) |
| [25.74 Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md) |
| [25.75 FamilyMemberHistory (HDR CZ)](StructureDefinition-cz-familyMemberHistory-hdr.md) |
| [25.76 Flag (HDR CZ)](StructureDefinition-cz-flag-hdr.md) |
| [25.77 Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md) |
| [25.78 ImmunizationRecommendation (CZ HDR)](StructureDefinition-cz-immunizationRecommendation-hdr.md) |
| [25.79 Medical Device: Obligations](StructureDefinition-cz-medicalDevice-obl-hdr.md) |
| [25.80 MedicationDispense (HDR)](StructureDefinition-cz-medicationDispense-hdr.md) |
| [25.81 MedicationRequest (HDR CZ)](StructureDefinition-cz-medicationRequest-hdr.md) |
| [25.82 Observation: Anthropometric Data (HDR CZ)](StructureDefinition-cz-observation-weight-hdr.md) |
| [25.83 Observation: Anthropometric Data (HDR CZ) - Abdominal Circumference](StructureDefinition-cz-observation-abdominalCircumference-hdr.md) |
| [25.84 Observation: Anthropometric Data (HDR CZ) - BMI](StructureDefinition-cz-observation-BMI-hdr.md) |
| [25.85 Observation: Anthropometric Data (HDR CZ) - Chest Circumference](StructureDefinition-cz-observation-chestCircumference-hdr.md) |
| [25.86 Observation: Anthropometric Data (HDR CZ) - Head Circumference](StructureDefinition-cz-observation-headCircumference-hdr.md) |
| [25.87 Observation: Anthropometric Data (HDR CZ) - Height](StructureDefinition-cz-observation-height-hdr.md) |
| [25.88 Observation: Infectious Contact (HDR CZ)](StructureDefinition-cz-observation-infectious-contact-hdr.md) |
| [25.89 Observation: SDOH (HDR CZ)](StructureDefinition-cz-observation-sdoh-hdr.md) |
| [25.90 Observation: travel history (HDR CZ)](StructureDefinition-cz-observation-travel-hdr.md) |
| [25.91 Practitioner Role: Obligations](StructureDefinition-cz-practitionerRole-obl-hdr.md) |
| [25.92 Practitioner: Obligations](StructureDefinition-cz-practitioner-obl-hdr.md) |
| [25.93 Procedure (HDR CZ)](StructureDefinition-cz-procedure-hdr.md) |
| [25.94 Related Person: HDR (CZ)](StructureDefinition-cz-relatedPerson-hdr.md) |
| [25.95 Related Person: Obligations](StructureDefinition-cz-relatedPerson-obl-hdr.md) |
| [25.96 CZ Consent Category](ValueSet-cz-consent-category.md) |
| [25.97 CZ Provision Code](ValueSet-cz-provision-code.md) |
| [25.98 eHDSI Condition Present On Admission](ValueSet-eHDSIConditionPOA.md) |
| [25.99 eHDSI Treatment Class](ValueSet-eHDSITreatmentClass.md) |
| [25.100 Exposure of transmissible agents](ValueSet-exposureAgent-eu-hdr.md) |
| [25.101 Related Person Relationship Types (HDR)](ValueSet-relatedPersonRelationshipTypes-eu-hdr.md) |
| [25.102 Temporary HDR Code System](CodeSystem-temporarySystem-hdr-cz.md) |
| [25.103 CZ Advance Directives Model to this guide Map](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) |
| [25.104 CZ Alerts Model to this guide Map](ConceptMap-alerts2FHIR-cz-hdr.md) |
| [25.105 CZ Attachment Model to this guide Map](ConceptMap-AttachmentHDR2FHIR-cz.md) |
| [25.106 CZ HDR Model to this guide Map](ConceptMap-hdr2FHIR-cz-hdr.md) |
| [25.107 CZ Header Model to this guide Map](ConceptMap-hdrHeader2FHIR-cz-hdr.md) |
| [25.108 CZ Patient History to this guide Map](ConceptMap-patientHistory2FHIR-cz-hdr.md) |
| [25.109 eHN Encounter Model to this guide Map](ConceptMap-encounter2FHIR-cz-hdr.md) |
| [25.110 eHN Functional Status Model to this guide Map](ConceptMap-functionalStatus2FHIR-hdr-cz.md) |
| [25.111 eHN Hospital Stay Model to this guide Map](ConceptMap-hospitalStay2FHIR-cz-hdr.md) |
| [25.112 eHN Medication Summary Model to this guide Map](ConceptMap-medicationSummary2FHIR-cz-hdr.md) |
| [25.113 eHN Objective Findings Model to this guide Map](ConceptMap-objectiveFindings2FHIR-hdr-cz.md) |
| [25.114 eHN Plan of Care Model to this guide Map](ConceptMap-planOfCare2FHIR-cz-hdr.md) |
| [25.115 eHN Subject Model to this guide Map](ConceptMap-subject2FHIR-cz-hdr.md) |
| [25.116 AdvanceDirectives DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md) |
| [25.117 Allergy Information Unknown](AllergyIntolerance-AllergyInfoUnknown.md) |
| [25.118 AllergyIntolerance - cow's milk protein](AllergyIntolerance-MilkAllergy.md) |
| [25.119 AllergyIntolerance - No Known Allergies](AllergyIntolerance-NoKnownAllergy.md) |
| [25.120 AllergyIntolerance - Penicillin](AllergyIntolerance-PenicillinAllergy.md) |
| [25.121 AllergyIntolerance - Strawberry](AllergyIntolerance-StrawberryAllergy.md) |
| [25.122 AllergyIntolerance - Strawberry](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md) |
| [25.123 Ambulance interního lékařství, MUDr. Jiří Zdvořilý](Organization-Organization-Referrer.md) |
| [25.124 Cardiac Arrest Flag](Flag-Flag1.md) |
| [25.125 CarePlan-Novak-Petr](CarePlan-9c913d06-84fe-4d35-b35b-8b0c7965f535.md) |
| [25.126 CRP - Novák Petr](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md) |
| [25.127 CZ-CarePlan-HDR Example](CarePlan-CZ-CarePlan-HDR-Example.md) |
| [25.128 CZ-Condition-HDR Angiodysplasia](Condition-AngiodysplasiaCondition.md) |
| [25.129 CZ-Condition-HDR Atrial Fibrillation](Condition-AtrialFibrillationCondition.md) |
| [25.130 CZ-Condition-HDR Example](Condition-CZ-Condition-HDR-Example.md) |
| [25.131 CZ-Condition-HDR Example 2](Condition-CZ-Condition-HDR-Example-2.md) |
| [25.132 CZ-Condition-HDR Example 3](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md) |
| [25.133 CZ-Condition-HDR Example 3](Condition-CZ-Condition-HDR-Example-3.md) |
| [25.134 CZ-Condition-HDR Example K409](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md) |
| [25.135 CZ-Condition-HDR Hypercholesterolemia](Condition-HypercholesterolemiaCondition.md) |
| [25.136 CZ-Condition-HDR Hypothyroidism](Condition-HypothyroidismCondition.md) |
| [25.137 CZ-Condition-HDR Iron Deficiency Anemia](Condition-IronDeficiencyAnemiaCondition.md) |
| [25.138 CZ-Condition-HDR Osteoporosis](Condition-OsteoporosisCondition.md) |
| [25.139 CZ-Condition-HDR Presbycusis](Condition-PresbycusisCondition.md) |
| [25.140 CZ-Condition-HDR TIA](Condition-TIACondition.md) |
| [25.141 CZ-Condition-HDR Varicose Veins](Condition-VaricoseVeinsCondition.md) |
| [25.142 CZ-Encounter-HDR Example](Encounter-CZ-Encounter-HDR-Example.md) |
| [25.143 CZ-Encounter-HDR Example of encounter for Novak Petr](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md) |
| [25.144 CZ-Encounter-HDR Example of encounter with emergency priority](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md) |
| [25.145 CZ-Encounter-HDR Example of finished hospital encounter](Encounter-HospitalEncounter.md) |
| [25.146 CZ-MedicationStatement-HDR Example of Atorvastatin](MedicationStatement-AtorvastatinMedication.md) |
| [25.147 CZ-MedicationStatement-HDR Example of Bisoprolol](MedicationStatement-BisoprololMedication.md) |
| [25.148 CZ-MedicationStatement-HDR Example of Calcium D3](MedicationStatement-CalciumD3Medication.md) |
| [25.149 CZ-MedicationStatement-HDR Example of Euthyrox](MedicationStatement-47472c99-09bf-4007-bfaa-16c9665ae090.md) |
| [25.150 CZ-MedicationStatement-HDR Example of Ibalgin](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.md) |
| [25.151 CZ-MedicationStatement-HDR Example of Iron Supplement](MedicationStatement-IronSupplementMedication.md) |
| [25.152 CZ-MedicationStatement-HDR Example of Levothyroxine](MedicationStatement-LevothyroxineMedication.md) |
| [25.153 CZ-MedicationStatement-HDR Example of Paracetamol](MedicationStatement-f34114fc-138f-4bd8-8e1a-804d14ec9986.md) |
| [25.154 CZ-MedicationStatement-HDR Example of Rivaroxaban](MedicationStatement-RivaroxabanMedication.md) |
| [25.155 CZ-Procedure-HDR Example - Acute appendicitis](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md) |
| [25.156 CZ-Procedure-HDR Example - Appendectomy](Procedure-Procedure-Appendectomy.md) |
| [25.157 CZ-Procedure-HDR Example - Colonoscopy](Procedure-ColonoscopyProcedure.md) |
| [25.158 CZ-Procedure-HDR Example - Inguinal hernia](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md) |
| [25.159 CZ-Procedure-HDR Example - No known procedures](Procedure-Procedure-No-Procedure.md) |
| [25.160 CZ-Procedure-HDR Example - Pacemaker](Procedure-Procedure-Insert-Pacemaker2.md) |
| [25.161 CZ-Procedure-HDR Example - Pacemaker](Procedure-Procedure-Insert-Pacemaker.md) |
| [25.162 CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md) |
| [25.163 Device-Pacemaker](Device-Device-Pacemaker.md) |
| [25.164 Discharge Summary Document - Base64](DocumentReference-d9ad8a22-a12b-48db-938c-4066a3a0617a.md) |
| [25.165 Discharge Summary Document - PDF](DocumentReference-66678621-df93-47ca-a36c-2a39a92472e7.md) |
| [25.166 DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md) |
| [25.167 DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md) |
| [25.168 DischargeBundle-Novak-Petr-L1-core](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md) |
| [25.169 DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md) |
| [25.170 DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md) |
| [25.171 Dispense – Euthyrox](MedicationDispense-MedicationDispense-Euthyrox.md) |
| [25.172 Dispense – Euthyrox](Medication-Medication-Euthyrox.md) |
| [25.173 Dispense – Ibalgin 400](MedicationDispense-MedicationDispense-Ibalgin400.md) |
| [25.174 Dispense – Paracetamol](MedicationDispense-MedicationDispense-Paracetamol.md) |
| [25.175 Dosažený stupeň vzdělání](Observation-Observation-Education-level.md) |
| [25.176 Erytrocyty](Observation-rbc-result.md) |
| [25.177 Example Czech Location](Location-example-cz-location.md) |
| [25.178 ExampleAbdominalCircumference](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md) |
| [25.179 ExampleBloodPressure](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md) |
| [25.180 ExampleBMI](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md) |
| [25.181 ExampleChestCircumference](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md) |
| [25.182 ExampleHeadCircumference](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md) |
| [25.183 ExampleHeight](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md) |
| [25.184 ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md) |
| [25.185 ExampleSdohAlcoholSporadic](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md) |
| [25.186 ExampleSdohSmoking](Observation-ExampleSdohSmoking.md) |
| [25.187 ExampleSdohSmokingEnded](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md) |
| [25.188 ExampleWeight](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md) |
| [25.189 Goal for Hernia Treatment](Goal-620b1120-cece-44b1-89f5-20413054eb1d.md) |
| [25.190 Hematokrit](Observation-hct-result.md) |
| [25.191 Hematologická laboratoř Brno](Organization-Lab-HematologieBrno.md) |
| [25.192 Hemoglobin](Observation-hb-result.md) |
| [25.193 Hospital Discharge Report - Novák Petr (Signed Bundle)](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md) |
| [25.194 Immunization example of Covid](Immunization-3f85726c-ad2f-441b-89ce-10000000001e.md) |
| [25.195 Immunization recommendation example](ImmunizationRecommendation-ImmunizationRecommendation.md) |
| [25.196 Infekční kontakt](Observation-Observation-InfectiousContact.md) |
| [25.197 Koníčky](Observation-3f85726c-ad2f-441b-89ce-100000000024.md) |
| [25.198 Leukocyty](Observation-wbc-result.md) |
| [25.199 Medication – Covid vaccine](Medication-med-CovidVaccineComirnaty.md) |
| [25.200 Medication – Ibalgin 400](Medication-med-Ibalgin400.md) |
| [25.201 Medication – Paracetamol](Medication-med-paracetamol.md) |
| [25.202 Mracena2](Patient-Mracena2.md) |
| [25.203 Observation - Travel History](Observation-Observation-TravelHistory-Madagaskar.md) |
| [25.204 Organization-1](Organization-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169.md) |
| [25.205 Organization-L1](Organization-9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1.md) |
| [25.206 Organization: Registering healthcare provider example](Organization-RegisteringProviderExample.md) |
| [25.207 Organization: Registering healthcare provider example](Organization-RegisteringProviderExample-gynecology.md) |
| [25.208 Očkování Covid](Immunization-Immunization-CovidExample.md) |
| [25.209 Panel krevního obrazu](Observation-bloodcount-panel.md) |
| [25.210 Patient - Mracena](Patient-Mracena.md) |
| [25.211 Patient-Novak-Petr](Patient-3f85726c-ad2f-441b-89ce-100000000000.md) |
| [25.212 Patient-Novak-Petr-L1](Patient-48a9d440-4194-42c1-87ad-b5a39020a4d0.md) |
| [25.213 Pfizer výrobce vakcíny](Organization-Organization-Pfizer.md) |
| [25.214 Použití kardiostimulátoru](DeviceUseStatement-DeviceUseStatement-Pacemaker.md) |
| [25.215 Pracovní zapojení](Observation-3f85726c-ad2f-441b-89ce-100000000023.md) |
| [25.216 Practitioner Role for L1 documentr](PractitionerRole-69d34ceb-b556-4f75-9e4c-9184fe8a10c5.md) |
| [25.217 Practitioner-2](Practitioner-Practitioner-2.md) |
| [25.218 Practitioner-Admitter](Practitioner-Practitioner-Admitter.md) |
| [25.219 Practitioner-Author](Practitioner-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a.md) |
| [25.220 Practitioner-Author-detail](PractitionerRole-2b7e9637-5018-4542-9faf-d5abdee7b849.md) |
| [25.221 Practitioner-Author-L1](Practitioner-e234a53a-4e0d-4fb8-9403-e0e324a50f64.md) |
| [25.222 Practitioner-L1](Practitioner-Practitioner-L1.md) |
| [25.223 Practitioner-Referrer](Practitioner-Practitioner-Referrer.md) |
| [25.224 Practitioner-Referrer-detail](PractitionerRole-Practitioner-Referrer-detail.md) |
| [25.225 Practitioner-UZV](Practitioner-Practitioner-UZV.md) |
| [25.226 PractitionerRole1](PractitionerRole-practitionerrole1.md) |
| [25.227 Propouštěcí zpráva](Composition-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf.md) |
| [25.228 Propouštěcí zpráva](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md) |
| [25.229 Propouštěcí zpráva](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.md) |
| [25.230 Propouštěcí zpráva z nemocnice](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c035.md) |
| [25.231 Sample Czech Location 1](Location-Location-5.md) |
| [25.232 Sample Czech Location 2](Location-sample-cz-location-2.md) |
| [25.233 Sample Czech Location 2](Location-cz-Location-Chrudim-Chir1.md) |
| [25.234 Sample Czech Location 2](Location-cz-Location-Chrudim-ChirJIP.md) |
| [25.235 Sample Czech Location 3](Location-sample-cz-location-3.md) |
| [25.236 Sample Czech Location 4](Location-sample-cz-location-4.md) |
| [25.237 Signature of image order](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab.md) |
| [25.238 Signature of image order](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb.md) |
| [25.239 Sociální síť](Observation-3f85726c-ad2f-441b-89ce-100000000025.md) |
| [25.240 Sova](Practitioner-Sova.md) |
| [25.241 Sovak](Practitioner-Sovak.md) |
| [25.242 Společenské uplatnění](Observation-3f85726c-ad2f-441b-89ce-100000000022.md) |
| [25.243 Stav při propuštění](Observation-3f85726c-ad2f-441b-89ce-100000000021.md) |
| [25.244 Střední podvýživa](Flag-5a17a710-193e-4490-a627-7202925aa56e.md) |
| [25.245 Trombocyty](Observation-plt-result.md) |
| [25.246 UZV - Novák Petr](Observation-e15aeeaf-e288-404c-9704-9c8f0b2d4e3a.md) |
| [25.247 Vzdělání](Observation-3f85726c-ad2f-441b-89ce-100000000027.md) |
| [25.248 Vzorek krve – EDTA](Specimen-Specimen-EDTA-1.md) |
| [26 HospitalDischargeReport Relationships](HospitalDischargeReport-map.md) |
| [27 Header Relationships](Header-map.md) |
| [28 Subject Relationships](Subject-map.md) |
| [29 InPatientEncounter Relationships](InPatientEncounter-map.md) |
| [30 AdmissionEvaluation Relationships](AdmissionEvaluation-map.md) |
| [31 ObjectiveFindings Relationships](ObjectiveFindings-map.md) |
| [32 FunctionalStatus Relationships](FunctionalStatus-map.md) |
| [33 HospitalStay Relationships](HospitalStay-map.md) |
| [34 PatientHistory Relationships](PatientHistory-map.md) |
| [35 Alerts Relationships](Alerts-map.md) |
| [36 AdvanceDirectives Relationships](AdvanceDirectives-map.md) |
| [37 PlanOfCare Relationships](PlanOfCare-map.md) |
| [38 MedicationSummary Relationships](MedicationSummary-map.md) |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

