# Mapování logického modelu - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Mapování logického modelu**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

## Mapování logického modelu

Tato stránka obsahuje seznam stránek dokumentujících s grafickým znázorněním mapování mezi logickými modely a použitými zdroji/profily

| | |
| :--- | :--- |
| Propouštěcí zpráva | [HospitalDischargeReport-map.html](HospitalDischargeReport-map.md) |
| Hlavička dokumentu | [Header-map.html](Header-map.md) |
| Subjekt | [Subject-map.html](Subject-map.md) |
| Stav při přijetí | [InPatientEncounter-map.html](InPatientEncounter-map.md) |
| Důvod přijetí | [AdmissionEvaluation-map.html](AdmissionEvaluation-map.md) |
| Stav při propuštění | [ObjectiveFindings-map.html](ObjectiveFindings-map.md) |
| FunctionalStatus | [FunctionalStatus-map.html](FunctionalStatus-map.md) |
| Anamnéza | [PatientHistory-map.html](PatientHistory-map.md) |
| Údaje o hospitalizaci | [HospitalStay-map.html](HospitalStay-map.md) |
| Urgentní informace | [Alerts-map.html](Alerts-map.md) |
| Dříve vyjádřená přání | [AdvanceDirectives-map.html](AdvanceDirectives-map.md) |
| Medikace | [MedicationSummary-map.html](MedicationSummary-map.md) |
| Plán péče | [PlanOfCare-map.html](PlanOfCare-map.md) |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

