# Logical models - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Logical models**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

## Logical models

This page lists HL7 FHIR logical models used to represent the HOSPITAL DISCHARGE REPORT DATASET.

To facilitate the references with the eHN data sets the short description of each element reports the label of the eHN element (e.g., A.1.7.2 Result validator name).

The HL7 FHIR logical model requires that element cardinality is specified, while the eHN data set doesn't define them on purpose. For this reason the elements' cardinality of the following FHIR Logical Model should be interpreted with this in mind, thus they should not be considered as "normative".

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogEnHospitalDischargeReportEhnCz](StructureDefinition-HospitalDischargeReportCz.md) | A - Hospital Discharge Report (eHN) | Hospital Discharge Report |
| [LogEnHeaderHdrCz](StructureDefinition-Header.md) | A.1 - Hospital Discharge Report header data element | Hospital Discharge Report - Hospital Discharge Report header data element - A.1 eHN |
| [LogEnSubjectHdrEhnCz](StructureDefinition-SubjectCz.md) | A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject | Hospital Discharge Report - Hospital Discharge Report subject data element - A.1.1 and A.1.2 eHN |
| [LogEnDigitalSignatureCz](StructureDefinition-digitalSignatureCz.md) | A.1.9 - Digital signature | Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [LogEnAdvanceDirectivesEhnCz](StructureDefinition-AdvanceDirectivesCz.md) | A.2.1 - Advance Directives (eHN) | Hospital Discharge Report - Advance Directives - A.2.1 eHN |
| [LogEnAlertsEhnCz](StructureDefinition-AlertsCz.md) | A.2.2 - Alerts (eHN) | Hospital Discharge Report - Alerts - A.2.2 eHN |
| [LogEnEncounterEhnCz](StructureDefinition-InPatientEncounterCz.md) | A.2.3 - Encounter (eHN) | Hospital Discharge Report - Encounter - A.2.3 eHN |
| [LogEnAdmissionEvaluationEhnEn](StructureDefinition-AdmissionEvaluationEhnEn.md) | A.2.4 - Admission evaluation (eHN) | Hospital Discharge Report - Admission evaluation - A.2.4 eHN |
| [LogEnPatientHistoryEhnCz](StructureDefinition-PatientHistoryCz.md) | A.2.5 - Patient history (eHN) | Hospital Discharge Report - Patient history - A.2.5 eHN |
| [LogEnHospitalStayEhnCz](StructureDefinition-HospitalStayCz.md) | A.2.6 - Hospital stay (eHN) | Hospital Discharge Report - Hospital stay - A.2.6 eHN |
| [LogEnDischargeDetailsEhnCz](StructureDefinition-DischargeDetailsCz.md) | A.2.7 - Discharge details (eHN) | Hospital Discharge Report - Discharge details - A.2.7 eHN |
| [LogEnObjectiveFindingsHdrEhnCz](StructureDefinition-ObjectiveFindingsCz.md) | A.2.7.1 - Objective findings | Hospital Discharge Report - Objective Findings- A.2.7.1 eHN |
| [LogEnPlanOfCareHdrEhnCz](StructureDefinition-PlanOfCareCz.md) | A.2.8.1 - Care plan | Hospital Discharge Report - Care plan after discharge - A.2.8.1 eHN |
| [LogEnFunctionalStatusHdrEhnCz](StructureDefinition-FunctionalStatusCz.md) | A.2.8.2 - Functional status | Hospital Discharge Report - Functional status - A.2.8.2 eHN |
| [LogEnMedicationSummaryHdrEhnCz](StructureDefinition-MedicationSummaryCz.md) | A.2.8.2 - Medication summary | Hospital Discharge Report - Medication Summary after discharge - A.2.8.2 eHN |
| [LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md) | A.3 - Presented form | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md) | A.4 - Additional attachments | Discharge Report - additional attachments - A.4 |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

