# Autorská práva - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Autorská práva**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

## Autorská práva

### Prohlášení o duševním vlastnictví

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [contactRole2](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0131.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 5 more,[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Patient/3f85726c-ad2f-441b-89ce-100000000000](Patient-3f85726c-ad2f-441b-89ce-100000000000.md)and[Patient/Mracena2](Patient-Mracena2.md)
* [providerRole](http://terminology.hl7.org/5.3.0/CodeSystem-v2-0443.html): [CZ_ImmunizationHdr](StructureDefinition-cz-immunization-hdr.md) and [CZ_ImmunizationObligationsHdr](StructureDefinition-cz-immunization-obl-hdr.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AdvanceDirectives2FHIRCzHdr](ConceptMap-advanceDirectives2FHIR-cz-hdr.md), [Alerts2FHIRCzHdr](ConceptMap-alerts2FHIR-cz-hdr.md)...Show 126 more,[AttachmentHDR2FHIRcz](ConceptMap-AttachmentHDR2FHIR-cz.md),[Bundle/1c794aff-876a-41bf-9401-fa8fee3b1e57](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md),[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZConsentCategory](ValueSet-cz-consent-category.md),[CZProvisionCode](ValueSet-cz-provision-code.md),[CZ_AddressObligationsHdr](StructureDefinition-cz-address-obl-hdr.md),[CZ_AllergyIntoleranceHdr](StructureDefinition-cz-allergyIntolerance-hdr.md),[CZ_AllergyIntoleranceObligationsHdr](StructureDefinition-cz-allergyintolerance-obl-hdr.md),[CZ_AttachmentHdr](StructureDefinition-cz-attachment-hdr.md),[CZ_AttachmentsObligationsHdr](StructureDefinition-cz-attachment-obl-hdr.md),[CZ_BundleHdr](StructureDefinition-cz-bundle-hdr.md),[CZ_CarePlanHdr](StructureDefinition-cz-carePlan-hdr.md),[CZ_CompositionHdr](StructureDefinition-cz-composition-hdr.md),[CZ_CompositionObligationsHdr](StructureDefinition-cz-composition-obl-hdr.md),[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[CZ_ConsentHdr](StructureDefinition-cz-consent-hdr.md),[CZ_ConsentObligationsHdr](StructureDefinition-cz-consent-obl-hdr.md),[CZ_CoverageObligationsHdr](StructureDefinition-cz-coverage-obl-hdr.md),[CZ_DeviceUseStatementHdr](StructureDefinition-cz-deviceUseStatement-hdr.md),[CZ_DosageHospitalStayObligationsHdr](StructureDefinition-cz-dosage-hospitalstay-obl-hdr.md),[CZ_DosageMedicationSummaryObligationsHdr](StructureDefinition-cz-dosage-medicationsummary-obl-hdr.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[CZ_EncounterObligationsHdr](StructureDefinition-cz-encounter-obl-hdr.md),[CZ_FamilyMemberHistoryHdr](StructureDefinition-cz-familyMemberHistory-hdr.md),[CZ_FlagHdr](StructureDefinition-cz-flag-hdr.md),[CZ_FlagObligationsHdr](StructureDefinition-cz-flag-obl-hdr.md),[CZ_ImmunizationHdr](StructureDefinition-cz-immunization-hdr.md),[CZ_ImmunizationObligationsHdr](StructureDefinition-cz-immunization-obl-hdr.md),[CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md),[CZ_ImmunizationRecommendationObligationsHdr](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md),[CZ_MedicalDeviceObligationsHdr](StructureDefinition-cz-medicalDevice-obl-hdr.md),[CZ_MedicationAdministrationObligationsHdr](StructureDefinition-cz-medicationadministration-obl-hdr.md),[CZ_MedicationDispenseHdr](StructureDefinition-cz-medicationDispense-hdr.md),[CZ_MedicationDispenseHospitalStayObligationsHdr](StructureDefinition-cz-medicationdispens-hospitalstay-obl-hdr.md),[CZ_MedicationDispenseMedicationSummaryObligationsHdr](StructureDefinition-cz-medicationdispens-medicationsummary-obl-hdr.md),[CZ_MedicationHospitalStayObligationsHdr](StructureDefinition-cz-medication-hospitalstay-obl-hdr.md),[CZ_MedicationMedicationSummaryObligationsHdr](StructureDefinition-cz-medication-medicationsummary-obl-hdr.md),[CZ_MedicationRequestHdr](StructureDefinition-cz-medicationRequest-hdr.md),[CZ_MedicationRequestHospitalStayObligationsHdr](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md),[CZ_MedicationRequestMedicationSummaryObligationsHdr](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md),[CZ_MedicationStatementObligationsHdr](StructureDefinition-cz-medicationstatement-obl-hdr.md),[CZ_ObservationAbdominalCircumferenceHdr](StructureDefinition-cz-observation-abdominalCircumference-hdr.md),[CZ_ObservationAnthropometricDataHdrObligations](StructureDefinition-cz-observation-anthropometricdata-obl-hdr.md),[CZ_ObservationBMIHdr](StructureDefinition-cz-observation-BMI-hdr.md),[CZ_ObservationChestCircumferenceHdr](StructureDefinition-cz-observation-chestCircumference-hdr.md),[CZ_ObservationHeadCircumferenceHdr](StructureDefinition-cz-observation-headCircumference-hdr.md),[CZ_ObservationHeightHdr](StructureDefinition-cz-observation-height-hdr.md),[CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md),[CZ_ObservationInfectiousContactHdrObligations](StructureDefinition-cz-observation-ic-obl-hdr.md),[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[CZ_ObservationTravelHdr](StructureDefinition-cz-observation-travel-hdr.md),[CZ_ObservationWeightHdr](StructureDefinition-cz-observation-weight-hdr.md),[CZ_OrganizationObligationsHdr](StructureDefinition-cz-organization-obl-hdr.md),[CZ_PatientObligationsHdr](StructureDefinition-cz-patient-obl-hdr.md),[CZ_PractitionerObligationsHdr](StructureDefinition-cz-practitioner-obl-hdr.md),[CZ_PractitionerRoleObligationsHdr](StructureDefinition-cz-practitionerRole-obl-hdr.md),[CZ_ProcedureHdr](StructureDefinition-cz-procedure-hdr.md),[CZ_ProcedureObligationsHdr](StructureDefinition-cz-procedure-obl-hdr.md),[CZ_RelatedPersonHdr](StructureDefinition-cz-relatedPerson-hdr.md),[CZ_RelatedPersonObligationsHdr](StructureDefinition-cz-relatedPerson-obl-hdr.md),[EHDSIConditionPOA](ValueSet-eHDSIConditionPOA.md),[EHDSITreatmentClass](ValueSet-eHDSITreatmentClass.md),[Encounter2FHIRCzHdr](ConceptMap-encounter2FHIR-cz-hdr.md),[ExposureAgentHdrVs](ValueSet-exposureAgent-eu-hdr.md),[FunctionalStatus2FHIREuHdr](ConceptMap-functionalStatus2FHIR-hdr-cz.md),[HL7CzHospitalDischargeIg](index.md),[Hdr2FHIRCzHdr](ConceptMap-hdr2FHIR-cz-hdr.md),[HdrConsumer-L1](ActorDefinition-actor-consumer-hdr-L1.md),[HdrConsumer-L2](ActorDefinition-actor-consumer-hdr-L2.md),[HdrConsumer-L3](ActorDefinition-actor-consumer-hdr-L3.md),[HdrCreator-L1](ActorDefinition-actor-creator-hdr-L1.md),[HdrCreator-L2](ActorDefinition-actor-creator-hdr-L2.md),[HdrCreator-L3](ActorDefinition-actor-creator-hdr-L3.md),[Header2FHIRczHdr](ConceptMap-hdrHeader2FHIR-cz-hdr.md),[HospitalStay2FHIRCzHdr](ConceptMap-hospitalStay2FHIR-cz-hdr.md),[LogCzAdmissionEvaluation](StructureDefinition-LogAdmissionEvaluationCz.md),[LogCzAdvanceDirectivesEhnCz](StructureDefinition-LogAdvanceDirectivesCz.md),[LogCzAlertsCz](StructureDefinition-LogAlertsCz.md),[LogCzAttachmentsCz](StructureDefinition-LogAttachmentsCz.md),[LogCzDigitalSignatureCz](StructureDefinition-LogdigitalSignatureCz.md),[LogCzDischargeDetailsCz](StructureDefinition-LogDischargeDetailsCz.md),[LogCzEncounterCz](StructureDefinition-LogInPatientEncounterCz.md),[LogCzFunctionalStatusHdrCz](StructureDefinition-LogFunctionalStatusCz.md),[LogCzHeaderCz](StructureDefinition-LogHeaderHdrCz.md),[LogCzHospitalDischargeReportCz](StructureDefinition-LogHospitalDischargeReportCz.md),[LogCzHospitalStayCz](StructureDefinition-LogHospitalStayCz.md),[LogCzMedicationSummaryHdrCz](StructureDefinition-LogMedicationSummaryCz.md),[LogCzPatientHistoryCz](StructureDefinition-LogPatientHistoryCz.md),[LogCzPresentedFormCz](StructureDefinition-LogPresentedFormCz.md),[LogCzSubjectHdrCz](StructureDefinition-LogSubjectCz.md),[LogEnAdmissionEvaluationEhnEn](StructureDefinition-AdmissionEvaluationEhnEn.md),[LogEnAdvanceDirectivesEhnCz](StructureDefinition-AdvanceDirectivesCz.md),[LogEnAlertsEhnCz](StructureDefinition-AlertsCz.md),[LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md),[LogEnDigitalSignatureCz](StructureDefinition-digitalSignatureCz.md),[LogEnDischargeDetailsEhnCz](StructureDefinition-DischargeDetailsCz.md),[LogEnEncounterEhnCz](StructureDefinition-InPatientEncounterCz.md),[LogEnFunctionalStatusHdrEhnCz](StructureDefinition-FunctionalStatusCz.md),[LogEnHeaderHdrCz](StructureDefinition-Header.md),[LogEnHospitalDischargeReportEhnCz](StructureDefinition-HospitalDischargeReportCz.md),[LogEnHospitalStayEhnCz](StructureDefinition-HospitalStayCz.md),[LogEnMedicationSummaryHdrEhnCz](StructureDefinition-MedicationSummaryCz.md),[LogEnObjectiveFindingsHdrEhnCz](StructureDefinition-ObjectiveFindingsCz.md),[LogEnPatientHistoryEhnCz](StructureDefinition-PatientHistoryCz.md),[LogEnPlanOfCareHdrEhnCz](StructureDefinition-PlanOfCareCz.md),[LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md),[LogEnSubjectHdrEhnCz](StructureDefinition-SubjectCz.md),[MedicationSummary2FHIRCzHdr](ConceptMap-medicationSummary2FHIR-cz-hdr.md),[Nemocnice Chrudim](Organization-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169.md),[Nemocnice Pardubického kraje, a.s., Chrudimská nemocnice](Organization-9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1.md),[ObjectiveFindings2FHIREuHdr](ConceptMap-objectiveFindings2FHIR-hdr-cz.md),[ObjectiveFindingsHdrCz](StructureDefinition-LogCzObjectiveFindingsCz.md),[Observation/Observation-TravelHistory-Madagaskar](Observation-Observation-TravelHistory-Madagaskar.md),[PLogCzlanOfCareHdrCz](StructureDefinition-LogPlanOfCareCz.md),[Patient/48a9d440-4194-42c1-87ad-b5a39020a4d0](Patient-48a9d440-4194-42c1-87ad-b5a39020a4d0.md),[Patient/Mracena2](Patient-Mracena2.md),[PatientHistory2FHIRCzHdr](ConceptMap-patientHistory2FHIR-cz-hdr.md),[PlanOfCare2FHIRCzHdr](ConceptMap-planOfCare2FHIR-cz-hdr.md),[Practitioner/Practitioner-L1](Practitioner-Practitioner-L1.md),[RelatedPersonRelationshipTypesHDR](ValueSet-relatedPersonRelationshipTypes-eu-hdr.md),[Subject2FHIRCzHdr](ConceptMap-subject2FHIR-cz-hdr.md)and[TemporaryHDRSystem](CodeSystem-temporarySystem-hdr-cz.md)


* Produced by HL7 under the terms of HL7® Governance and Operations Manual relating to Intellectual Property (Section 16), specifically its copyright, trademark and patent provisions. This document is licensed under Creative Commons "No Rights Reserved" (CC0).

* [Absent and Unknown Data - IPS](http://hl7.org/fhir/uv/ips/STU1.1/CodeSystem-absent-unknown-uv-ips.html): [Procedure/Procedure-No-Procedure](Procedure-Procedure-No-Procedure.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 17 more,[Medication/Medication-Euthyrox](Medication-Medication-Euthyrox.md),[Medication/med-CovidVaccineComirnaty](Medication-med-CovidVaccineComirnaty.md),[Medication/med-Ibalgin400](Medication-med-Ibalgin400.md),[Medication/med-paracetamol](Medication-med-paracetamol.md),[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md),[Observation/5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md),[Observation/5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md),[Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md),[Observation/6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md),[Observation/7cf304de-5ae3-4621-8531-9c8f0b2d4e3a](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md),[Observation/8d2aea77-f576-4d0f-9508-537359aa44d6](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md),[Observation/hb-result](Observation-hb-result.md),[Observation/hct-result](Observation-hct-result.md),[Observation/plt-result](Observation-plt-result.md),[Observation/rbc-result](Observation-rbc-result.md)and[Observation/wbc-result](Observation-wbc-result.md)


* These codes are excerpted from ASTM Standard, E1762-95(2013) - Standard Guide for Electronic Authentication of Health Care Information, Copyright by ASTM International, 100 Barr Harbor Drive, West Conshohocken, PA 19428. Copies of this standard are available through the ASTM Web Site at www.astm.org.

* [Signature Type Codes](http://hl7.org/fhir/R4/codesystem-signature-type.html): [Bundle/1c794aff-876a-41bf-9401-fa8fee3b1e57](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md), [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)...Show 6 more,[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab.md)and[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/1c794aff-876a-41bf-9401-fa8fee3b1e57](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md), [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)...Show 34 more,[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_CompositionHdr](StructureDefinition-cz-composition-hdr.md),[CZ_CompositionObligationsHdr](StructureDefinition-cz-composition-obl-hdr.md),[CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md),[CZ_ImmunizationRecommendationObligationsHdr](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md),[CZ_ObservationAbdominalCircumferenceHdr](StructureDefinition-cz-observation-abdominalCircumference-hdr.md),[CZ_ObservationBMIHdr](StructureDefinition-cz-observation-BMI-hdr.md),[CZ_ObservationChestCircumferenceHdr](StructureDefinition-cz-observation-chestCircumference-hdr.md),[CZ_ObservationHeadCircumferenceHdr](StructureDefinition-cz-observation-headCircumference-hdr.md),[CZ_ObservationHeightHdr](StructureDefinition-cz-observation-height-hdr.md),[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[CZ_ObservationTravelHdr](StructureDefinition-cz-observation-travel-hdr.md),[CZ_ObservationWeightHdr](StructureDefinition-cz-observation-weight-hdr.md),[Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c035](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c035.md),[Composition/6891fd68-dc3c-4c91-a8d3-cb5ec990c03b](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.md),[Composition/701f51d5-78bf-428e-a6b5-349c2614ce07](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md),[Composition/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf](Composition-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf.md),[DocumentReference/66678621-df93-47ca-a36c-2a39a92472e7](DocumentReference-66678621-df93-47ca-a36c-2a39a92472e7.md),[DocumentReference/d9ad8a22-a12b-48db-938c-4066a3a0617a](DocumentReference-d9ad8a22-a12b-48db-938c-4066a3a0617a.md),[ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md),[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md),[Observation/5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md),[Observation/5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md),[Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md),[Observation/6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md),[Observation/7cf304de-5ae3-4621-8531-9c8f0b2d4e3a](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md),[Observation/8d2aea77-f576-4d0f-9508-537359aa44d6](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md)and[Observation/Observation-TravelHistory-Madagaskar](Observation-Observation-TravelHistory-Madagaskar.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/AllergyInfoUnknown](AllergyIntolerance-AllergyInfoUnknown.md)...Show 76 more,[AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md),[AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md),[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md),[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md),[Bundle/1c794aff-876a-41bf-9401-fa8fee3b1e57](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md),[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZConsentCategory](ValueSet-cz-consent-category.md),[CZProvisionCode](ValueSet-cz-provision-code.md),[CZ_CompositionHdr](StructureDefinition-cz-composition-hdr.md),[CZ_CompositionObligationsHdr](StructureDefinition-cz-composition-obl-hdr.md),[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[CZ_ConsentHdr](StructureDefinition-cz-consent-hdr.md),[CZ_DeviceUseStatementHdr](StructureDefinition-cz-deviceUseStatement-hdr.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[CZ_FamilyMemberHistoryHdr](StructureDefinition-cz-familyMemberHistory-hdr.md),[CZ_ImmunizationHdr](StructureDefinition-cz-immunization-hdr.md),[CZ_ImmunizationRecommendationHdr](StructureDefinition-cz-immunizationRecommendation-hdr.md),[CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md),[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[CZ_ProcedureHdr](StructureDefinition-cz-procedure-hdr.md),[Composition/701f51d5-78bf-428e-a6b5-349c2614ce07](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md),[Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md),[Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md),[Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md),[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md),[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md),[Device/Device-Pacemaker](Device-Device-Pacemaker.md),[DeviceUseStatement/DeviceUseStatement-Pacemaker](DeviceUseStatement-DeviceUseStatement-Pacemaker.md),[EHDSIConditionPOA](ValueSet-eHDSIConditionPOA.md),[EHDSITreatmentClass](ValueSet-eHDSITreatmentClass.md),[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md),[ExposureAgentHdrVs](ValueSet-exposureAgent-eu-hdr.md),[Goal/620b1120-cece-44b1-89f5-20413054eb1d](Goal-620b1120-cece-44b1-89f5-20413054eb1d.md),[Immunization/3f85726c-ad2f-441b-89ce-10000000001e](Immunization-3f85726c-ad2f-441b-89ce-10000000001e.md),[Immunization/Immunization-CovidExample](Immunization-Immunization-CovidExample.md),[ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md),[MedicationStatement/47472c99-09bf-4007-bfaa-16c9665ae090](MedicationStatement-47472c99-09bf-4007-bfaa-16c9665ae090.md),[MedicationStatement/bf08b62b-0abd-4e88-9092-ce0228382e51](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.md),[MedicationStatement/f34114fc-138f-4bd8-8e1a-804d14ec9986](MedicationStatement-f34114fc-138f-4bd8-8e1a-804d14ec9986.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001c](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001d](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/3f85726c-ad2f-441b-89ce-100000000022](Observation-3f85726c-ad2f-441b-89ce-100000000022.md),[Observation/3f85726c-ad2f-441b-89ce-100000000023](Observation-3f85726c-ad2f-441b-89ce-100000000023.md),[Observation/3f85726c-ad2f-441b-89ce-100000000024](Observation-3f85726c-ad2f-441b-89ce-100000000024.md),[Observation/3f85726c-ad2f-441b-89ce-100000000025](Observation-3f85726c-ad2f-441b-89ce-100000000025.md),[Observation/3f85726c-ad2f-441b-89ce-100000000027](Observation-3f85726c-ad2f-441b-89ce-100000000027.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md),[Observation/ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md),[Observation/ExampleSdohSmoking](Observation-ExampleSdohSmoking.md),[Observation/Observation-Education-level](Observation-Observation-Education-level.md),[Observation/e15aeeaf-e288-404c-9704-9c8f0b2d4e3a](Observation-e15aeeaf-e288-404c-9704-9c8f0b2d4e3a.md),[PractitionerRole/2b7e9637-5018-4542-9faf-d5abdee7b849](PractitionerRole-2b7e9637-5018-4542-9faf-d5abdee7b849.md),[PractitionerRole/69d34ceb-b556-4f75-9e4c-9184fe8a10c5](PractitionerRole-69d34ceb-b556-4f75-9e4c-9184fe8a10c5.md),[PractitionerRole/Practitioner-Referrer-detail](PractitionerRole-Practitioner-Referrer-detail.md),[PractitionerRole/practitionerrole1](PractitionerRole-practitionerrole1.md),[Procedure/CZ-Procedure-HDR-Example-Acute-appendicitis](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md),[Procedure/ColonoscopyProcedure](Procedure-ColonoscopyProcedure.md),[Procedure/Procedure-Appendectomy](Procedure-Procedure-Appendectomy.md),[Procedure/Procedure-Insert-Pacemaker](Procedure-Procedure-Insert-Pacemaker.md),[Procedure/Procedure-Insert-Pacemaker2](Procedure-Procedure-Insert-Pacemaker2.md),[Procedure/ffb1a62f-9050-4e33-af4b-4cdb8203c9e5](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md)and[Specimen/Specimen-EDTA-1](Specimen-Specimen-EDTA-1.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Admit source](http://terminology.hl7.org/6.5.0/CodeSystem-admit-source.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 5 more,[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)and[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/AllergyInfoUnknown](AllergyIntolerance-AllergyInfoUnknown.md)...Show 6 more,[AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md),[AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md),[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md),[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)and[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/6cf80cb1-9766-470f-ac36-b1d3d8950f1b](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md), [AllergyIntolerance/MilkAllergy](AllergyIntolerance-MilkAllergy.md)...Show 5 more,[AllergyIntolerance/NoKnownAllergy](AllergyIntolerance-NoKnownAllergy.md),[AllergyIntolerance/PenicillinAllergy](AllergyIntolerance-PenicillinAllergy.md),[AllergyIntolerance/StrawberryAllergy](AllergyIntolerance-StrawberryAllergy.md),[Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)and[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)
* [Condition Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-category.html): [Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md), [Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md)...Show 8 more,[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md)and[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 15 more,[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md),[Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md),[Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md),[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)and[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 15 more,[CZ_ConditionHdr](StructureDefinition-cz-condition-hdr.md),[Condition/35717696-8a99-4f99-a938-ec0ec88a65a2](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md),[Condition/AngiodysplasiaCondition](Condition-AngiodysplasiaCondition.md),[Condition/AtrialFibrillationCondition](Condition-AtrialFibrillationCondition.md),[Condition/CZ-Condition-HDR-Example](Condition-CZ-Condition-HDR-Example.md),[Condition/CZ-Condition-HDR-Example-2](Condition-CZ-Condition-HDR-Example-2.md),[Condition/CZ-Condition-HDR-Example-3](Condition-CZ-Condition-HDR-Example-3.md),[Condition/HypercholesterolemiaCondition](Condition-HypercholesterolemiaCondition.md),[Condition/HypothyroidismCondition](Condition-HypothyroidismCondition.md),[Condition/IronDeficiencyAnemiaCondition](Condition-IronDeficiencyAnemiaCondition.md),[Condition/OsteoporosisCondition](Condition-OsteoporosisCondition.md),[Condition/PresbycusisCondition](Condition-PresbycusisCondition.md),[Condition/TIACondition](Condition-TIACondition.md),[Condition/VaricoseVeinsCondition](Condition-VaricoseVeinsCondition.md)and[Condition/fdf9e92d-ac48-4706-b15b-d2eaca85f45f](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md)
* [Consent Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-consentcategorycodes.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md) and [Consent/CZ-AdvanceDirectives-HDR-DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md)
* [Consent Scope Codes](http://terminology.hl7.org/6.5.0/CodeSystem-consentscope.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md) and [Consent/CZ-AdvanceDirectives-HDR-DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md)
* [Diagnosis Role](http://terminology.hl7.org/6.5.0/CodeSystem-diagnosis-role.html): [Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [Discharge disposition](http://terminology.hl7.org/6.5.0/CodeSystem-discharge-disposition.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 5 more,[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)and[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [Immunization Recommendation Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-immunization-recommendation-status.html): [ImmunizationRecommendation/ImmunizationRecommendation](ImmunizationRecommendation-ImmunizationRecommendation.md)
* [Location type](http://terminology.hl7.org/6.5.0/CodeSystem-location-physical-type.html): [Nemocnice Chrudim - Oddělení CHIR-JIP](Location-cz-Location-Chrudim-ChirJIP.md), [Nemocnice Chrudim - Oddělení CHIR1](Location-cz-Location-Chrudim-Chir1.md)...Show 5 more,[Nemocnice Praha](Location-example-cz-location.md),[Nemocnice Praha - Klinika Chirurgie](Location-Location-5.md),[Nemocnice Praha - Oddělení A](Location-sample-cz-location-2.md),[Nemocnice Praha - Oddělení B](Location-sample-cz-location-3.md)and[Nemocnice Praha - Oddělení C](Location-sample-cz-location-4.md)
* [Medication request administration location codes](http://terminology.hl7.org/6.5.0/CodeSystem-medicationrequest-admin-location.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md), [MedicationStatement/47472c99-09bf-4007-bfaa-16c9665ae090](MedicationStatement-47472c99-09bf-4007-bfaa-16c9665ae090.md), [MedicationStatement/bf08b62b-0abd-4e88-9092-ce0228382e51](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.md) and [MedicationStatement/f34114fc-138f-4bd8-8e1a-804d14ec9986](MedicationStatement-f34114fc-138f-4bd8-8e1a-804d14ec9986.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 22 more,[CZ_ObservationSdohHdr](StructureDefinition-cz-observation-sdoh-hdr.md),[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001c](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md),[Observation/3f85726c-ad2f-441b-89ce-10000000001d](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/3f85726c-ad2f-441b-89ce-100000000022](Observation-3f85726c-ad2f-441b-89ce-100000000022.md),[Observation/3f85726c-ad2f-441b-89ce-100000000023](Observation-3f85726c-ad2f-441b-89ce-100000000023.md),[Observation/3f85726c-ad2f-441b-89ce-100000000024](Observation-3f85726c-ad2f-441b-89ce-100000000024.md),[Observation/3f85726c-ad2f-441b-89ce-100000000025](Observation-3f85726c-ad2f-441b-89ce-100000000025.md),[Observation/3f85726c-ad2f-441b-89ce-100000000027](Observation-3f85726c-ad2f-441b-89ce-100000000027.md),[Observation/4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md),[Observation/5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md),[Observation/5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md),[Observation/6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md),[Observation/6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md),[Observation/7cf304de-5ae3-4621-8531-9c8f0b2d4e3a](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md),[Observation/8d2aea77-f576-4d0f-9508-537359aa44d6](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md),[Observation/CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md),[Observation/ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md),[Observation/ExampleSdohSmoking](Observation-ExampleSdohSmoking.md),[Observation/Observation-Education-level](Observation-Observation-Education-level.md)and[Observation/e15aeeaf-e288-404c-9704-9c8f0b2d4e3a](Observation-e15aeeaf-e288-404c-9704-9c8f0b2d4e3a.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [CZ_RelatedPersonHdr](StructureDefinition-cz-relatedPerson-hdr.md), [CZ_RelatedPersonObligationsHdr](StructureDefinition-cz-relatedPerson-obl-hdr.md) and [Patient/Mracena2](Patient-Mracena2.md)
* [ActClass](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActClass.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md), [CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md) and [Observation/Observation-InfectiousContact](Observation-Observation-InfectiousContact.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/1c794aff-876a-41bf-9401-fa8fee3b1e57](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md), [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)...Show 9 more,[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md),[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md),[Encounter/HospitalEncounter](Encounter-HospitalEncounter.md)and[Encounter/f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md)
* [ActPriority](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActPriority.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 6 more,[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)and[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md)
* [Education Level](http://terminology.hl7.org/6.5.0/CodeSystem-v3-EducationLevel.html): [Observation/Observation-Education-level](Observation-Observation-Education-level.md)
* [ObservationInterpretation](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ObservationInterpretation.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md)...Show 7 more,[Observation/10f5c49e-086d-4016-8dd1-10000000001b](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md),[Observation/3f85726c-ad2f-441b-89ce-100000000021](Observation-3f85726c-ad2f-441b-89ce-100000000021.md),[Observation/hb-result](Observation-hb-result.md),[Observation/hct-result](Observation-hct-result.md),[Observation/plt-result](Observation-plt-result.md),[Observation/rbc-result](Observation-rbc-result.md)and[Observation/wbc-result](Observation-wbc-result.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [Bundle/1c794aff-876a-41bf-9401-fa8fee3b1e57](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md), [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md)...Show 12 more,[Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md),[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_EncounterHdr](StructureDefinition-cz-encounter-hdr.md),[CZ_EncounterObligationsHdr](StructureDefinition-cz-encounter-obl-hdr.md),[CZ_ObservationInfectiousContactHdr](StructureDefinition-cz-observation-infectious-contact-hdr.md),[Encounter/10f5c49e-086d-4016-8dd1-b555306bf620](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md),[Encounter/CZ-Encounter-HDR-Example](Encounter-CZ-Encounter-HDR-Example.md),[Observation/Observation-InfectiousContact](Observation-Observation-InfectiousContact.md),[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab.md)and[Provenance/cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [Bundle/DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md), [Bundle/DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md)...Show 7 more,[Bundle/DischargeBundle-Novak-Petr-L1-Signed](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md),[Bundle/DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md),[Bundle/DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md),[CZ_RelatedPersonHdr](StructureDefinition-cz-relatedPerson-hdr.md),[Patient/3f85726c-ad2f-441b-89ce-100000000000](Patient-3f85726c-ad2f-441b-89ce-100000000000.md),[Patient/Mracena2](Patient-Mracena2.md)and[RelatedPersonRelationshipTypesHDR](ValueSet-relatedPersonRelationshipTypes-eu-hdr.md)


 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

