# Artifacts - HL7 Czech Hospital Discharge Report Implementation Guide v0.0.2

* [**Table of Contents**](toc.md)
* **Artifacts**

HL7 Czech Hospital Discharge Report Implementation Guide, published by HL7 Czech Republic. This guide is not an authorized publication; it is the continuous build for version 0.0.2 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7-cz/hdr/](https://github.com/HL7-cz/hdr/) and changes regularly. See the [Directory of published versions](https://hl7.cz/fhir/hdr/history.html)

## Artifacts

Contents:

*  [Actors](#1) 
*  [Obligations](#2) 
*  [Czech logical model](#3) 
*  [Structures: Logical Models](#4) 
*  [Structures: Resource Profiles](#5) 
*  [Terminology: Value Sets](#6) 
*  [Terminology: Code Systems](#7) 
*  [Terminology: Concept Maps](#8) 
*  [Example: Example Instances](#9) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Actors 

Actors used to describe the HDR functional requirements for the specified data elements. Informative for this version of the guide.

| | |
| :--- | :--- |
| [Actor HDR Consumer L1](ActorDefinition-actor-consumer-hdr-L1.md) | HDR Consumer: a system receiving/querying and using a HDR. |
| [Actor HDR Consumer L2](ActorDefinition-actor-consumer-hdr-L2.md) | HDR Consumer: a system receiving/querying and using a HDR. |
| [Actor HDR Consumer L3](ActorDefinition-actor-consumer-hdr-L3.md) | HDR Consumer: a system receiving/querying and using a HDR. |
| [Actor HDR Creator L1](ActorDefinition-actor-creator-hdr-L1.md) | HDR Creator: a system generating and sending/providing a HDR to a Consumer for report storage and sharing. |
| [Actor HDR Creator L2](ActorDefinition-actor-creator-hdr-L2.md) | HDR Creator: a system generating and sending/providing a HDR to a Consumer for report storage and sharing. |
| [Actor HDR Creator L3](ActorDefinition-actor-creator-hdr-L3.md) | HDR Creator: a system generating and sending/providing a HDR to a Consumer for report storage and sharing. |

### Obligations 

Obligations used to describe the HDR functional requirements for the specified data elements. Informative for this version of the guide.

| | |
| :--- | :--- |
| [Address Obligations (HDR CZ)](StructureDefinition-cz-address-obl-hdr.md) | Obligations for Address in Czech Republic - HDR |
| [Allergy Intolerance Obligations (HDR CZ)](StructureDefinition-cz-allergyintolerance-obl-hdr.md) | This profile defines the obligations for the CZ_AllergyIntoleranceHdr profile used in the HDR CZ project. |
| [Attachments: Obligations](StructureDefinition-cz-attachment-obl-hdr.md) | This profile defines obligations for an attachment in FHIR for the purpose of this guide. |
| [Composition: Obligations](StructureDefinition-cz-composition-obl-hdr.md) | This profile defines obligations for a composition in FHIR for the purpose of this guide. |
| [Consent Obligations (HDR CZ)](StructureDefinition-cz-consent-obl-hdr.md) | This profile defines the obligations for the CZ_ConsentHdr profile used in the HDR CZ project. |
| [Dosage: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-dosage-hospitalstay-obl-hdr.md) | Profile for Dosage with obligations (HDR CZ) - hospital stay. |
| [Dosage: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-dosage-medicationsummary-obl-hdr.md) | Profile for Dosage with obligations (HDR CZ) - medication summary. |
| [Encounter: Obligations](StructureDefinition-cz-encounter-obl-hdr.md) | This profile defines obligations for an Encounter in FHIR for the purpose of this guide. |
| [Flag Obligations (HDR CZ)](StructureDefinition-cz-flag-obl-hdr.md) | This profile defines the obligations for the CZ_FlagHdr profile used in the HDR CZ project. |
| [Immunization Obligations: HDR CZ](StructureDefinition-cz-immunization-obl-hdr.md) | Profile for Immunization Obligations in the Czech Republic Health Data Repository (HDR CZ). |
| [Immunization Recommendation Obligations (HDR CZ)](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md) | This profile defines the obligations for the ImmunizationRecommendation resource used in the HDR CZ project. |
| [Medication Administration Obligations (HDR CZ)](StructureDefinition-cz-medicationadministration-obl-hdr.md) | Profile for Medication Administration Obligations in the Czech Republic Health Data Repository (HDR CZ). |
| [Medication Obligations: (HDR CZ) - hospital stay](StructureDefinition-cz-medication-hospitalstay-obl-hdr.md) | Profile for Medication Obligations in the Czech Republic Health Data Repository (HDR CZ). - hospital stay. |
| [Medication Obligations: (HDR CZ) - medication summary](StructureDefinition-cz-medication-medicationsummary-obl-hdr.md) | Profile for Medication Obligations in the Czech Republic Health Data Repository (HDR CZ). - medication summary. |
| [MedicationDispense: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationdispens-hospitalstay-obl-hdr.md) | Profile for MedicationDispense with obligations (HDR CZ). - hospital stay. |
| [MedicationDispense: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationdispens-medicationsummary-obl-hdr.md) | Profile for MedicationDispense with obligations (HDR CZ). - medication summary. |
| [MedicationRequest: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md) | Profile for MedicationRequest with obligations (HDR CZ) - hospital stay. |
| [MedicationRequest: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md) | Profile for MedicationRequest with obligations (HDR CZ) - medication summary. |
| [MedicationStatement: Obligations (HDR CZ)](StructureDefinition-cz-medicationstatement-obl-hdr.md) | Profile for MedicationStatement with obligations (HDR CZ). |
| [Observations: Anthropometric Data obligations](StructureDefinition-cz-observation-anthropometricdata-obl-hdr.md) | This profile defines obligations for an Anthropometric Data in FHIR for the purpose of this guide. |
| [Observations: Infectious Contact obligations](StructureDefinition-cz-observation-ic-obl-hdr.md) | This profile defines obligations for an Infectious Contact in FHIR for the purpose of this guide. |
| [Organization: Obligations](StructureDefinition-cz-organization-obl-hdr.md) | This profile defines obligations for. |
| [Patient: Obligations](StructureDefinition-cz-patient-obl-hdr.md) | This profile defines obligations for an human Patient in FHIR for the purpose of this guide. |
| [Procedure: Obligations](StructureDefinition-cz-procedure-obl-hdr.md) | This profile defines obligations for a procedure in FHIR for the purpose of this guide. |

### Czech logical model 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md) | Nemocniční propouštěcí zpráva |
| [A.1 – Hlavička dokumentu](StructureDefinition-LogHeaderHdrCz.md) | Nemocniční propouštěcí zpráva - Struktura hlavičky propouštěcí zprávy podle tabulky části. |
| [A.1.1 - Identifikace a A.1.2 - informace o pacientovi](StructureDefinition-LogSubjectCz.md) | Nemocniční propouštěcí zpráva - Informace o pacientovi. |
| [A.1.9 - Digitální podpis](StructureDefinition-LogdigitalSignatureCz.md) | Nemocniční propouštěcí zpráva - Elektronický podpis dle zákona 327/2011 §54a |
| [A.2.1 - Dříve vyslovená přání (cz)](StructureDefinition-LogAdvanceDirectivesCz.md) | Nemocniční propouštěcí zpráva - Dříve vyslovená přání |
| [A.2.2 - Urgentní informace (cz)](StructureDefinition-LogAlertsCz.md) | Nemocniční propouštěcí zpráva - Urgentní informace |
| [A.2.3 - Kontakt se zdravotními službami](StructureDefinition-LogInPatientEncounterCz.md) | Nemocniční propouštěcí zpráva - Záznam o hospitalizačním kontaktu v rámci propouštěcí zprávy. |
| [A.2.4 - Stav při přijetí (cz)](StructureDefinition-LogAdmissionEvaluationCz.md) | Nemocniční propouštěcí zpráva - Stav při přijetí - A.2.4 CZ poznámka: Nepovinná sekce uvádět pouze v případě významu pro zajištění kontinuity péče. |
| [A.2.6 - Anamnéza](StructureDefinition-LogPatientHistoryCz.md) | Nemocniční propouštěcí zpráva - Anamnéza |
| [A.2.7 - Průběh hospitalizace](StructureDefinition-LogDischargeDetailsCz.md) | Nemocniční propouštěcí zpráva - Průběh hospitalizace |
| [A.2.7 Průběh hospitalizace](StructureDefinition-LogHospitalStayCz.md) | Nemocniční propouštěcí zpráva - Popis průběhu hospitalizace zahrnující diagnostické souhrny, výkony, léčbu, vyšetření i klinické shrnutí. |
| [A.2.8.1 Objektivní nález](StructureDefinition-LogCzObjectiveFindingsCz.md) | Nemocniční propouštěcí zpráva - Objektivní nález pacienta při propuštění. |
| [A.2.8.2 - Funkční stav při propuštění](StructureDefinition-LogFunctionalStatusCz.md) | Nemocniční propouštěcí zpráva - Hodnocení funkčního stavu pacienta při propuštění. |
| [A.2.9.1 Plán péče](StructureDefinition-LogPlanOfCareCz.md) | Nemocniční propouštěcí zpráva - Plán péče po propuštění. |
| [A.2.9.2 Souhrn medikace](StructureDefinition-LogMedicationSummaryCz.md) | Nemocniční propouštěcí zpráva - Souhrnná informace o medikaci doporučené na období po propuštění, včetně medikace změněné, nově zahájené nebo ukončené. |
| [A.3 - Vizuální podoba dokumentu](StructureDefinition-LogPresentedFormCz.md) | Nemocniční propouštěcí zpráva - čitelná lidským okem, je požadován PDF formát. Obsahuje informace o průběhu hospitalizace v rozsahu vydané zprávy. |
| [A.4 - Přílohy (cz)](StructureDefinition-LogAttachmentsCz.md) | Nemocniční propouštěcí zpráva - Přílohy |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReportCz.md) | Hospital Discharge Report |
| [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md) | Hospital Discharge Report - Hospital Discharge Report header data element - A.1 eHN |
| [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) | Hospital Discharge Report - Hospital Discharge Report subject data element - A.1.1 and A.1.2 eHN |
| [A.1.9 - Digital signature](StructureDefinition-digitalSignatureCz.md) | Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [A.2.1 - Advance Directives (eHN)](StructureDefinition-AdvanceDirectivesCz.md) | Hospital Discharge Report - Advance Directives - A.2.1 eHN |
| [A.2.2 - Alerts (eHN)](StructureDefinition-AlertsCz.md) | Hospital Discharge Report - Alerts - A.2.2 eHN |
| [A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md) | Hospital Discharge Report - Encounter - A.2.3 eHN |
| [A.2.4 - Admission evaluation (eHN)](StructureDefinition-AdmissionEvaluationEhnEn.md) | Hospital Discharge Report - Admission evaluation - A.2.4 eHN |
| [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md) | Hospital Discharge Report - Patient history - A.2.5 eHN |
| [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md) | Hospital Discharge Report - Hospital stay - A.2.6 eHN |
| [A.2.7 - Discharge details (eHN)](StructureDefinition-DischargeDetailsCz.md) | Hospital Discharge Report - Discharge details - A.2.7 eHN |
| [A.2.7.1 - Objective findings](StructureDefinition-ObjectiveFindingsCz.md) | Hospital Discharge Report - Objective Findings- A.2.7.1 eHN |
| [A.2.8.1 - Care plan](StructureDefinition-PlanOfCareCz.md) | Hospital Discharge Report - Care plan after discharge - A.2.8.1 eHN |
| [A.2.8.2 - Functional status](StructureDefinition-FunctionalStatusCz.md) | Hospital Discharge Report - Functional status - A.2.8.2 eHN |
| [A.2.8.2 - Medication summary](StructureDefinition-MedicationSummaryCz.md) | Hospital Discharge Report - Medication Summary after discharge - A.2.8.2 eHN |
| [A.3 - Presented form](StructureDefinition-PresentedFormCz.md) | Presented form - Entire report as issued. Various formats could be provided, pdf format is recommended. |
| [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md) | Discharge Report - additional attachments - A.4 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Allergy Intolerance (HDR CZ)](StructureDefinition-cz-allergyIntolerance-hdr.md) | This profile constrains the AllergyIntolerance resource for the purpose of this project. |
| [Attachment: HDR (CZ)](StructureDefinition-cz-attachment-hdr.md) | Czech profile for attachment. |
| [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md) | Clinical document used to represent a Hospital Discharge Report for the scope of this guide. |
| [Care Plan (HDR CZ)](StructureDefinition-cz-carePlan-hdr.md) | This profile constrains the CarePlan resource for the purpose of this guide. |
| [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md) | This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. |
| [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md) | This profile represents the constraint applied to the Condition in the scope of this guide. It supports the Diagnostic summary part of the eHN data model adding two additional categories: First category distinguishes conditions present at admission and acquired during hospital stay, while second category is used to indicate impact of the condition to the treatment during hospital stay (treated, untreated). |
| [Consent (Advance Directives) (HDR CZ)](StructureDefinition-cz-consent-hdr.md) | This profile constrains the Consent resource for the purpose of representing Advance Directives in this project. |
| [Coverage: Obligations](StructureDefinition-cz-coverage-obl-hdr.md) | This profile defines obligations for a coverage in FHIR for the purpose of this guide. |
| [DeviceUseStatement (HDR)](StructureDefinition-cz-deviceUseStatement-hdr.md) | This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. |
| [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md) | This profile defines how to represent Inpatient Encounter in HL7 FHIR for the scope of this guide. |
| [FamilyMemberHistory (HDR CZ)](StructureDefinition-cz-familyMemberHistory-hdr.md) | This profile represents the constraints applied to the FamilyMemberHistory resource by this guide. |
| [Flag (HDR CZ)](StructureDefinition-cz-flag-hdr.md) | This profile constrains the Flag resource to represent alerts or warnings in FHIR for the purpose of this project. |
| [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md) | This profile constrains the Immunization resource for the purpose of this guide. |
| [ImmunizationRecommendation (CZ HDR)](StructureDefinition-cz-immunizationRecommendation-hdr.md) | This profile defines how to represent Immunization Recommandations for the purpose of this guide. |
| [Medical Device: Obligations](StructureDefinition-cz-medicalDevice-obl-hdr.md) | This profile defines obligations for a medical device result in FHIR for the purpose of this guide. |
| [MedicationDispense (HDR)](StructureDefinition-cz-medicationDispense-hdr.md) | This profile constrains the MedicationDispense resource for the purpose of this guide, adapted from the MPD work. |
| [MedicationRequest (HDR CZ)](StructureDefinition-cz-medicationRequest-hdr.md) | This profile constrains the MedicationRequest resource for the purpose of this guide, adapted from the MPD work. |
| [Observation: Anthropometric Data (HDR CZ)](StructureDefinition-cz-observation-weight-hdr.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference. |
| [Observation: Anthropometric Data (HDR CZ) - Abdominal Circumference](StructureDefinition-cz-observation-abdominalCircumference-hdr.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference. |
| [Observation: Anthropometric Data (HDR CZ) - BMI](StructureDefinition-cz-observation-BMI-hdr.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference. |
| [Observation: Anthropometric Data (HDR CZ) - Chest Circumference](StructureDefinition-cz-observation-chestCircumference-hdr.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference. |
| [Observation: Anthropometric Data (HDR CZ) - Head Circumference](StructureDefinition-cz-observation-headCircumference-hdr.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference. |
| [Observation: Anthropometric Data (HDR CZ) - Height](StructureDefinition-cz-observation-height-hdr.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch anthropometric measurements such as height, weight, BMI, and optional measurements like head, chest, and abdominal circumference. |
| [Observation: Infectious Contact (HDR CZ)](StructureDefinition-cz-observation-infectious-contact-hdr.md) | Infectious Contact profile represents potential patient exposure to an agent (exposure source). |
| [Observation: SDOH (HDR CZ)](StructureDefinition-cz-observation-sdoh-hdr.md) | Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation). |
| [Observation: travel history (HDR CZ)](StructureDefinition-cz-observation-travel-hdr.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch travel history. |
| [Practitioner Role: Obligations](StructureDefinition-cz-practitionerRole-obl-hdr.md) | This profile defines obligations for a practitioner role in FHIR for the purpose of this guide. |
| [Practitioner: Obligations](StructureDefinition-cz-practitioner-obl-hdr.md) | This profile defines obligations for a practitioner in FHIR for the purpose of this guide. |
| [Procedure (HDR CZ)](StructureDefinition-cz-procedure-hdr.md) | This profile represents the constraints applied to the Procedure resource by this guide. |
| [Related Person: HDR (CZ)](StructureDefinition-cz-relatedPerson-hdr.md) | Czech profile for related person. |
| [Related Person: Obligations](StructureDefinition-cz-relatedPerson-obl-hdr.md) | This profile defines obligations for a related person in FHIR for the purpose of this guide. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CZ Consent Category](ValueSet-cz-consent-category.md) | ValueSet for Consent Categories in the Czech HDR project. |
| [CZ Provision Code](ValueSet-cz-provision-code.md) | ValueSet for provision codes in the Czech HDR project, using ICD-10 and Orphacode. |
| [Exposure of transmissible agents](ValueSet-exposureAgent-eu-hdr.md) | HDR exposure agent value set. This value set includes codes from SNOMED Clinical Terms®: all descendants of 40733004 "Infectious disease (disorder)" and ICD-10 all descendants of chapter I: "Certain infectious and parasitic diseases" |
| [Related Person Relationship Types (HDR)](ValueSet-relatedPersonRelationshipTypes-eu-hdr.md) | HDR related person relationship types value set. |
| [eHDSI Condition Present On Admission](ValueSet-eHDSIConditionPOA.md) | The Value Set is used to assert if a condition is Present on Admission |
| [eHDSI Treatment Class](ValueSet-eHDSITreatmentClass.md) | The Value set is used to encode category of treatment of the condition during encounter |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Temporary HDR Code System](CodeSystem-temporarySystem-hdr-cz.md) | This is a temporary code system defined to collect concepts expected required by this project, but for which international coded concepts have not been identified yet. |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Advance Directives Model to this guide Map](ConceptMap-advanceDirectives2FHIR-cz-hdr.md) | eHN HDR Advance Directives Model to this guide mapping |
| [CZ Alerts Model to this guide Map](ConceptMap-alerts2FHIR-cz-hdr.md) | eHN HDR Alerts Model to this guide mapping |
| [CZ Attachment Model to this guide Map](ConceptMap-AttachmentHDR2FHIR-cz.md) | CZ HDR Attachment Model to this guide mapping |
| [CZ HDR Model to this guide Map](ConceptMap-hdr2FHIR-cz-hdr.md) | CZ Hospital Discharge Report Model to this guide mapping |
| [CZ Header Model to this guide Map](ConceptMap-hdrHeader2FHIR-cz-hdr.md) | CZ HDR Header Model to this guide mapping |
| [CZ Patient History to this guide Map](ConceptMap-patientHistory2FHIR-cz-hdr.md) | CZ HDR Patient History Model to this guide Map |
| [eHN Encounter Model to this guide Map](ConceptMap-encounter2FHIR-cz-hdr.md) | eHN HDR Encounter Model to this guide mapping |
| [eHN Functional Status Model to this guide Map](ConceptMap-functionalStatus2FHIR-hdr-cz.md) | eHN HDR Functional Status Model to this guide Map |
| [eHN Hospital Stay Model to this guide Map](ConceptMap-hospitalStay2FHIR-cz-hdr.md) | eHN HDR Hospital Stay Model to this guide Map |
| [eHN Medication Summary Model to this guide Map](ConceptMap-medicationSummary2FHIR-cz-hdr.md) | eHN HDR Medication Summary Model to this guide Map |
| [eHN Objective Findings Model to this guide Map](ConceptMap-objectiveFindings2FHIR-hdr-cz.md) | eHN HDR Objective Findings Model to this guide Map |
| [eHN Plan of Care Model to this guide Map](ConceptMap-planOfCare2FHIR-cz-hdr.md) | eHN HDR Plan of Care Model to this guide Map |
| [eHN Subject Model to this guide Map](ConceptMap-subject2FHIR-cz-hdr.md) | eHN HDR Subject Model to this guide mapping |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AdvanceDirectives DNR](Consent-CZ-AdvanceDirectives-HDR-DNR.md) | Czech hdr - example od advance directive |
| [Allergy Information Unknown](AllergyIntolerance-AllergyInfoUnknown.md) | No information is available regarding the patient’s allergy status. |
| [AllergyIntolerance - No Known Allergies](AllergyIntolerance-NoKnownAllergy.md) | Patient has no known allergies. |
| [AllergyIntolerance - Penicillin](AllergyIntolerance-PenicillinAllergy.md) | Patient experiences skin rash and lip swelling in response to penicillin. |
| [AllergyIntolerance - Strawberry](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md) | Patient experiences itching and tongue swelling in response to strawberries. |
| [AllergyIntolerance - Strawberry](AllergyIntolerance-StrawberryAllergy.md) | Patient experiences itching and tongue swelling in response to strawberries. |
| [AllergyIntolerance - cow's milk protein](AllergyIntolerance-MilkAllergy.md) | Patient experiences rash and itching after ingestion of cow's milk protein due to intolerance. |
| [Ambulance interního lékařství, MUDr. Jiří Zdvořilý](Organization-Organization-Referrer.md) | Example of ambulatory physician |
| [CRP - Novák Petr](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md) | Czech HDR - example of CRP observation for Novák Petr |
| [CZ-CarePlan-HDR Example](CarePlan-CZ-CarePlan-HDR-Example.md) | Czech HDR - example of a care plan |
| [CZ-Condition-HDR Angiodysplasia](Condition-AngiodysplasiaCondition.md) | Example of a condition Angiodysplasia of colon |
| [CZ-Condition-HDR Atrial Fibrillation](Condition-AtrialFibrillationCondition.md) | Example of a condition Persistent atrial fibrillation |
| [CZ-Condition-HDR Example](Condition-CZ-Condition-HDR-Example.md) | Czech HDR - example of a condition (Heart Failure) |
| [CZ-Condition-HDR Example 2](Condition-CZ-Condition-HDR-Example-2.md) | Czech HDR - example of a condition (Cardiac arrhythmia - Brugada Syndrome) |
| [CZ-Condition-HDR Example 3](Condition-CZ-Condition-HDR-Example-3.md) | Czech HDR - example of a condition (Postoperative Hypothyroidism) |
| [CZ-Condition-HDR Example 3](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md) | Czech HDR - example of a condition (Postoperative Hypothyroidism) |
| [CZ-Condition-HDR Example K409](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md) | Example of a condition K409 with details on admission |
| [CZ-Condition-HDR Hypercholesterolemia](Condition-HypercholesterolemiaCondition.md) | Example of a condition Pure hypercholesterolaemia |
| [CZ-Condition-HDR Hypothyroidism](Condition-HypothyroidismCondition.md) | Example of a condition Hypothyroidism |
| [CZ-Condition-HDR Iron Deficiency Anemia](Condition-IronDeficiencyAnemiaCondition.md) | Example of a condition Iron deficiency anaemia secondary to blood loss (chronic) |
| [CZ-Condition-HDR Osteoporosis](Condition-OsteoporosisCondition.md) | Example of a condition Postmenopausal osteoporosis |
| [CZ-Condition-HDR Presbycusis](Condition-PresbycusisCondition.md) | Example of a condition Presbycusis |
| [CZ-Condition-HDR TIA](Condition-TIACondition.md) | Example of a condition Transient cerebral ischaemic attack, unspecified |
| [CZ-Condition-HDR Varicose Veins](Condition-VaricoseVeinsCondition.md) | Example of a condition Varicose veins of lower extremities without ulcer or inflammation |
| [CZ-Encounter-HDR Example](Encounter-CZ-Encounter-HDR-Example.md) | Czech HDR - example of an inpatient encounter |
| [CZ-Encounter-HDR Example of encounter for Novak Petr](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md) | Czech HDR - example of encounter for Novak Petr |
| [CZ-Encounter-HDR Example of encounter with emergency priority](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md) | Czech HDR - example of encounter with emergency priority |
| [CZ-Encounter-HDR Example of finished hospital encounter](Encounter-HospitalEncounter.md) | Czech HDR - example of finished hospital encounter |
| [CZ-MedicationStatement-HDR Example of Atorvastatin](MedicationStatement-AtorvastatinMedication.md) | Czech HDR - example of Atorvastatin |
| [CZ-MedicationStatement-HDR Example of Bisoprolol](MedicationStatement-BisoprololMedication.md) | Czech HDR - example of Bisoprolol |
| [CZ-MedicationStatement-HDR Example of Calcium D3](MedicationStatement-CalciumD3Medication.md) | Czech HDR - example of Calcium D3 |
| [CZ-MedicationStatement-HDR Example of Euthyrox](MedicationStatement-47472c99-09bf-4007-bfaa-16c9665ae090.md) | Czech HDR - example of Euthyrox |
| [CZ-MedicationStatement-HDR Example of Ibalgin](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.md) | Czech HDR - example of Ibalgin 400 |
| [CZ-MedicationStatement-HDR Example of Iron Supplement](MedicationStatement-IronSupplementMedication.md) | Czech HDR - example of Iron Supplement |
| [CZ-MedicationStatement-HDR Example of Levothyroxine](MedicationStatement-LevothyroxineMedication.md) | Czech HDR - example of Levothyroxine sodium |
| [CZ-MedicationStatement-HDR Example of Paracetamol](MedicationStatement-f34114fc-138f-4bd8-8e1a-804d14ec9986.md) | Czech HDR - example of Paracetamol |
| [CZ-MedicationStatement-HDR Example of Rivaroxaban](MedicationStatement-RivaroxabanMedication.md) | Czech HDR - example of Rivaroxaban |
| [CZ-Procedure-HDR Example - Acute appendicitis](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md) | Czech HDR - example of a Procedure - Acute appendicitis. |
| [CZ-Procedure-HDR Example - Appendectomy](Procedure-Procedure-Appendectomy.md) | Czech HDR - example of a Procedure - Appendectomy |
| [CZ-Procedure-HDR Example - Colonoscopy](Procedure-ColonoscopyProcedure.md) | Czech HDR - example of a Procedure - Colonoscopy |
| [CZ-Procedure-HDR Example - Inguinal hernia](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md) | Czech HDR - example of a Procedure - Repair of inguinal hernia |
| [CZ-Procedure-HDR Example - No known procedures](Procedure-Procedure-No-Procedure.md) | Czech HDR - example of a Procedure - No known procedures. |
| [CZ-Procedure-HDR Example - Pacemaker](Procedure-Procedure-Insert-Pacemaker.md) | Czech HDR - example of a Procedure - Pacemaker |
| [CZ-Procedure-HDR Example - Pacemaker](Procedure-Procedure-Insert-Pacemaker2.md) | Czech HDR - example of a Procedure - Pacemaker |
| [CZObservationSdohHdrExample](Observation-CZObservationSdohHdrExample.md) | Example instance for SDOH observation (assessment-based) using CZ_ObservationSdohHdr profile. |
| [Cardiac Arrest Flag](Flag-Flag1.md) | A flag indicating that the patient has a history of cardiac arrest. |
| [CarePlan-Novak-Petr](CarePlan-9c913d06-84fe-4d35-b35b-8b0c7965f535.md) | Czech HDR - example of a care plan |
| [Device-Pacemaker](Device-Device-Pacemaker.md) | Heart pacemaker Medtronic W1DR01 |
| [Discharge Summary Document - Base64](DocumentReference-d9ad8a22-a12b-48db-938c-4066a3a0617a.md) | DocumentReference for discharge summary, base64 encoded HTML |
| [Discharge Summary Document - PDF](DocumentReference-66678621-df93-47ca-a36c-2a39a92472e7.md) | DocumentReference with Base64 PDF content directly inserted |
| [DischargeBundle-Novak-Petr](Bundle-DischargeBundle-Novak-Petr.md) | Example Bundle for Hospital Discharge Report for patient Novák Petr |
| [DischargeBundle-Novak-Petr-L1](Bundle-DischargeBundle-Novak-Petr-L1.md) | Example Bundle for Hospital Discharge Report for patient Novák Petr |
| [DischargeBundle-Novak-Petr-L1-core](Bundle-1c794aff-876a-41bf-9401-fa8fee3b1e57.md) | Example Bundle L1 core for Hospital Discharge Report for patient Novák Petr |
| [DischargeBundle-Novak-Petr-L1-plus](Bundle-DischargeBundle-Novak-Petr-L1-plus.md) | Example Bundle for Hospital Discharge Report for patient Novák Petr |
| [DischargeBundle-Novak-Petr-Subsections](Bundle-DischargeBundle-Novak-Petr-Subsections.md) | Example Bundle for Hospital Discharge Report for patient Novák Petr |
| [Dispense – Euthyrox](Medication-Medication-Euthyrox.md) | Euthyrox v tabletách |
| [Dispense – Euthyrox](MedicationDispense-MedicationDispense-Euthyrox.md) | Výdej léčivého přípravku Euthyrox pacientovi Novákovi |
| [Dispense – Ibalgin 400](MedicationDispense-MedicationDispense-Ibalgin400.md) | Výdej léčivého přípravku Ibalgin 400 mg pacientovi Novákovi |
| [Dispense – Paracetamol](MedicationDispense-MedicationDispense-Paracetamol.md) | Výdej léčivého přípravku Paracetamol pacientovi Novákovi |
| [Dosažený stupeň vzdělání](Observation-Observation-Education-level.md) | Pacient má vysokoškolské vzdělání v oboru informatiky. |
| [Erytrocyty](Observation-rbc-result.md) | Příklad pro HDR - Počet erytrocytů v krvi |
| [Example Czech Location](Location-example-cz-location.md) | Example instance of a location conforming to the CZ_LocationCore profile. |
| [ExampleAbdominalCircumference](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md) | Example instance for abdominal circumference observation using the CZ_ObservationAbdominalCircumferenceHdr profile. |
| [ExampleBMI](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md) | Example instance for BMI observation using the CZ_ObservationBMIHdr profile. |
| [ExampleBloodPressure](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md) | Example instance for blood pressure observation (systolic and diastolic). |
| [ExampleChestCircumference](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md) | Example instance for chest circumference observation using the CZ_ObservationChestCircumferenceHdr profile. |
| [ExampleHeadCircumference](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md) | Example instance for head circumference observation using the CZ_ObservationHeadCircumferenceHdr profile. |
| [ExampleHeight](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md) | Example instance for height observation using the CZ_ObservationHeightHdr profile. |
| [ExampleSdohAlcohol](Observation-ExampleSdohAlcohol.md) | Example of Social History Observation - Alcohol Use |
| [ExampleSdohAlcoholSporadic](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md) | Example of Social History Observation - Alcohol Use |
| [ExampleSdohSmoking](Observation-ExampleSdohSmoking.md) | Example of Social History Observation - Smoking |
| [ExampleSdohSmokingEnded](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md) | Example of Social History Observation - Smoking history |
| [ExampleWeight](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md) | Example instance for weight observation using the CZ_ObservationWeightHdr profile. |
| [Goal for Hernia Treatment](Goal-620b1120-cece-44b1-89f5-20413054eb1d.md) | Czech HDR - example of a goal for hernia treatment |
| [Hematokrit](Observation-hct-result.md) | Příklad pro HDR - Hematokrit v krvi |
| [Hematologická laboratoř Brno](Organization-Lab-HematologieBrno.md) | Referenční laboratoř pro klinickou hematologii |
| [Hemoglobin](Observation-hb-result.md) | Příklad pro HDR - Hladina hemoglobinu v krvi |
| [Hospital Discharge Report - Novák Petr (Signed Bundle)](Bundle-DischargeBundle-Novak-Petr-L1-Signed.md) | Example Signed Bundle for Hospital Discharge Report for patient Novák Petr |
| [Immunization example of Covid](Immunization-3f85726c-ad2f-441b-89ce-10000000001e.md) | Immunization of Covid |
| [Immunization recommendation example](ImmunizationRecommendation-ImmunizationRecommendation.md) | Immunization recommendation of vaccination |
| [Infekční kontakt](Observation-Observation-InfectiousContact.md) | Pacient byl v kontaktu s osobou nakaženou COVID-19 |
| [Koníčky](Observation-3f85726c-ad2f-441b-89ce-100000000024.md) | Pacient aktivně sportuje (jezdí na kole a běhá) a má zájem o fotografování. |
| [Leukocyty](Observation-wbc-result.md) | Příklad pro HDR - Počet leukocytů v krvi |
| [Medication – Covid vaccine](Medication-med-CovidVaccineComirnaty.md) | Lek Covid vakcína |
| [Medication – Ibalgin 400](Medication-med-Ibalgin400.md) | Lek Ibalgin 400 v tabletách |
| [Medication – Paracetamol](Medication-med-paracetamol.md) | Lek Paracetamol v tabletách |
| [Mracena2](Patient-Mracena2.md) | Patient, contact information including registering practitioner |
| [Observation - Travel History](Observation-Observation-TravelHistory-Madagaskar.md) | Travel history observation |
| [Organization-1](Organization-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169.md) | An example of the organization of a provider |
| [Organization-L1](Organization-9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1.md) | An example of the organization of a provider |
| [Organization: Registering healthcare provider example](Organization-RegisteringProviderExample.md) | Example of registering healthcare provider |
| [Organization: Registering healthcare provider example](Organization-RegisteringProviderExample-gynecology.md) | Example of registering healthcare provider |
| [Očkování Covid](Immunization-Immunization-CovidExample.md) | Očkování proti COVID-19 u pacienta Novák Petr |
| [Panel krevního obrazu](Observation-bloodcount-panel.md) | Panel obsahující základní hematologické hodnoty |
| [Patient - Mracena](Patient-Mracena.md) | Patient, contact information and practitioner |
| [Patient-Novak-Petr](Patient-3f85726c-ad2f-441b-89ce-100000000000.md) | Example of patient Petr Novak with identification by czech national identifiers (RID, RCIS), registrating healthcare provider and contact information |
| [Patient-Novak-Petr-L1](Patient-48a9d440-4194-42c1-87ad-b5a39020a4d0.md) | Example of patient Petr Novak with identification by czech national identifiers (RID, RCIS), registrating healthcare provider and contact information |
| [Pfizer výrobce vakcíny](Organization-Organization-Pfizer.md) | Organizace Pfizer s.r.o. vyrábějící vakcínu Comirnaty proti COVID-19 |
| [Použití kardiostimulátoru](DeviceUseStatement-DeviceUseStatement-Pacemaker.md) | Záznam o implantaci kardiostimulátoru z důvodu bradykardie |
| [Pracovní zapojení](Observation-3f85726c-ad2f-441b-89ce-100000000023.md) | Pacient pracuje na plný úvazek jako programátor. |
| [Practitioner Role for L1 documentr](PractitionerRole-69d34ceb-b556-4f75-9e4c-9184fe8a10c5.md) | Author of HDR document (phisician MUDr.Ivan Anděl) |
| [Practitioner-2](Practitioner-Practitioner-2.md) | Practitioner id(KRZP)=987654321 |
| [Practitioner-Admitter](Practitioner-Practitioner-Admitter.md) | Participant Admitter HDR |
| [Practitioner-Author](Practitioner-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a.md) | Participant Referrer HDR |
| [Practitioner-Author-L1](Practitioner-e234a53a-4e0d-4fb8-9403-e0e324a50f64.md) | Participant Referrer HDR |
| [Practitioner-Author-detail](PractitionerRole-2b7e9637-5018-4542-9faf-d5abdee7b849.md) | practitioner's detail |
| [Practitioner-L1](Practitioner-Practitioner-L1.md) | Practitioner id(KRZP)=987645454 |
| [Practitioner-Referrer](Practitioner-Practitioner-Referrer.md) | Participant Referrer HDR |
| [Practitioner-Referrer-detail](PractitionerRole-Practitioner-Referrer-detail.md) | practitioner's detail |
| [Practitioner-UZV](Practitioner-Practitioner-UZV.md) | Participant UZV HDR |
| [PractitionerRole1](PractitionerRole-practitionerrole1.md) | General practitioner's office |
| [Propouštěcí zpráva](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.md) | Example Composition for Hospital Discharge Report for patient Novák Petr |
| [Propouštěcí zpráva](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md) | Example Composition for Hospital Discharge Report for patient Novák Petr |
| [Propouštěcí zpráva](Composition-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf.md) | Example Composition for Hospital Discharge Report for patient Novák Petr |
| [Propouštěcí zpráva z nemocnice](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c035.md) | Example Composition for Hospital Discharge Report for patient Novák Petr |
| [Sample Czech Location 1](Location-Location-5.md) | Example instance of a location conforming to the CZ_LocationCore profile. |
| [Sample Czech Location 2](Location-cz-Location-Chrudim-Chir1.md) | Example instance of a location conforming to the CZ_LocationCore profile. |
| [Sample Czech Location 2](Location-cz-Location-Chrudim-ChirJIP.md) | Example instance of a location conforming to the CZ_LocationCore profile. |
| [Sample Czech Location 2](Location-sample-cz-location-2.md) | Example instance of a location conforming to the CZ_LocationCore profile. |
| [Sample Czech Location 3](Location-sample-cz-location-3.md) | Example instance of a location conforming to the CZ_LocationCore profile. |
| [Sample Czech Location 4](Location-sample-cz-location-4.md) | Example instance of a location conforming to the CZ_LocationCore profile. |
| [Signature of image order](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab.md) | Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form. |
| [Signature of image order](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb.md) | Czech national profile on Signature holds an electronic representation of a signature or timestamp and its supporting context in a FHIR accessible form. |
| [Sociální síť](Observation-3f85726c-ad2f-441b-89ce-100000000025.md) | Pacient má aktivní sociální síť a pravidelně se setkává s přáteli. |
| [Sova](Practitioner-Sova.md) | Practitioner |
| [Sovak](Practitioner-Sovak.md) | Practitioner |
| [Společenské uplatnění](Observation-3f85726c-ad2f-441b-89ce-100000000022.md) | Pacient je aktivní v komunitních aktivitách a dobrovolnictví. |
| [Stav při propuštění](Observation-3f85726c-ad2f-441b-89ce-100000000021.md) | Hodnocení celkového klinického stavu pacienta při propuštění |
| [Střední podvýživa](Flag-5a17a710-193e-4490-a627-7202925aa56e.md) | Střední podvýživa – doporučení nutriční terapie u pacienta. |
| [Trombocyty](Observation-plt-result.md) | Příklad pro HDR - Počet trombocytů v krvi |
| [UZV - Novák Petr](Observation-e15aeeaf-e288-404c-9704-9c8f0b2d4e3a.md) | Czech HDR - example of an ultrasound observation for Novák Petr |
| [Vzdělání](Observation-3f85726c-ad2f-441b-89ce-100000000027.md) | Pacient má vysokoškolské vzdělání v oboru informatiky. |
| [Vzorek krve – EDTA](Specimen-Specimen-EDTA-1.md) | Venous blood specimen |

 IG © 2025+ [HL7 Czech Republic](https://www.hl7.cz/). Package hl7.fhir.cz.hdr#0.0.2 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-01 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md) 

